/*
 * UnicodeNormalizer 1.0.0
 * Copyright (c) 2008 Matsuza
 * Dual licensed under the MIT (MIT-LICENSE.txt) and GPL (GPL-LICENSE.txt) licenses.
 * $Date: 2008-06-05 16:44:17 +0200 (Thu, 05 Jun 2008) $
 * $Rev: 13309 $
 */
(function(){var DEFAULT_FEATURE=[null,0,{}];var CACHE_THRESHOLD=10;var SBase=0xAC00,LBase=0x1100,VBase=0x1161,TBase=0x11A7,LCount=19,VCount=21,TCount=28;var NCount=VCount*TCount;var SCount=LCount*NCount;var UChar=function(c,f){this.codepoint=c;this.feature=f;};UChar.fromCharCode=function(cp,needFeature){var ctx=arguments.callee;function fromCache(n,c,a){if(!ctx.cache){ctx.cache={};ctx.counter=[];for(var i=0;i<=0xFF;++i){ctx.counter[i]=0;}}var r=ctx.cache[c];if(!r){r=n(c,a);if(!!r.feature&&++ctx.counter[(c>>8)&0xFF]>CACHE_THRESHOLD){ctx.cache[c]=r;}}return r;}function fromData(next,cp,needFeature){var hash=cp&0xFF00;var dunit=UChar.udata[hash];if(dunit==null){dunit=UChar.udata[hash]={};}else if(typeof(dunit)=="string"){dunit=UChar.udata[hash]=eval("("+dunit+")");}var f=dunit[cp];return f?new UChar(cp,f):new UChar(cp,DEFAULT_FEATURE);}function fromCpOnly(n,c,a){return!!a?n(c,a):new UChar(c,null);}function fromRuleBasedJamo(n,a,b){if(a<LBase||(LBase+LCount<=a&&a<SBase)||(SBase+SCount<a)){return n(a,b);}if(LBase<=a&&a<LBase+LCount){var c={};var d=(a-LBase)*VCount;for(var i=0;i<VCount;++i){c[VBase+i]=SBase+TCount*(i+d);}return new UChar(a,[,,c]);}var S=a-SBase;var T=S%TCount;var f=[];if(T!=0){f[0]=[SBase+S-T,TBase+T];}else{f[0]=[LBase+Math.floor(S/NCount),VBase+Math.floor((S%NCount)/TCount)];f[2]={};for(var i=1;i<TCount;++i){f[2][TBase+i]=a+i;}}return new UChar(a,f);}function fromCpFilter(n,c,a){return c<60||13311<c&&c<42607?new UChar(c,DEFAULT_FEATURE):n(c,a);}if(!ctx.strategy){var strategies=[fromCpFilter,fromCache,fromCpOnly,fromRuleBasedJamo,fromData];UChar.fromCharCode.strategy=null;while(strategies.length>0){ctx.strategy=(function(n,s,c,a){return function(c,a){return s(n,c,a);};})(ctx.strategy,strategies.pop(),cp,needFeature);}}return ctx.strategy(cp,needFeature);};UChar.isHighSurrogate=function(c){return c>=0xD800&&c<=0xDBFF;};UChar.isLowSurrogate=function(c){return c>=0xDC00&&c<=0xDFFF;};UChar.prototype.prepFeature=function(){if(!this.feature){this.feature=UChar.fromCharCode(this.codepoint,true).feature;}};UChar.prototype.toString=function(){if(this.codepoint<0x10000){return String.fromCharCode(this.codepoint);}else{var x=this.codepoint-0x10000;return String.fromCharCode(Math.floor(x/0x400)+0xD800,x%0x400+0xDC00);}};UChar.prototype.getDecomp=function(){this.prepFeature();return this.feature[0]||null;};UChar.prototype.isCompatibility=function(){this.prepFeature();return!!this.feature[1]&&(this.feature[1]&(1<<8));};UChar.prototype.isExclude=function(){this.prepFeature();return!!this.feature[1]&&(this.feature[1]&(1<<9));};UChar.prototype.getCanonicalClass=function(){this.prepFeature();return!!this.feature[1]?(this.feature[1]&0xff):0;};UChar.prototype.getComposite=function(f){this.prepFeature();if(!this.feature[2]){return null;}var c=this.feature[2][f.codepoint];return(c!=null)?UChar.fromCharCode(c):null;};var UCharIterator=function(s){this.str=s;this.cursor=0;};UCharIterator.prototype.next=function(){if(!!this.str&&this.cursor<this.str.length){var c=this.str.charCodeAt(this.cursor++);var d;if(UChar.isHighSurrogate(c)&&this.cursor<this.str.length&&UChar.isLowSurrogate((d=this.str.charCodeAt(this.cursor)))){c=(c-0xD800)*0x400+(d-0xDC00)+0x10000;++this.cursor;}return UChar.fromCharCode(c);}else{this.str=null;return null;}};var RecursDecompIterator=function(i,c){this.it=i;this.canonical=c;this.resBuf=[];};RecursDecompIterator.prototype.next=function(){function r(c,u){var d=u.getDecomp();if(!!d&&!(c&&u.isCompatibility())){var b=[];for(var i=0;i<d.length;++i){var a=r(c,UChar.fromCharCode(d[i]));for(var j=0;j<a.length;++j){b.push(a[j]);}}return b;}else{return[u];}}if(this.resBuf.length==0){var u=this.it.next();if(!u){return null;}this.resBuf=r(this.canonical,u);}return this.resBuf.shift();};var DecompIterator=function(i){this.it=i;this.resBuf=[];};DecompIterator.prototype.next=function(){var c;if(this.resBuf.length==0){do{var u=this.it.next();if(!u){break;}c=u.getCanonicalClass();var i=this.resBuf.length;if(c!=0){for(;i>0;--i){var a=this.resBuf[i-1];var b=a.getCanonicalClass();if(b<=c){break;}}}this.resBuf.splice(i,0,u);}while(c!=0);}return this.resBuf.shift();};var CompIterator=function(i){this.it=i;this.procBuf=[];this.resBuf=[];this.lastClass=null;};CompIterator.prototype.next=function(){while(this.resBuf.length==0){var u=this.it.next();if(!u){this.resBuf=this.procBuf;this.procBuf=[];break;}if(this.procBuf.length==0){this.lastClass=u.getCanonicalClass();this.procBuf.push(u);}else{var s=this.procBuf[0];var c=s.getComposite(u);var a=u.getCanonicalClass();if(!!c&&(this.lastClass<a||this.lastClass==0)){this.procBuf[0]=c;}else{if(a==0){this.resBuf=this.procBuf;this.procBuf=[];}this.lastClass=a;this.procBuf.push(u);}}}return this.resBuf.shift();};var createIterator=function(m,s){switch(m){case"NFD":return new DecompIterator(new RecursDecompIterator(new UCharIterator(s),true));case"NFKD":return new DecompIterator(new RecursDecompIterator(new UCharIterator(s),false));case"NFC":return new CompIterator(new DecompIterator(new RecursDecompIterator(new UCharIterator(s),true)));case"NFKC":return new CompIterator(new DecompIterator(new RecursDecompIterator(new UCharIterator(s),false)));}throw m+" is invalid";};var normalize=function(m,s){var i=createIterator(m,s);var r="";var u;while(!!(u=i.next())){r+=u.toString();}return r;};var nfd=function(s){return normalize("NFD",s);};var nfkd=function(s){return normalize("NFKD",s);};var nfc=function(s){return normalize("NFC",s);};var nfkc=function(s){return normalize("NFKC",s);};this.UNorm=this.UNorm||{};var ns=this.UNorm;ns.UChar=UChar;ns.normalize=normalize;ns.createIterator=createIterator;ns.nfd=nfd;ns.nfkd=nfkd;ns.nfc=nfc;ns.nfkc=nfkc;})();
