/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/ui/integration/designtime/baseEditor/validator/ValidatorRegistry","sap/ui/integration/designtime/baseEditor/PropertyEditors","sap/ui/integration/designtime/baseEditor/util/binding/resolveBinding","sap/ui/integration/designtime/baseEditor/util/binding/ObjectBinding","sap/ui/integration/designtime/baseEditor/util/hasTag","sap/ui/integration/designtime/baseEditor/util/cleanupDesigntimeMetadata","sap/ui/core/Control","sap/ui/model/resource/ResourceModel","sap/base/util/ObjectPath","sap/base/util/each","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/values","sap/base/util/includes","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/util/restricted/_intersection","sap/base/util/restricted/_mergeWith","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/restricted/_union","sap/base/util/restricted/_isNil","sap/ui/model/json/JSONModel","sap/base/i18n/ResourceBundle","sap/base/Log","sap/ui/integration/designtime/baseEditor/util/unset"],function(c,P,V,a,r,O,h,b,C,R,d,f,g,i,v,j,k,l,_,m,n,o,p,q,J,s,L,u){"use strict";var t="customProperty--";var S=Promise.resolve();var B=C.extend("sap.ui.integration.designtime.baseEditor.BaseEditor",{metadata:{properties:{"json":{type:"object"},"config":{type:"object",defaultValue:{"i18n":["sap/ui/integration/designtime/baseEditor/i18n/i18n.properties"]}},"designtimeMetadata":{type:"object"},"layout":{type:"string",defaultValue:"list"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true}},events:{jsonChange:{parameters:{json:{type:"object"}}},designtimeMetadataChange:{parameters:{designtimeMetadata:{type:"object"}}},propertyEditorsReady:{parameters:{propertyEditors:{type:"array"}}}}},constructor:function(){this._mObservableConfig={};this._mPropertyEditors={};this._aCancelHandlers=[];this._oDataModel=this._createModel();this._oDesigntimeMetadataModel=this._createModel();this._bInitFinished=false;this._bValidatorsReady=false;this._setReady(false);C.prototype.constructor.apply(this,arguments);this._oDataModel.setData(this._prepareData(this.getJson()));this.attachJsonChange(function(e){var z=e.getParameter("json");this._oDataModel.setData(this._prepareData(z));this._checkReady();},this);},renderer:function(e,z){var A=z.getContent();e.openStart("div",z);e.openEnd();if(A.length){A.forEach(function(D){e.renderControl(D);});}else{z.getPropertyEditorsSync().forEach(function(D){e.renderControl(D);});}e.close("div");}});B.prototype.init=function(){};B.prototype.exit=function(){this._reset();this._oDataModel.destroy();this._oDesigntimeMetadataModel.destroy();};B.prototype._prepareData=function(e){var z=g(e);f(this._mObservableConfig,function(A,D){var E=D.path;if(E[0]==="/"){E=E.substr(1);}if(typeof d.get(E.split("/"),z)==="undefined"&&typeof D.defaultValue!=="undefined"){d.set(E.split("/"),g(D.defaultValue),z);}});return z;};B.prototype.setJson=function(z){var A;if(typeof z==="string"){try{A=JSON.parse(z);}catch(e){L.error("sap.ui.integration.designtime.baseEditor.BaseEditor: invalid JSON string is specified");}}else if(k(z)){A=n({},z);}else{L.error("sap.ui.integration.designtime.baseEditor.BaseEditor: unsupported data type specified in setJson()");}if(A&&JSON.stringify(this.getProperty("json"))!==JSON.stringify(A)){this.setProperty("json",A);this.fireJsonChange({json:A});}};B.prototype.setConfig=function(e,I){this._bIsDefaultConfig=I;e=e||{};S=S.then(function(){P.deregisterAllTypes();return P.registerTypes(e.propertyEditors||{});}).then(function(z){this._initValidators(e.validators||{});var T={propertyEditors:{},properties:{}};if(!e.i18n){T.i18n=this.getMetadata().getProperty("config").getDefaultValue().i18n;}var N=w(T,e);if(this._oSpecificConfig){N=I?this._oSpecificConfig:y(N,this._oSpecificConfig,z);}this.setProperty("config",N,false);this._initialize();}.bind(this));return S;};B.prototype.addConfig=function(e,I){return this.setConfig(w(this.getConfig(),e),I);};function w(T,e){var z=n({},T,e);z.i18n=[].concat(T.i18n||[],e.i18n||[]);return z;}B.prototype._addSpecificConfig=function(e){return S.then(function(){this._oSpecificConfig=e;x(this.getConfig(),e);return this.setConfig(this.getConfig(),this._bIsDefaultConfig);}.bind(this));};function x(e,z){f(z.propertyEditors,function(E,A){if(!e.propertyEditors[E]){e.propertyEditors[E]=A;}});}function y(e,z,A){e.i18n=p(e.i18n,z.i18n);var N=Object.assign({},e,o(z,["properties","i18n","propertyEditors"]),o(e,["properties","i18n","propertyEditors"]));N.properties={};f(e.properties,function(D,E){var F=e.propertyEditors[E.type]&&e.propertyEditors[E.type].split("/").join(".");var G=F&&A[F].configMetadata;if(G&&z.properties[D]){f(E,function(K,T){var H;var M=G[K]&&G[K].mergeStrategy;if(M){if(M==="mostRestrictiveWins"){var I=G[K].mostRestrictiveValue||false;if(T===I){H=I;}else{H=z.properties[D][K];}}else if(M==="intersection"){H=_(T,z.properties[D][K]);}}else{H=T;}N.properties[D]=N.properties[D]||{};N.properties[D][K]=H;});}});return N;}B.prototype.setDesigntimeMetadata=function(D,I){var N=g(D);if(!i(N,this.getDesigntimeMetadata())){this.setProperty("designtimeMetadata",N);this._oDesigntimeMetadataModel.setData(N);if(!I){this.fireDesigntimeMetadataChange({designtimeMetadata:this._formatExportedDesigntimeMetadata(N)});}}};B.prototype._formatExportedDesigntimeMetadata=function(M){var F={};var e=function(z,A){Object.keys(z).forEach(function(K){var D=z[K];if(K==="__value"){F[A.join("/")]=D;}else if(k(D)){e(D,[].concat(A,K));}});};e(M||{},[]);return F;};B.prototype._initValidators=function(e){V.deregisterAllValidators();V.registerValidators(e);V.ready().then(function(){this._bValidatorsReady=true;this._checkReady();}.bind(this));};B.prototype._reset=function(){this._bInitFinished=false;this._setReady(false);this._aCancelHandlers.forEach(function(e){e();});if(this._oI18nModel){this._oI18nModel.destroy();delete this._oI18nModel;}if(this._oConfigObserver){this._oConfigObserver.destroy();}f(this._mPropertyEditors,function(e,z){z.forEach(function(A){this.deregisterPropertyEditor(A,e);},this);}.bind(this));if(this._oRootWrapper){this._oRootWrapper.destroy();}};B.prototype._initialize=function(){this._reset();var e=this.getConfig();if(typeof this.getProperty("json")==="undefined"){this.attachEventOnce("jsonChange",this._initialize);return;}if(e){this._oConfigObserver=new O();this._loadI18nBundles(e.i18n).then(function(z){this._oI18nModel=this._createI18nModel(z);this.setModel(this._oI18nModel,"i18n");this._oConfigObserver.addToIgnore(["template","itemLabel"]);this._oConfigObserver.setModel(this._oDataModel);this._oConfigObserver.setModel(this._oDesigntimeMetadataModel,"designtimeMetadata");this._oConfigObserver.setModel(this._oI18nModel,"i18n");var A=this._getContextPath();if(A){this._oConfigObserver.setModel(this._oDataModel,"context");this._oConfigObserver.setBindingContext(this._oDataModel.getContext(A),"context");}var D=r(e.properties,{"i18n":this._oI18nModel});this._mObservableConfig=Object.assign(this._mObservableConfig,this._prepareConfig(D));this._oConfigObserver.setObject(this._mObservableConfig);this._oConfigObserver.attachChange(this._onConfigChange,this);var E=this.getContent();if(E.length===0||E.length===1&&E[0]===this._oRootWrapper){this.removeAllContent();this._createEditors(this._oConfigObserver.getObject());}this._bInitFinished=true;this._checkReady();}.bind(this));}};B.prototype._onConfigChange=function(e){var z=e.getParameter("changes").reduce(function(D,E){var F=g(E);F.path=F.path.split("/");F.propertyKey=F.path.shift();if(!D[F.propertyKey]){D[F.propertyKey]=[];}D[F.propertyKey].push(F);return D;},{});var A=Object.keys(z).reduce(function(D,E){var F=(this.getPropertyEditorsByNameSync(E)||[]).map(function(G){return{editor:G,propertyName:E};});D=D.concat(F);return D;}.bind(this),[]);var I=A.filter(function(D){return!this._oRootWrapper||!j(this._oRootWrapper._aEditorWrappers,D.editor);}.bind(this));I.forEach(function(D){var E=D.propertyName;var F=e.getSource().getObject();var G=o(g(F[E]),"value");var H=false;var K=z[E]||[];K.forEach(function(N){if(N.path[0]==="value"){D.editor.setValue(N.value);}else{d.set(N.path,N.value,G);H=true;}});if(H){D.editor.setConfig(G);}});if(I.length<A.length){var M=g(this._oRootWrapper.getConfig()).map(function(D){var E=z[D.__propertyName]||[];E.forEach(function(F){d.set(F.path,F.value,D);});return D;});this._oRootWrapper.setConfig(M);}};B.prototype._createModel=function(){var M=new J();M.setDefaultBindingMode("OneWay");return M;};B.prototype._loadI18nBundles=function(e){return this._createPromise(function(z,A){Promise.all(e.map(function(I){return new Promise(function(z,D){s.create({url:sap.ui.require.toUrl(I),async:true}).then(z,D);});})).then(z,A);});};B.prototype._createI18nModel=function(e){var z=e.slice();var I=new R({bundle:z.shift()});I.setDefaultBindingMode("OneWay");z.forEach(function(A){I.enhance(A);});return I;};B.prototype._prepareConfig=function(e){var z={};f(e,function(K,A){z[K]=Object.assign({},this._preparePropertyConfig(A),{__propertyName:K});}.bind(this));return z;};B.prototype._preparePropertyConfig=function(e){var z=this._getContextPath();if(z&&!z.endsWith("/")){z=z+"/";}var A=e.path;if(!A.startsWith("/")&&z){A=z+A;}return Object.assign({},e,{path:A,value:"{"+A+"}",designtime:"{designtimeMetadata>"+A+"}"});};B.prototype._createEditors=function(e){var z=d.get(["layout",this.getLayout()],this.getConfig());if(k(z)||Array.isArray(z)){z=r(z,{"i18n":this._oI18nModel});}this._oRootWrapper=new a({config:v(e),layout:this.getLayout(),layoutConfig:z});this.addContent(this._oRootWrapper);return(Promise.all(v(this._mPropertyEditors).reduce(function(A,D){return A.concat(D);},[]).map(function(A){return A.ready();})).then(this._checkReady.bind(this)));};B.prototype._getRegistrationKey=function(e,K){if(typeof K!=="string"){if(e.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor")&&!e.getConfig()&&!e.getBindingInfo("config")&&e.getPropertyName()){K=e.getPropertyName();}else{K=t+e.getId();}}return K;};B.prototype._addCustomProperty=function(K,e){var z=Object.assign({},this._mObservableConfig);z[K]=this._preparePropertyConfig(e);this._mObservableConfig=z;this._oConfigObserver.setObject(z);};B.prototype._removeCustomProperty=function(K){var e=o(this._mObservableConfig,K);this._mObservableConfig=e;this._oConfigObserver.setObject(e);};B.prototype.registerPropertyEditor=function(e,K){K=this._getRegistrationKey(e,K);var z=Array.isArray(this._mPropertyEditors[K])?this._mPropertyEditors[K]:[];this._mPropertyEditors[K]=z.concat(e);if(K.startsWith(t)){this._addCustomProperty(K,e.getConfig());}var A=d.get(K,this._oConfigObserver.getObject()).value;e.setValue(A);e.attachValueChange(this._onValueChange,this);e.attachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);e.attachReady(this._checkReady,this);};B.prototype.deregisterPropertyEditor=function(e,K){K=this._getRegistrationKey(e,K);var z=this._mPropertyEditors[K];if(K.startsWith(t)){this._removeCustomProperty(K);}e.detachValueChange(this._onValueChange,this);e.detachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);if(Array.isArray(z)){this._mPropertyEditors[K]=z.filter(function(I){return e!==I;});if(this._mPropertyEditors[K].length===0){delete this._mPropertyEditors[K];}}};B.prototype._setReady=function(e){var z=this._bIsReady;this._bIsReady=e;if(z!==true&&e===true){this.firePropertyEditorsReady({propertyEditors:this.getPropertyEditorsSync()});}};B.prototype._checkReady=function(){var e=this.getContent().filter(function(E){return(E.isA("sap.ui.integration.designtime.baseEditor.PropertyEditors")||E.isA("sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"));});e.forEach(function(E){if(!sap.ui.base.EventProvider.hasListener(E,"ready",this._checkReady,this)){E.attachReady(this._checkReady,this);}},this);var A=[].concat(e,this.getPropertyEditorsSync());var I=(this._bInitFinished&&this._bValidatorsReady&&A.every(function(E){return E.isReady();}));this._setReady(I);};B.prototype.isReady=function(){return this._bIsReady;};B.prototype.ready=function(){return new Promise(function(e){if(this.isReady()){e();}else{this.attachEventOnce("propertyEditorsReady",e);}}.bind(this));};B.prototype._createPromise=function(e){var z=c(e);this._aCancelHandlers.push(z.cancel);var A=function(D,E){this._aCancelHandlers=this._aCancelHandlers.filter(function(e){return e!==D;});return E;}.bind(this,z.cancel);return z.promise.then(A,A);};B.prototype.getPropertyConfigByName=function(e){return o(d.get(e,this._oConfigObserver.getObject()),"value");};B.prototype.getPropertyEditorsByName=function(e){return new Promise(function(z){if(!this._mPropertyEditors||Object.keys(this._mPropertyEditors).length===0){this.attachEventOnce("propertyEditorsReady",z);}else{z();}}.bind(this)).then(function(){return this.getPropertyEditorsByNameSync(e);}.bind(this));};B.prototype.getPropertyEditorsByNameSync=function(e){var z=this._mPropertyEditors[e];return Array.isArray(z)&&z.slice()||null;};B.prototype.getPropertyEditorsByTag=function(T){return new Promise(function(e){if(!this._mPropertyEditors||Object.keys(this._mPropertyEditors).length===0){this.attachEventOnce("propertyEditorsReady",e);}else{e();}}.bind(this)).then(function(){return this.getPropertyEditorsByTagSync(T);}.bind(this));};B.prototype.getConfigsByTag=function(T){var e=this.getConfig().properties;return Object.keys(e).filter(function(z){return h(e[z],T);}).map(function(z){return e[z];});};B.prototype.getPropertyEditorsByTagSync=function(T){return this.getPropertyEditorsSync().filter(function(e){return h(e.getConfig(),T);});};B.prototype.getPropertyEditorsSync=function(){return v(this._mPropertyEditors).reduce(function(e,z){return e.concat(z);},[]).sort(function(e,z){return parseInt(e.getId().match(/\d+$/))-parseInt(z.getId().match(/\d+$/));});};B.prototype.getJson=function(){return n({},this.getProperty("json"));};B.prototype.getDesigntimeMetadata=function(){return n({},this.getProperty("designtimeMetadata"));};B.prototype._getContextPath=function(){var e=this.getConfig();var z=e&&e.context||null;if(z&&z[0]!=="/"){z="/"+z;}return z;};B.prototype._onValueChange=function(e){var z=e.getSource();var A=e.getParameter("path");var D=this.getJson()||{};var E=e.getParameter("value");if(A[0]==="/"){A=A.substr(1);}else{throw new Error("BaseEditor._onValueChange: unknown relative path - '"+A+"'");}var F=A.split("/");d.set(F,E,D);if(typeof E==="undefined"||i(E,z.getRuntimeConfig().defaultValue)||Array.isArray(E)&&E.length===0||k(E)&&l(E)){u(D,F);}this.setJson(D);};B.prototype._onDesigntimeMetadataChange=function(e){var z=e.getParameter("path");var D=this.getDesigntimeMetadata()||{};var A=e.getParameter("value");if(z[0]==="/"){z=z.substr(1);}else{throw new Error("BaseEditor._onDesigntimeMetadataChange: unknown relative path - '"+z+"'");}var E=z.split("/");d.set(E,A,D);b(D);this.setDesigntimeMetadata(D);};return B;});
