/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.getCore().loadLibrary("sap.ui.unified");sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/Device','./InputBase','./DateTimeField','./Button','./ResponsivePopover','sap/ui/core/date/UniversalDate','./library','sap/ui/core/Control','sap/ui/core/library',"./DatePickerRenderer","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/IconPool","./InstanceManager","sap/ui/unified/Calendar","sap/ui/unified/DateRange",'sap/ui/unified/DateTypeRange',"sap/ui/unified/calendar/CustomMonthPicker","sap/ui/unified/calendar/CustomYearPicker","sap/ui/unified/library","sap/ui/dom/jquery/cursorPos"],function(q,D,I,a,B,R,U,l,C,c,b,d,e,L,f,g,h,j,k,m,n,u){"use strict";var o=c.CalendarType;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var p=a.extend("sap.m.DatePicker",{metadata:{library:"sap.m",properties:{displayFormatType:{type:"string",group:"Appearance",defaultValue:""},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showFooter:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{specialDates:{type:"sap.ui.core.Element",multiple:true,singularName:"specialDate"},_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},associations:{legend:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{parameters:{dateRange:{type:"sap.ui.unified.DateRange"},afterPopupOpened:{type:"boolean"}}}},designtime:"sap/m/designtime/DatePicker.designtime",dnd:{draggable:false,droppable:true}}});p.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=false;this._bOnlyCalendar=true;this._bValid=true;this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,999);var i=this.addEndIcon({id:this.getId()+"-icon",src:this.getIconSrc(),noTabStop:true,tooltip:r.getText("OPEN_PICKER_TEXT")});this._bShouldClosePicker=false;i.addEventDelegate({onmousedown:function(E){this._bShouldClosePicker=!!this.isOpen();}},this);i.attachPress(function(){this.toggleOpen(this._bShouldClosePicker);},this);};p.prototype.isValidValue=function(){return this._bValid;};p.prototype.isOpen=function(){return this._oPopup&&this._oPopup.isOpen();};p.prototype.toggleOpen=function(O){if(this.getEditable()&&this.getEnabled()){if(O){s.call(this);}else{_.call(this);}}};p.prototype.getIconSrc=function(){return f.getIconURI("appointment-2");};p.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._getCalendar()){this._getCalendar().destroy();delete this._getCalendar();}if(this._iInvalidateCalendar){clearTimeout(this._iInvalidateCalendar);}this._sUsedDisplayPattern=undefined;this._sUsedDisplayCalendarType=undefined;this._oDisplayFormat=undefined;this._sUsedValuePattern=undefined;this._sUsedValueCalendarType=undefined;this._oValueFormat=undefined;};p.prototype.invalidate=function(O){if(!O||O!=this._getCalendar()){C.prototype.invalidate.apply(this,arguments);this._iInvalidateCalendar=setTimeout(y.bind(this),0);}};p.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this._checkMinMaxDate();var V=this._getValueHelpIcon();if(V){V.setProperty("visible",this.getEditable(),true);}};p.prototype.setWidth=function(W){return I.prototype.setWidth.call(this,W||"100%");};p.prototype.getWidth=function(W){return this.getProperty("width")||"100%";};p.prototype.applyFocusInfo=function(F){this._bFocusNoPopup=true;if(!D.support.touch||D.system.desktop){I.prototype.applyFocusInfo.apply(this,arguments);}};p.prototype.onfocusin=function(E){if(!q(E.target).hasClass("sapUiIcon")){I.prototype.onfocusin.apply(this,arguments);}this._bFocusNoPopup=undefined;};p.prototype.onsapshow=function(E){this.toggleOpen(this.isOpen());E.preventDefault();};p.prototype.onsaphide=p.prototype.onsapshow;p.prototype.onsappageup=function(E){var i=this._getCalendarConstructor().getMetadata().getName();E.preventDefault();if(i!="sap.ui.unified.Calendar"){return;}this._increaseDate(1,"day");};p.prototype.onsappageupmodifiers=function(E){var i=this._getCalendarConstructor().getMetadata().getName();E.preventDefault();if(!E.ctrlKey&&E.shiftKey){if(i=="sap.ui.unified.internal.CustomYearPicker"){return;}this._increaseDate(1,"month");}else{this._increaseDate(1,"year");}};p.prototype.onsappagedown=function(E){var i=this._getCalendarConstructor().getMetadata().getName();E.preventDefault();if(i!="sap.ui.unified.Calendar"){return;}this._increaseDate(-1,"day");};p.prototype.onsappagedownmodifiers=function(E){var i=this._getCalendarConstructor().getMetadata().getName();E.preventDefault();if(!E.ctrlKey&&E.shiftKey){if(i=="sap.ui.unified.internal.CustomYearPicker"){return;}this._increaseDate(-1,"month");}else{this._increaseDate(-1,"year");}};p.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var F=this._getFormatter(true);var i=String.fromCharCode(E.charCode);if(i&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(i)<0){E.preventDefault();}};p.prototype._getValueHelpIcon=function(){var V=this.getAggregation("_endIcon");return V&&V[0];};p.prototype._dateValidation=function(i){this._bValid=true;if(i&&(i.getTime()<this._oMinDate.getTime()||i.getTime()>this._oMaxDate.getTime())){this._bValid=false;e(this._bValid,"Date must be in valid range");}this.setProperty("dateValue",i);return i;};p.prototype.setMinDate=function(i){if(!this._isValidDate(i)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMinDate(),i)){return this;}if(i){var Y=i.getFullYear();if(Y<1||Y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMinDate=new Date(i.getTime());var z=this.getDateValue();if(z&&z.getTime()<i.getTime()){this._bValid=false;L.warning("DateValue not in valid date range",this);}}else{this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);}this.setProperty("minDate",i);if(this._getCalendar()){this._getCalendar().setMinDate(i);}this._oMinDate.setHours(0,0,0,0);return this;};p.prototype.setMaxDate=function(i){if(!this._isValidDate(i)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMaxDate(),i)){return this;}if(i){var Y=i.getFullYear();if(Y<1||Y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMaxDate=new Date(i.getTime());var z=this.getDateValue();if(z&&z.getTime()>i.getTime()){this._bValid=false;L.warning("DateValue not in valid date",this);}}else{this._oMaxDate=new Date(9999,11,31,23,59,59,999);}this.setProperty("maxDate",i);if(this._getCalendar()){this._getCalendar().setMaxDate(i);}this._oMaxDate.setHours(23,59,59,999);return this;};p.prototype._checkMinMaxDate=function(){if(this._oMinDate.getTime()>this._oMaxDate.getTime()){L.warning("minDate > MaxDate -> dates switched",this);var M=new Date(this._oMinDate.getTime());var i=new Date(this._oMaxDate.getTime());this._oMinDate=new Date(i.getTime());this._oMaxDate=new Date(M.getTime());this.setProperty("minDate",i,true);this.setProperty("maxDate",M,true);if(this._getCalendar()){this._getCalendar().setMinDate(i);this._getCalendar().setMaxDate(M);}}var z=this.getDateValue();if(z&&(z.getTime()<this._oMinDate.getTime()||z.getTime()>this._oMaxDate.getTime())){this._bValid=false;L.error("dateValue "+z.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain dateValue/value accordingly.",this);}};p.prototype.getDisplayFormatType=function(){return this.getProperty("displayFormatType");};p.prototype._handleDateValidation=function(i){this._bValid=true;if(!i||i.getTime()<this._oMinDate.getTime()||i.getTime()>this._oMaxDate.getTime()){this._bValid=false;L.warning("Value can not be converted to a valid date",this);}var V=this._formatValue(i,true);if(V!==this.getValue()){this.setLastValue(V);}this.setProperty("value",V);this.setProperty("dateValue",i);};p.prototype.setDisplayFormatType=function(i){if(i){var F=false;for(var T in o){if(T==i){F=true;break;}}if(!F){throw new Error(i+" is not a valid calendar type"+this);}}this.setProperty("displayFormatType",i,true);this.setDisplayFormat(this.getDisplayFormat());return this;};p.prototype.setSecondaryCalendarType=function(i){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",i,true);if(this._getCalendar()){this._getCalendar().setSecondaryCalendarType(i);}return this;};p.prototype.setShowFooter=function(F){var P=this._oPopup,i=this._getCalendar();this.setProperty("showFooter",F);if(!P||!i){return this;}P._getButtonFooter().setVisible(F);return this;};p.prototype.addSpecialDate=function(S){x.call(this,S);this.addAggregation("specialDates",S,true);y.call(this);return this;};p.prototype.insertSpecialDate=function(S,i){x.call(this,S);this.insertAggregation("specialDates",S,i,true);y.call(this);return this;};p.prototype.removeSpecialDate=function(S){var i=this.removeAggregation("specialDates",S,true);y.call(this);return i;};p.prototype.removeAllSpecialDates=function(){var i=this.removeAllAggregation("specialDates",true);y.call(this);return i;};p.prototype.destroySpecialDates=function(){this.destroyAggregation("specialDates",true);y.call(this);return this;};p.prototype.setLegend=function(i){this.setAssociation("legend",i,true);var z=this.getLegend();if(z){var A=sap.ui.require("sap/ui/unified/CalendarLegend");i=sap.ui.getCore().byId(z);if(i&&!(typeof A=="function"&&i instanceof A)){throw new Error(i+" is not an sap.ui.unified.CalendarLegend. "+this);}}if(this._getCalendar()){this._getCalendar().setLegend(z);}return this;};p.prototype.onChange=function(E){if(!this.getEditable()||!this.getEnabled()){return;}var V=this._$input.val(),O=this._formatValue(this.getDateValue()),i;if(V==O&&this._bValid){return;}if(this.getShowFooter()&&this._oPopup&&!V){this._oPopup.getBeginButton().setEnabled(false);}this._bValid=true;if(V!=""){i=this._parseValue(V,true);if(!i||i.getTime()<this._oMinDate.getTime()||i.getTime()>this._oMaxDate.getTime()){this._bValid=false;i=undefined;}else{V=this._formatValue(i);}}if(this.getDomRef()&&(this._$input.val()!==V)){this._$input.val(V);this._curpos=this._$input.cursorPos();}if(i){V=this._formatValue(i,true);}if(this.getLastValue()!==V||(i&&this.getDateValue()&&i.getFullYear()!==this.getDateValue().getFullYear())){this.setLastValue(V);this.setProperty("value",V,true);var N=this.getValue();if(this._bValid&&V==N){this.setProperty("dateValue",i,true);}V=N;if(this.isOpen()){if(this._bValid){i=this.getDateValue();}this._getCalendar().focusDate(i);var S=this._oDateRange.getStartDate();if((!S&&i)||(S&&i&&S.getTime()!=i.getTime())){this._oDateRange.setStartDate(new Date(i.getTime()));}else if(S&&!i){this._oDateRange.setStartDate(undefined);}}this.fireChangeEvent(V,{valid:this._bValid});}};p.prototype._getInputValue=function(V){V=(typeof V=="undefined")?this._$input.val():V.toString();var i=this._parseValue(V,true);V=this._formatValue(i,true);return V;};p.prototype.updateDomValue=function(V){if(this.isActive()&&(this._$input.val()!==V)){this._bCheckDomValue=true;V=(typeof V=="undefined")?this._$input.val():V.toString();this._curpos=this._$input.cursorPos();var i=this._parseValue(V,true);V=this._formatValue(i);this._$input.val(V);if(document.activeElement===this._$input[0]){this._$input.cursorPos(this._curpos);}}return this;};p.prototype._storeInputSelection=function(i){if((D.browser.msie||D.browser.edge)&&!D.support.touch){this._oInputSelBeforePopupOpen={iStart:i.selectionStart,iEnd:i.selectionEnd};i.selectionStart=0;i.selectionEnd=0;}};p.prototype._restoreInputSelection=function(i){if((D.browser.msie||D.browser.edge)&&!D.support.touch){i.selectionStart=this._oInputSelBeforePopupOpen.iStart;i.selectionEnd=this._oInputSelBeforePopupOpen.iEnd;}};function _(){this._createPopup();this._createPopupContent();var i;var z=this.getBinding("value");if(z&&z.oType&&z.oType.oOutputFormat){i=z.oType.oOutputFormat.oFormatOptions.calendarType;}else if(z&&z.oType&&z.oType.oFormat){i=z.oType.oFormat.oFormatOptions.calendarType;}if(!i){i=this.getDisplayFormatType();}if(i){this._getCalendar().setPrimaryCalendarType(i);}var V=this._bValid?this._formatValue(this.getDateValue()):this.getValue();if(V!=this._$input.val()){this.onChange();}this._fillDateRange();this._openPopup();this.fireNavigate({dateRange:this._getVisibleDatesRange(this._getCalendar()),afterPopupOpened:true});}p.prototype._createPopup=function(){var i,z;if(!this._oPopup){this._oPopup=new R(this.getId()+"-RP",{showCloseButton:false,showArrow:false,showHeader:false,placement:l.PlacementType.VerticalPreferedBottom,beginButton:new B({type:l.ButtonType.Emphasized,text:r.getText("DATEPICKER_SELECTION_CONFIRM"),press:this._handleOKButton.bind(this)}),afterOpen:t.bind(this),afterClose:v.bind(this)}).addStyleClass("sapMRPCalendar");if(this.getShowFooter()){this._oPopup.addStyleClass("sapMLandscapePadding");}this._oPopup._getPopup().setAutoClose(true);if(D.system.phone){i=this.$("inner").attr("aria-labelledby");z=i?document.getElementById(i).getAttribute("aria-label"):"";this._oPopup.setTitle(z);this._oPopup.setShowHeader(true);this._oPopup.setShowCloseButton(true);}else{this._oPopup._getPopup().setDurations(0,0);this._oPopup.setEndButton(new B({text:r.getText("DATEPICKER_SELECTION_CANCEL"),press:this._handleCancelButton.bind(this)}));}this.setAggregation("_popup",this._oPopup,true);}};p.prototype._openPopup=function(){if(!this._oPopup){return;}this._storeInputSelection(this._$input.get(0));this._oPopup._getPopup().setAutoCloseAreas([this.getDomRef()]);this._oPopup.openBy(this);};p.prototype._getVisibleDatesRange=function(i){var V=i._getVisibleDays();return new j({startDate:V[0].toLocalJSDate(),endDate:V[V.length-1].toLocalJSDate()});};p.prototype._createPopupContent=function(){var i=this._getCalendarConstructor();if(!this._getCalendar()){this._oCalendar=new i(this.getId()+"-cal",{intervalSelection:this._bIntervalSelection,minDate:this.getMinDate(),maxDate:this.getMaxDate(),legend:this.getLegend(),startDateChange:function(){this.fireNavigate({dateRange:this._getVisibleDatesRange(this._getCalendar())});}.bind(this)});this._oDateRange=new j();this._getCalendar().addSelectedDate(this._oDateRange);this._getCalendar()._setSpecialDatesControlOrigin(this);this._getCalendar().attachCancel(s,this);this._getCalendar().setPopupMode(true);if(this.$().closest(".sapUiSizeCompact").length>0){this._getCalendar().addStyleClass("sapUiSizeCompact");}if(this._bSecondaryCalendarTypeSet){this._getCalendar().setSecondaryCalendarType(this.getSecondaryCalendarType());}if(this._bOnlyCalendar){this._getCalendar().attachSelect(this._handleCalendarSelect,this);this._getCalendar().attachEvent("_renderMonth",w,this);this._oPopup._getButtonFooter().setVisible(this.getShowFooter());this._getCalendar()._bSkipCancelButtonRendering=true;this._oPopup.addContent(this._getCalendar());if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false);}}}};p.prototype._getCalendarConstructor=function(){var P=this._getFormatter(true).aFormatArray.map(function(z){return z.type.toLowerCase();}),i=P.indexOf("day")>=0,M=P.indexOf("month")>=0,Y=P.indexOf("year")>=0;if(i&&M&&Y){return h;}else if(M&&Y){return m;}else if(Y){return n;}else{L.warning("Not valid date pattern! Default Calendar constructor function is returned",this);return h;}};p.prototype._fillDateRange=function(){var i=this.getDateValue();if(i&&i.getTime()>=this._oMinDate.getTime()&&i.getTime()<=this._oMaxDate.getTime()){this._getCalendar().focusDate(new Date(i.getTime()));if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=i.getTime()){this._oDateRange.setStartDate(new Date(i.getTime()));}}else{var z=this.getInitialFocusedDateValue();var F=z?z:new Date();var M=this._oMaxDate.getTime();if(F.getTime()<this._oMinDate.getTime()||F.getTime()>M){F=this._oMinDate;}this._getCalendar().focusDate(F);if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}};p.prototype.getAccessibilityInfo=function(){var i=this.getRenderer();var z=I.prototype.getAccessibilityInfo.apply(this,arguments);var V=this.getValue()||"";if(this._bValid){var A=this.getDateValue();if(A){V=this._formatValue(A);}}z.type=r.getText("ACC_CTR_TYPE_DATEINPUT");z.description=[V,i.getLabelledByAnnouncement(this),i.getDescribedByAnnouncement(this)].join(" ").trim();return z;};p.prototype._selectDate=function(){var i=this.getDateValue(),z=this._getSelectedDate(),V="";if(!d(z,i)){this.setDateValue(new Date(z.getTime()));V=this.getValue();this.fireChangeEvent(V,{valid:true});this._focusInput();}else if(!this._bValid){V=this._formatValue(z);if(V!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(V);this.setLastValue(V);}V=this._formatValue(z,true);this.setProperty("value",V,true);this.fireChangeEvent(V,{valid:true});this._focusInput();}}else if(D.system.desktop||!D.support.touch){this.focus();}this._oPopup.close();};p.prototype._handleCalendarSelect=function(){if(this.getShowFooter()){this._oPopup.getBeginButton().setEnabled(true);return;}this._selectDate();};p.prototype._focusInput=function(){if(this.getDomRef()&&(D.system.desktop||!D.support.touch)){this._curpos=this._$input.val().length;this._$input.cursorPos(this._curpos);}return this;};p.prototype._getCalendar=function(){return this._oCalendar;};p.prototype._getSelectedDate=function(){var S=this._getCalendar().getSelectedDates(),i;if(S.length>0){i=S[0].getStartDate();}return i;};p.prototype._handleOKButton=function(){this._selectDate();};p.prototype._handleCancelButton=function(){if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false);}this._oPopup.close();};function s(E){if(this.isOpen()){this._oPopup.close();if((D.system.desktop||!D.support.touch)){this.focus();}}}p.prototype._increaseDate=function(N,i){var O=this.getDateValue();var z=this._$input.cursorPos();if(O&&this.getEditable()&&this.getEnabled()){var A;var E=this.getBinding("value");if(E&&E.oType&&E.oType.oOutputFormat){A=E.oType.oOutputFormat.oFormatOptions.calendarType;}else if(E&&E.oType&&E.oType.oFormat){A=E.oType.oFormat.oFormatOptions.calendarType;}if(!A){A=this.getDisplayFormatType();}var F=U.getInstance(new Date(O.getTime()),A);O=U.getInstance(new Date(O.getTime()),A);switch(i){case"day":F.setDate(F.getDate()+N);break;case"month":F.setMonth(F.getMonth()+N);var M=(O.getMonth()+N)%12;if(M<0){M=12+M;}while(F.getMonth()!=M){F.setDate(F.getDate()-1);}break;case"year":F.setFullYear(F.getFullYear()+N);while(F.getMonth()!=O.getMonth()){F.setDate(F.getDate()-1);}break;default:break;}if(F.getTime()<this._oMinDate.getTime()){F=new U(this._oMinDate.getTime());}else if(F.getTime()>this._oMaxDate.getTime()){F=new U(this._oMaxDate.getTime());}if(!d(this.getDateValue(),F.getJSDate())){this.setDateValue(new Date(F.getTime()));this._curpos=z;this._$input.cursorPos(this._curpos);var V=this.getValue();this.fireChangeEvent(V,{valid:true});}}};p.prototype._getSpecialDates=function(){var z=this.getSpecialDates();for(var i=0;i<z.length;i++){var N=z[i].getSecondaryType()===u.CalendarDayType.NonWorking&&z[i].getType()!==u.CalendarDayType.NonWorking;if(N){var A=new k();A.setType(z[i].getSecondaryType());A.setStartDate(z[i].getStartDate());if(z[i].getEndDate()){A.setEndDate(z[i].getEndDate());}z.push(A);}}return z;};function t(){this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);this._renderedDays=this._getCalendar().$("-Month0-days").find(".sapUiCalItem").length;this.$("inner").attr("aria-owns",this.getId()+"-cal");this.$("inner").attr("aria-expanded",true);g.addPopoverInstance(this._oPopup);this._getCalendar().focus();}function v(){if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false);}this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);this.$("inner").attr("aria-expanded",false);this._restoreInputSelection(this._$input.get(0));this._getCalendar()._closedPickers();g.removePopoverInstance(this._oPopup);}function w(E){var i=E.getParameter("days"),P=this._oPopup._getPopup();if(i>this._renderedDays){this._renderedDays=i;P._applyPosition(P._oLastPosition);}}function x(S){var k=sap.ui.require("sap/ui/unified/DateTypeRange");if(S&&!(k&&S instanceof k)){throw new Error(S+"is not valid for aggregation \"specialDates\" of "+this);}}function y(){if(this.isOpen()){this._getCalendar()._bDateRangeChanged=false;this._getCalendar().invalidate();}}return p;});
