/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.TemplateVariable;
import com.intellij.util.containers.ContainerUtil;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;

public final class GenericRepositoryUtil {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{(\\w[-\\w]*)\\}");

    public static HttpMethod getPostMethodFromURL(String requestUrl) {
        int n = requestUrl.indexOf(63);
        if (n == -1) {
            return new PostMethod(requestUrl);
        }
        PostMethod postMethod = new PostMethod(requestUrl.substring(0, n));
        Object[] queryParams = requestUrl.substring(n + 1).split("&");
        postMethod.addParameters((NameValuePair[])ContainerUtil.map2Array((Object[])queryParams, NameValuePair.class, s -> {
            String[] nv = s.split("=");
            if (nv.length == 1) {
                return new NameValuePair(nv[0], "");
            }
            return new NameValuePair(nv[0], nv[1]);
        }));
        return postMethod;
    }

    public static String substituteTemplateVariables(String s, Collection<? extends TemplateVariable> variables) throws Exception {
        return GenericRepositoryUtil.substituteTemplateVariables(s, variables, true);
    }

    public static String substituteTemplateVariables(String s, Collection<? extends TemplateVariable> variables, boolean escape) throws Exception {
        HashMap<String, String> lookup = new HashMap<String, String>();
        for (TemplateVariable templateVariable : variables) {
            lookup.put(templateVariable.getName(), templateVariable.getValue());
        }
        StringBuilder sb = new StringBuilder();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(s);
        while (matcher.find()) {
            String name = matcher.group(1);
            String replacement = (String)lookup.get(name);
            if (replacement == null) {
                throw new Exception(String.format("Template variable '%s' is undefined", name));
            }
            if (escape && !name.equals("serverUrl")) {
                matcher.appendReplacement(sb, URLEncoder.encode(replacement, StandardCharsets.UTF_8));
                continue;
            }
            matcher.appendReplacement(sb, replacement);
        }
        return matcher.appendTail(sb).toString();
    }

    public static List<String> createPlaceholdersList(GenericRepository repository) {
        return GenericRepositoryUtil.createPlaceholdersList(repository.getAllTemplateVariables());
    }

    public static List<String> createPlaceholdersList(List<? extends TemplateVariable> variables) {
        return ContainerUtil.map2List(variables, variable -> String.format("{%s}", variable.getName()));
    }

    @NlsContexts.Label
    public static String prettifyVariableName(@NlsContexts.Label String variableName) {
        String prettyName = variableName.replace('_', ' ');
        return StringUtil.capitalizeWords((String)prettyName, (boolean)true);
    }

    public static <T> List<T> concat(List<? extends T> list, T ... values) {
        return ContainerUtil.append(list, (Object[])values);
    }
}

