/*
 * Decompiled with CFR 0.152.
 */
package training.learn.lesson.general;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LessonContext;
import training.dsl.LessonSample;
import training.dsl.LessonUtil;
import training.dsl.LessonUtilKt;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.dsl.TaskTestContext;
import training.learn.LearnBundle;
import training.learn.LessonsBundle;
import training.learn.course.KLesson;
import training.learn.lesson.general.SurroundAndUnwrapLesson;
import training.util.UtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u00052\u0006\u0010'\u001a\u00020\u0005H\u0002J%\u0010(\u001a\u00020\u000b*\u00020)2\u0017\u0010*\u001a\u0013\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020%0\t\u00a2\u0006\u0002\b\fH\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R%\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u001fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0012\u0010\"\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001d\u00a8\u0006,"}, d2={"Ltraining/learn/lesson/general/SurroundAndUnwrapLesson;", "Ltraining/learn/course/KLesson;", "()V", "helpLinks", "", "", "getHelpLinks", "()Ljava/util/Map;", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "lineShiftBeforeUnwrap", "", "getLineShiftBeforeUnwrap", "()I", "sample", "Ltraining/dsl/LessonSample;", "getSample", "()Ltraining/dsl/LessonSample;", "suitableTips", "", "getSuitableTips", "()Ljava/util/List;", "surroundItemName", "getSurroundItemName", "()Ljava/lang/String;", "surroundItems", "", "getSurroundItems", "()[Ljava/lang/String;", "unwrapTryText", "getUnwrapTryText", "wordIsPresent", "", "text", "word", "proposeIfModified", "Ltraining/dsl/TaskContext;", "checkCaret", "Ltraining/dsl/TaskRuntimeContext;", "intellij.featuresTrainer"})
public abstract class SurroundAndUnwrapLesson
extends KLesson {
    @NotNull
    private final List<String> suitableTips = CollectionsKt.listOf((Object)"SurroundWith");
    @NotNull
    private final Map<String, String> helpLinks = MapsKt.mapOf((Pair[])new Pair[]{new Pair((Object)LessonsBundle.INSTANCE.message("surround.and.unwrap.help.surround.code.fragments", new Object[0]), (Object)LessonUtil.INSTANCE.getHelpLink("surrounding-blocks-of-code-with-language-constructs.html")), new Pair((Object)LessonsBundle.INSTANCE.message("surround.and.unwrap.help.unwrapping.and.removing.statements", new Object[0]), (Object)LessonUtil.INSTANCE.getHelpLink("working-with-source-code.html#unwrap_remove_statement"))});

    @NotNull
    protected abstract LessonSample getSample();

    @NotNull
    protected abstract String[] getSurroundItems();

    protected abstract int getLineShiftBeforeUnwrap();

    @NotNull
    protected abstract String getUnwrapTryText();

    @NotNull
    protected String getSurroundItemName() {
        return ArraysKt.joinToString$default((Object[])this.getSurroundItems(), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    protected Function1<LessonContext, Unit> getLessonContent() {
        return (Function1)new Function1<LessonContext, Unit>(this){
            final /* synthetic */ SurroundAndUnwrapLesson this$0;

            public final void invoke(@NotNull LessonContext $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                LessonContext.prepareSample$default($receiver, this.this$0.getSample(), false, 2, null);
                $receiver.task("SurroundWith", (Function2<? super TaskContext, ? super String, Unit>)((Function2)new Function2<TaskContext, String, Unit>(this){
                    final /* synthetic */ lessonContent.1 this$0;

                    public final void invoke(@NotNull TaskContext $this$task, @NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$receiver");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        SurroundAndUnwrapLesson.access$proposeIfModified(this.this$0.this$0, $this$task, (Function1)new Function1<TaskRuntimeContext, Boolean>(this){
                            final /* synthetic */ lessonContent.1 this$0;

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final boolean invoke(@NotNull TaskRuntimeContext $this$proposeIfModified) {
                                Intrinsics.checkNotNullParameter((Object)$this$proposeIfModified, (String)"$receiver");
                                CaretModel caretModel = $this$proposeIfModified.getEditor().getCaretModel();
                                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                                Caret caret2 = caretModel.getCurrentCaret();
                                Intrinsics.checkNotNullExpressionValue((Object)caret2, (String)"editor.caretModel.currentCaret");
                                Pair<Integer, Integer> pair = this.this$0.this$0.this$0.getSample().getSelection();
                                if (pair == null) return true;
                                if (caret2.getSelectionStart() != ((Number)pair.getFirst()).intValue()) return true;
                                CaretModel caretModel2 = $this$proposeIfModified.getEditor().getCaretModel();
                                Intrinsics.checkNotNullExpressionValue((Object)caretModel2, (String)"editor.caretModel");
                                Caret caret3 = caretModel2.getCurrentCaret();
                                Intrinsics.checkNotNullExpressionValue((Object)caret3, (String)"editor.caretModel.currentCaret");
                                Pair<Integer, Integer> pair2 = this.this$0.this$0.this$0.getSample().getSelection();
                                if (pair2 == null) return true;
                                if (caret3.getSelectionEnd() == ((Number)pair2.getSecond()).intValue()) return false;
                                return true;
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("surround.and.unwrap.invoke.surround", $this$task.action(it)), null, 2, null);
                        TaskContext.triggerAndBorderHighlight$default($this$task, null, 1, null).listItem((Function2<? super TaskRuntimeContext, Object, Boolean>)((Function2)new Function2<TaskRuntimeContext, Object, Boolean>(this){
                            final /* synthetic */ lessonContent.1 this$0;

                            public final boolean invoke(@NotNull TaskRuntimeContext $this$listItem, @NotNull Object item) {
                                boolean bl;
                                block1: {
                                    Intrinsics.checkNotNullParameter((Object)$this$listItem, (String)"$receiver");
                                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                                    String[] $this$all$iv = this.this$0.this$0.this$0.getSurroundItems();
                                    boolean $i$f$all = false;
                                    int n = $this$all$iv.length;
                                    for (int i = 0; i < n; ++i) {
                                        String element$iv;
                                        String need = element$iv = $this$all$iv[i];
                                        boolean bl2 = false;
                                        if (SurroundAndUnwrapLesson.access$wordIsPresent(this.this$0.this$0.this$0, UtilsKt.toNullableString(item), need)) continue;
                                        bl = false;
                                        break block1;
                                    }
                                    bl = true;
                                }
                                return bl;
                            }
                            {
                                this.this$0 = var1_1;
                                super(2);
                            }
                        }));
                        TaskContext.test$default($this$task, false, (Function1)new Function1<TaskTestContext, Unit>(it){
                            final /* synthetic */ String $it;

                            public final void invoke(@NotNull TaskTestContext $this$test) {
                                Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$receiver");
                                $this$test.actions(this.$it);
                            }
                            {
                                this.$it = string;
                                super(1);
                            }
                        }, 1, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                }));
                $receiver.task((Function1<? super TaskContext, Unit>)((Function1)new Function1<TaskContext, Unit>(this){
                    final /* synthetic */ lessonContent.1 this$0;

                    public final void invoke(@NotNull TaskContext $this$task) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$receiver");
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("surround.and.unwrap.choose.surround.item", $this$task.strong(this.this$0.this$0.getSurroundItemName())), null, 2, null);
                        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)new Function1<TaskRuntimeContext, Boolean>(this){
                            final /* synthetic */ lessonContent.2 this$0;

                            public final boolean invoke(@NotNull TaskRuntimeContext $this$stateCheck) {
                                boolean bl;
                                block1: {
                                    CharSequence charSequence;
                                    Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$receiver");
                                    Document document = $this$stateCheck.getEditor().getDocument();
                                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                                    CharSequence sequence = charSequence = document.getCharsSequence();
                                    boolean bl2 = false;
                                    String[] $this$all$iv = this.this$0.this$0.this$0.getSurroundItems();
                                    boolean $i$f$all = false;
                                    int n = $this$all$iv.length;
                                    for (int i = 0; i < n; ++i) {
                                        String element$iv;
                                        String it = element$iv = $this$all$iv[i];
                                        boolean bl3 = false;
                                        CharSequence charSequence2 = sequence;
                                        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"sequence");
                                        if (StringsKt.contains$default((CharSequence)charSequence2, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                                        bl = false;
                                        break block1;
                                    }
                                    bl = true;
                                }
                                return bl;
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                        TaskContext.restoreByUi$default($this$task, null, 0, null, 7, null);
                        TaskContext.test$default($this$task, false, (Function1)new Function1<TaskTestContext, Unit>(this){
                            final /* synthetic */ lessonContent.2 this$0;

                            public final void invoke(@NotNull TaskTestContext $this$test) {
                                Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$receiver");
                                $this$test.type(ArraysKt.joinToString$default((Object[])this.this$0.this$0.this$0.getSurroundItems(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\n");
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }, 1, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                LessonContext.prepareRuntimeTask$default($receiver, null, (Function1)new Function1<TaskRuntimeContext, Unit>(this){
                    final /* synthetic */ lessonContent.1 this$0;

                    public final void invoke(@NotNull TaskRuntimeContext $this$prepareRuntimeTask) {
                        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$receiver");
                        CaretModel caretModel = $this$prepareRuntimeTask.getEditor().getCaretModel();
                        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                        caretModel.getCurrentCaret().moveCaretRelatively(0, this.this$0.this$0.getLineShiftBeforeUnwrap(), false, true);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, 1, null);
                LessonContext.prepareRuntimeTask$default($receiver, null, lessonContent.4.INSTANCE, 1, null);
                $receiver.task("Unwrap", (Function2<? super TaskContext, ? super String, Unit>)((Function2)new Function2<TaskContext, String, Unit>(this){
                    final /* synthetic */ lessonContent.1 this$0;

                    public final void invoke(@NotNull TaskContext $this$task, @NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$receiver");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        SurroundAndUnwrapLesson.access$proposeIfModified(this.this$0.this$0, $this$task, lessonContent.1.INSTANCE);
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("surround.and.unwrap.invoke.unwrap", $this$task.action(it)), null, 2, null);
                        TaskContext.triggerAndBorderHighlight$default($this$task, null, 1, null).listItem((Function2<? super TaskRuntimeContext, Object, Boolean>)((Function2)new Function2<TaskRuntimeContext, Object, Boolean>(this){
                            final /* synthetic */ lessonContent.5 this$0;

                            public final boolean invoke(@NotNull TaskRuntimeContext $this$listItem, @NotNull Object item) {
                                Intrinsics.checkNotNullParameter((Object)$this$listItem, (String)"$receiver");
                                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                                return Intrinsics.areEqual((Object)UtilsKt.toNullableString(item), (Object)this.this$0.this$0.this$0.getUnwrapTryText());
                            }
                            {
                                this.this$0 = var1_1;
                                super(2);
                            }
                        }));
                        TaskContext.test$default($this$task, false, (Function1)new Function1<TaskTestContext, Unit>(it){
                            final /* synthetic */ String $it;

                            public final void invoke(@NotNull TaskTestContext $this$test) {
                                Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$receiver");
                                $this$test.actions(this.$it);
                            }
                            {
                                this.$it = string;
                                super(1);
                            }
                        }, 1, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                }));
                $receiver.task((Function1<? super TaskContext, Unit>)((Function1)new Function1<TaskContext, Unit>(this){
                    final /* synthetic */ lessonContent.1 this$0;

                    public final void invoke(@NotNull TaskContext $this$task) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$receiver");
                        LessonUtilKt.restoreAfterStateBecomeFalse$default($this$task, null, lessonContent.1.INSTANCE, 1, null);
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("surround.and.unwrap.choose.unwrap.item", $this$task.strong(LearnBundle.INSTANCE.message("surround.and.unwrap.item", this.this$0.this$0.getSurroundItems()[0]))), null, 2, null);
                        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)new Function1<TaskRuntimeContext, Boolean>(this){
                            final /* synthetic */ lessonContent.6 this$0;

                            public final boolean invoke(@NotNull TaskRuntimeContext $this$stateCheck) {
                                boolean bl;
                                block1: {
                                    CharSequence charSequence;
                                    Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$receiver");
                                    Document document = $this$stateCheck.getEditor().getDocument();
                                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                                    CharSequence sequence = charSequence = document.getCharsSequence();
                                    boolean bl2 = false;
                                    String[] $this$any$iv = this.this$0.this$0.this$0.getSurroundItems();
                                    boolean $i$f$any = false;
                                    int n = $this$any$iv.length;
                                    for (int i = 0; i < n; ++i) {
                                        String element$iv;
                                        String it = element$iv = $this$any$iv[i];
                                        boolean bl3 = false;
                                        CharSequence charSequence2 = sequence;
                                        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"sequence");
                                        if (!StringsKt.contains$default((CharSequence)charSequence2, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                                        bl = true;
                                        break block1;
                                    }
                                    bl = false;
                                }
                                return !bl;
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                        TaskContext.test$default($this$task, false, (Function1)new Function1<TaskTestContext, Unit>(this){
                            final /* synthetic */ lessonContent.6 this$0;

                            public final void invoke(@NotNull TaskTestContext $this$test) {
                                Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$receiver");
                                $this$test.type(this.this$0.this$0.this$0.getSurroundItems()[0] + "\n");
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }, 1, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = surroundAndUnwrapLesson;
                super(1);
            }
        };
    }

    private final boolean wordIsPresent(String text2, String word) {
        if (text2 == null) {
            return false;
        }
        int index = 0;
        while (index != -1 && index < text2.length()) {
            char c;
            if ((index = StringsKt.indexOf$default((CharSequence)text2, (String)word, (int)index, (boolean)false, (int)4, null)) == -1) continue;
            if (!(index != 0 && Character.isLetterOrDigit(c = text2.charAt(index - 1)) || index + word.length() != text2.length() && Character.isLetterOrDigit(c = text2.charAt(index + word.length())))) {
                return true;
            }
            index += word.length();
        }
        return false;
    }

    private final void proposeIfModified(TaskContext $this$proposeIfModified, Function1<? super TaskRuntimeContext, Boolean> checkCaret) {
        $this$proposeIfModified.proposeRestore((Function1<? super TaskRuntimeContext, TaskContext.RestoreNotification>)((Function1)new Function1<TaskRuntimeContext, TaskContext.RestoreNotification>(checkCaret){
            final /* synthetic */ Function1 $checkCaret;

            @Nullable
            public final TaskContext.RestoreNotification invoke(@NotNull TaskRuntimeContext $this$proposeRestore) {
                Intrinsics.checkNotNullParameter((Object)$this$proposeRestore, (String)"$receiver");
                TaskContext.RestoreNotification restoreNotification = LessonUtil.checkExpectedStateOfEditor$default(LessonUtil.INSTANCE, $this$proposeRestore, $this$proposeRestore.getPrevious().getSample(), false, null, 4, null);
                if (restoreNotification == null) {
                    restoreNotification = (Boolean)this.$checkCaret.invoke((Object)$this$proposeRestore) != false ? new TaskContext.RestoreNotification(TaskContext.Companion.getCaretRestoreProposal(), null, $this$proposeRestore.getRestorePreviousTaskCallback(), 2, null) : null;
                }
                return restoreNotification;
            }
            {
                this.$checkCaret = function1;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public List<String> getSuitableTips() {
        return this.suitableTips;
    }

    @Override
    @NotNull
    public Map<String, String> getHelpLinks() {
        return this.helpLinks;
    }

    public SurroundAndUnwrapLesson() {
        super("Surround and unwrap", LessonsBundle.INSTANCE.message("surround.and.unwrap.lesson.name", new Object[0]));
    }

    public static final /* synthetic */ void access$proposeIfModified(SurroundAndUnwrapLesson $this, TaskContext $this$access_u24proposeIfModified, Function1 checkCaret) {
        $this.proposeIfModified($this$access_u24proposeIfModified, (Function1<? super TaskRuntimeContext, Boolean>)checkCaret);
    }

    public static final /* synthetic */ boolean access$wordIsPresent(SurroundAndUnwrapLesson $this, String text2, String word) {
        return $this.wordIsPresent(text2, word);
    }
}

