/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.create;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBDimension;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.NotNull;

public class CreateEditorConfigForm {
    private JPanel myTopPanel;
    private JBCheckBox myStandardPropertiesCb;
    private JBCheckBox myIntelliJPropertiesCb;
    private JBCheckBox myRootCb;
    private JPanel myPropertiesPanel;
    private JPanel myLanguagesPanel;
    private JBCheckBox myCommentProperties;
    private JBLabel myAddPropertiesForLabel;
    private BrowserLink myAboutEditorConfigLink;
    private ContextHelpLabel myContextHelpLabel;
    private JBLabel myIntelliJPropertiesLabel;
    private final List<LanguageCheckBoxRec> myLanguageCheckBoxes;
    private final Project myProject;
    private static final int MAX_LANGUAGES_ROWS = 10;

    public CreateEditorConfigForm(@NotNull Project project) {
        if (project == null) {
            CreateEditorConfigForm.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myPropertiesPanel.setBorder(IdeBorderFactory.createTitledBorder((String)EditorConfigBundle.message("export.properties.title")));
        this.myLanguagesPanel.setLayout(new BoxLayout(this.myLanguagesPanel, 0));
        this.myLanguageCheckBoxes = CreateEditorConfigForm.creteLanguageCheckBoxes(this.myLanguagesPanel);
        this.setLanguagePanelEnabled(false);
        this.myCommentProperties.setEnabled(false);
        CreateEditorConfigForm.adjustVerticalSize((JComponent)this.myCommentProperties, 2.0f);
        CreateEditorConfigForm.adjustVerticalSize((JComponent)this.myAddPropertiesForLabel, 1.5f);
        this.myIntelliJPropertiesCb.addActionListener((ActionListener)new LanguagePanelEnabler());
        this.myStandardPropertiesCb.addActionListener((ActionListener)new LanguagePanelEnabler());
        this.myIntelliJPropertiesLabel.setText(EditorConfigBundle.message("export.properties.intellij", ApplicationNamesInfo.getInstance().getFullProductName()));
    }

    private static void adjustVerticalSize(JComponent component, float factor) {
        Dimension originalDim = component.getMinimumSize();
        Dimension newDim = new Dimension(originalDim.width, Math.round((float)originalDim.height * factor));
        component.setMinimumSize(newDim);
    }

    private static List<LanguageCheckBoxRec> creteLanguageCheckBoxes(JPanel languagesPanel) {
        ArrayList<LanguageCheckBoxRec> checkBoxes = new ArrayList<LanguageCheckBoxRec>();
        JPanel currPanel = null;
        int rowCount = 0;
        for (Language language : LanguageCodeStyleSettingsProvider.getLanguagesWithCodeStyleSettings()) {
            LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)language);
            if (provider == null || !provider.supportsExternalFormats()) continue;
            if (currPanel == null) {
                currPanel = CreateEditorConfigForm.createLanguageColumnPanel();
                languagesPanel.add(currPanel);
                languagesPanel.add(Box.createRigidArea((Dimension)new JBDimension(30, 1)));
                rowCount = 0;
            }
            String langName = (String)ObjectUtils.notNull((Object)provider.getLanguageName(), (Object)language.getDisplayName());
            JBCheckBox checkBox = new JBCheckBox(langName);
            checkBoxes.add(new LanguageCheckBoxRec(language, (JCheckBox)checkBox));
            currPanel.add((Component)checkBox);
            if (++rowCount < 10) continue;
            currPanel = null;
        }
        return checkBoxes;
    }

    private void setLanguagePanelEnabled(boolean enabled) {
        this.myLanguagesPanel.setEnabled(enabled);
        for (LanguageCheckBoxRec checkBoxRec : this.myLanguageCheckBoxes) {
            checkBoxRec.myCheckBox.setEnabled(enabled && this.isLanguageCheckBoxEnabled(checkBoxRec));
        }
    }

    private boolean isLanguageCheckBoxEnabled(LanguageCheckBoxRec checkBoxRec) {
        if (!this.myIntelliJPropertiesCb.isSelected()) {
            CodeStyleSettings settings = CodeStyle.getSettings((Project)this.myProject);
            CommonCodeStyleSettings.IndentOptions langOptions = settings.getLanguageIndentOptions(checkBoxRec.myLanguage);
            CommonCodeStyleSettings.IndentOptions commonIndentOptions = settings.OTHER_INDENT_OPTIONS;
            return langOptions.INDENT_SIZE != commonIndentOptions.INDENT_SIZE || langOptions.TAB_SIZE != commonIndentOptions.TAB_SIZE || langOptions.USE_TAB_CHARACTER != commonIndentOptions.USE_TAB_CHARACTER || settings.getRightMargin(checkBoxRec.myLanguage) != settings.getRightMargin(null);
        }
        return true;
    }

    private static JPanel createLanguageColumnPanel() {
        JPanel colPanel = new JPanel();
        colPanel.setLayout(new BoxLayout(colPanel, 1));
        colPanel.setAlignmentY(0.0f);
        return colPanel;
    }

    private void createUIComponents() {
        this.myAboutEditorConfigLink = new BrowserLink(EditorConfigBundle.message("export.editor.config.about"), "http://www.editorconfig.org");
        this.myAboutEditorConfigLink.setIconTextGap(0);
        this.myAboutEditorConfigLink.setHorizontalTextPosition(2);
        this.myContextHelpLabel = ContextHelpLabel.create((String)"", (String)EditorConfigBundle.message("export.editor.config.root.help"));
    }

    public JPanel getTopPanel() {
        return this.myTopPanel;
    }

    boolean isStandardProperties() {
        return this.myStandardPropertiesCb.isSelected();
    }

    boolean isIntelliJProperties() {
        return this.myIntelliJPropertiesCb.isSelected();
    }

    boolean isRoot() {
        return this.myRootCb.isSelected();
    }

    public List<Language> getSelectedLanguages() {
        return this.myLanguageCheckBoxes.stream().filter(rec -> rec.myCheckBox.isSelected()).map(rec -> rec.myLanguage).collect(Collectors.toList());
    }

    public boolean isCommentProperties() {
        return this.myCommentProperties.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBCheckBox jBCheckBox2;
        JPanel jPanel;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myTopPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPropertiesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, DynamicBundle.getBundle((String)"messages/EditorConfigBundle", CreateEditorConfigForm.class).getString("export.properties.title"), 0, 0, null, null));
        this.myStandardPropertiesCb = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("");
        jPanel2.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myIntelliJPropertiesCb = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("");
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLanguagesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/EditorConfigBundle", CreateEditorConfigForm.class).getString("export.properties.standard"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCommentProperties = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setSelected(false);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/EditorConfigBundle", CreateEditorConfigForm.class).getString("export.comment.out.properties"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(2, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myAddPropertiesForLabel = jBLabel2 = new JBLabel();
        jBLabel2.setHorizontalAlignment(2);
        jBLabel2.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/EditorConfigBundle", CreateEditorConfigForm.class).getString("export.languages.title"));
        jBLabel2.setVerticalAlignment(1);
        jBLabel2.setVerticalTextPosition(1);
        jPanel2.add((Component)jBLabel2, new GridConstraints(3, 1, 1, 2, 9, 0, 0, 0, null, null, null));
        this.myIntelliJPropertiesLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/EditorConfigBundle", CreateEditorConfigForm.class).getString("export.properties.intellij"));
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        BrowserLink browserLink = this.myAboutEditorConfigLink;
        this.$$$loadButtonText$$$((AbstractButton)browserLink, DynamicBundle.getBundle((String)"messages/EditorConfigBundle", CreateEditorConfigForm.class).getString("export.editor.config.about"));
        jPanel3.add((Component)browserLink, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRootCb = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/EditorConfigBundle", CreateEditorConfigForm.class).getString("export.topmost.file"));
        jPanel4.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ContextHelpLabel contextHelpLabel = this.myContextHelpLabel;
        jPanel4.add((Component)contextHelpLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/editorconfig/configmanagement/create/CreateEditorConfigForm", "<init>"));
    }

    private static final class LanguageCheckBoxRec {
        private final Language myLanguage;
        private final JCheckBox myCheckBox;

        private LanguageCheckBoxRec(Language language, JCheckBox checkBox) {
            this.myLanguage = language;
            this.myCheckBox = checkBox;
        }
    }

    private class LanguagePanelEnabler
    implements ActionListener {
        private LanguagePanelEnabler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean addProperties = CreateEditorConfigForm.this.myIntelliJPropertiesCb.isSelected() || CreateEditorConfigForm.this.myStandardPropertiesCb.isSelected();
            CreateEditorConfigForm.this.setLanguagePanelEnabled(addProperties);
            CreateEditorConfigForm.this.myCommentProperties.setEnabled(addProperties);
        }
    }
}

