/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.sphinx;

import com.google.common.collect.Lists;
import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.viewModel.extraction.ToolWindowContentExtractor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.ReSTService;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.rest.PythonRestBundle;
import com.jetbrains.rest.RestBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SphinxBaseCommand {
    protected boolean setWorkDir(Module module) {
        ReSTService service = ReSTService.getInstance(module);
        String workDir = service.getWorkdir();
        if (workDir.isEmpty()) {
            AskForWorkDir dialog2 = new AskForWorkDir(module.getProject());
            if (!dialog2.showAndGet()) {
                return false;
            }
            service.setWorkdir(dialog2.getInputFile());
        }
        return true;
    }

    public void execute(@NotNull Module module) {
        if (module == null) {
            SphinxBaseCommand.$$$reportNull$$$0(0);
        }
        Project project = module.getProject();
        try {
            if (!this.setWorkDir(module)) {
                return;
            }
            ProcessHandler process2 = this.createProcess(module);
            process2.putUserData(ToolWindowContentExtractor.SYNC_TAB_TO_GUEST, (Object)true);
            new RunContentExecutor(project, process2).withFilter((Filter)new PythonTracebackFilter(project)).withTitle("reStructuredText").withRerun(() -> this.execute(module)).withAfterCompletion(this.getAfterTask(module)).run();
        }
        catch (ExecutionException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)RestBundle.message((String)"sphinx.restructured.text.error", (Object[])new Object[0]));
        }
    }

    @Nullable
    protected Runnable getAfterTask(Module module) {
        return () -> {
            ReSTService service = ReSTService.getInstance(module);
            LocalFileSystem.getInstance().refreshAndFindFileByPath(service.getWorkdir());
        };
    }

    private ProcessHandler createProcess(Module module) throws ExecutionException {
        GeneralCommandLine commandLine = this.createCommandLine(module, Collections.emptyList());
        ProcessHandler handler = PythonProcessRunner.createProcess(commandLine, false);
        ProcessTerminatedListener.attach((ProcessHandler)handler);
        return handler;
    }

    protected GeneralCommandLine createCommandLine(Module module, List<String> params) throws ExecutionException {
        Sdk sdk = PythonSdkUtil.findPythonSdk(module);
        if (sdk == null) {
            throw new ExecutionException(PythonRestBundle.message("python.rest.no.sdk.specified", new Object[0]));
        }
        ReSTService service = ReSTService.getInstance(module);
        String sdkHomePath = sdk.getHomePath();
        GeneralCommandLine cmd = new GeneralCommandLine();
        if (sdkHomePath != null) {
            String runnerName = "sphinx-quickstart" + (SystemInfo.isWindows ? ".exe" : "");
            String executablePath = PythonSdkUtil.getExecutablePath(sdkHomePath, runnerName);
            if (executablePath != null) {
                cmd.setExePath(executablePath);
            } else {
                cmd = PythonHelper.LOAD_ENTRY_POINT.newCommandLine(sdkHomePath, new ArrayList<String>());
            }
        }
        cmd.setWorkDirectory(service.getWorkdir().isEmpty() ? module.getProject().getBasePath() : service.getWorkdir());
        PythonCommandLineState.createStandardGroups(cmd);
        ParamsGroup scriptParams = cmd.getParametersList().getParamsGroup("Script");
        assert (scriptParams != null);
        if (params != null) {
            for (String p : params) {
                scriptParams.addParameter(p);
            }
        }
        Map env = cmd.getEnvironment();
        PythonEnvUtil.setPythonIOEncoding(env, "utf-8");
        PythonEnvUtil.setPythonUnbuffered(env);
        if (sdkHomePath != null) {
            PythonEnvUtil.resetHomePathChanges(sdkHomePath, env);
        }
        env.put("PYCHARM_EP_DIST", "Sphinx");
        env.put("PYCHARM_EP_NAME", "sphinx-quickstart");
        ArrayList pathList = Lists.newArrayList(PythonCommandLineState.getAddedPaths(sdk));
        pathList.addAll(PythonCommandLineState.collectPythonPath(module));
        PythonCommandLineState.initPythonPath(cmd, true, pathList, sdkHomePath);
        PythonSdkType.patchCommandLineForVirtualenv(cmd, sdk);
        return cmd;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/rest/sphinx/SphinxBaseCommand", "execute"));
    }

    public static final class AskForWorkDir
    extends DialogWrapper {
        private TextFieldWithBrowseButton myInputFile;
        private JPanel myPanel;

        private AskForWorkDir(Project project) {
            super(project);
            Object[] objectArray = new Object[]{};
            this.$$$setupUI$$$();
            this.setTitle(RestBundle.message((String)"sphinx.set.working.directory.dialog.title", (Object[])objectArray));
            this.init();
            VirtualFile baseDir = project.getBaseDir();
            String path2 = baseDir != null ? baseDir.getPath() : "";
            this.myInputFile.setText(path2);
            this.myInputFile.setEditable(false);
            this.myInputFile.addBrowseFolderListener(RestBundle.message((String)"sphinx.choose.working.directory.browse.folder.title", (Object[])new Object[0]), null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
            this.myPanel.setPreferredSize(new Dimension(600, 20));
        }

        protected JComponent createCenterPanel() {
            return this.myPanel;
        }

        public String getInputFile() {
            return this.myInputFile.getText();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            TextFieldWithBrowseButton textFieldWithBrowseButton;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            ((Component)jPanel).setEnabled(false);
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PyBundle", AskForWorkDir.class).getString("sphinx.ask.for.working.directory.label.text"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myInputFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

