/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanelKt;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import com.jetbrains.python.sdk.conda.PyCondaSdkCustomizer;
import com.jetbrains.python.sdk.flavors.CondaEnvSdkFlavor;
import icons.PythonIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\n\u0010\"\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010#\u001a\u00020$H\u0014J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0007H\u0016R\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006'"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddExistingCondaEnvPanel;", "Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Ljava/lang/String;Lcom/intellij/openapi/util/UserDataHolder;)V", "condaPathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "getCondaPathField", "()Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "makeSharedField", "Lcom/intellij/ui/components/JBCheckBox;", "getNewProjectPath", "()Ljava/lang/String;", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "sdkComboBox", "Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "getSdkComboBox", "()Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "getOrCreateSdk", "layoutComponents", "", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.python.community.impl"})
public class PyAddExistingCondaEnvPanel
extends PyAddSdkPanel {
    @NotNull
    private final Icon icon;
    @NotNull
    private final PySdkPathChoosingComboBox sdkComboBox;
    @NotNull
    private final TextFieldWithBrowseButton condaPathField;
    private final JBCheckBox makeSharedField;
    private final Project project;
    private final Module module;
    private final List<Sdk> existingSdks;
    @Nullable
    private String newProjectPath;

    @Override
    @NotNull
    public String getPanelName() {
        String string = PyBundle.message("python.add.sdk.panel.name.existing.environment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyBundle.message(\"python\u2026me.existing.environment\")");
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    protected final PySdkPathChoosingComboBox getSdkComboBox() {
        return this.sdkComboBox;
    }

    @NotNull
    protected final TextFieldWithBrowseButton getCondaPathField() {
        return this.condaPathField;
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout());
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addLabeledComponent(PySdkBundle.message("python.interpreter.label", new Object[0]), (JComponent)((Object)this.sdkComboBox)).addLabeledComponent(PyBundle.message("python.sdk.conda.path", new Object[0]), (JComponent)this.condaPathField).addComponent((JComponent)this.makeSharedField);
        Intrinsics.checkNotNullExpressionValue((Object)formBuilder, (String)"FormBuilder.createFormBu\u2026omponent(makeSharedField)");
        JPanel formPanel = formBuilder.getPanel();
        this.add((Component)formPanel, "North");
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.listOfNotNull((Object[])new ValidationInfo[]{PyAddSdkPanel.Companion.validateSdkComboBox(this.sdkComboBox, this), CondaEnvSdkFlavor.validateCondaPath(this.condaPathField.getText())});
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        Sdk sdk;
        Sdk sdk2 = this.sdkComboBox.getSelectedSdk();
        PyCondaPackageService.onCondaEnvCreated(this.condaPathField.getText());
        Sdk sdk3 = sdk2;
        if (sdk3 instanceof PyDetectedSdk) {
            PyDetectedSdk pyDetectedSdk = (PyDetectedSdk)sdk2;
            String string = this.getNewProjectPath();
            if (string == null) {
                Project project = this.project;
                string = project != null ? project.getBasePath() : null;
            }
            Sdk sdk4 = PySdkExtKt.setupAssociated(pyDetectedSdk, this.existingSdks, string);
            if (sdk4 != null) {
                Sdk sdk5;
                Sdk $this$apply = sdk5 = sdk4;
                boolean bl = false;
                if (!this.makeSharedField.isSelected()) {
                    PySdkExtKt.associateWithModule($this$apply, this.module, this.getNewProjectPath());
                }
                sdk = sdk5;
            } else {
                sdk = null;
            }
        } else {
            sdk = sdk2;
        }
        return sdk;
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String string) {
        this.newProjectPath = string;
    }

    /*
     * WARNING - void declaration
     */
    public PyAddExistingCondaEnvPanel(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks2, @Nullable String newProjectPath, final @NotNull UserDataHolder context2) {
        void $this$apply;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        Intrinsics.checkNotNullParameter(existingSdks2, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.project = project;
        this.module = module;
        this.existingSdks = existingSdks2;
        this.newProjectPath = newProjectPath;
        Icon icon = PythonIcons.Python.Anaconda;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PythonIcons.Python.Anaconda");
        this.icon = icon;
        this.sdkComboBox = new PySdkPathChoosingComboBox(null, null, null, null, 15, null);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        PyAddExistingCondaEnvPanel pyAddExistingCondaEnvPanel = this;
        boolean bl = false;
        String path2 = PyCondaPackageService.getCondaExecutable(null);
        if (path2 != null) {
            $this$apply.setText(path2);
        }
        $this$apply.addBrowseFolderListener(PyBundle.message("python.sdk.select.conda.path.title", new Object[0]), null, this.project, FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor());
        Unit unit = Unit.INSTANCE;
        pyAddExistingCondaEnvPanel.condaPathField = textFieldWithBrowseButton;
        this.makeSharedField = new JBCheckBox(PyBundle.message("available.to.all.projects", new Object[0]));
        ((ComboBoxWithWidePopup)this.sdkComboBox.getChildComponent()).addItemListener(new ItemListener(){

            @Override
            public final void itemStateChanged(ItemEvent it) {
                ItemEvent itemEvent = it;
                Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"it");
                if (itemEvent.getStateChange() == 1) {
                    Sdk sdk = this.getSdkComboBox().getSelectedSdk();
                    String respectiveCondaExecutable = PyCondaPackageService.getCondaExecutable(sdk != null ? sdk.getHomePath() : null);
                    TextFieldWithBrowseButton textFieldWithBrowseButton = this.getCondaPathField();
                    String string = respectiveCondaExecutable;
                    String string2 = string;
                    if (string2 == null) {
                        string2 = "";
                    }
                    textFieldWithBrowseButton.setText(string2);
                }
            }
        });
        if (PyCondaSdkCustomizer.Companion.getInstance().getSharedEnvironmentsByDefault()) {
            this.makeSharedField.setSelected(true);
        }
        this.layoutComponents();
        PyAddSdkPanelKt.addInterpretersAsync(this.sdkComboBox, (Function0<? extends List<? extends Sdk>>)((Function0)new Function0<List<? extends Sdk>>(){

            @NotNull
            public final List<Sdk> invoke() {
                return PySdkExtKt.detectCondaEnvs(module, existingSdks, context2);
            }
        }));
    }
}

