/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.convertModulePackage;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.convertModulePackage.PyBaseConvertModulePackageAction;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyConvertPackageToModuleAction
extends PyBaseConvertModulePackageAction {
    private static final Logger LOG = Logger.getInstance(PyConvertPackageToModuleAction.class);
    private static final String ID = "py.refactoring.convert.package.to.module";

    @Override
    protected boolean isEnabledOnElementsOutsideEditor(PsiElement @NotNull [] elements) {
        if (elements == null) {
            PyConvertPackageToModuleAction.$$$reportNull$$$0(0);
        }
        if (elements.length == 1) {
            PsiDirectory pyPackage = PyConvertPackageToModuleAction.getPackageDir(elements[0]);
            return pyPackage != null && !PyConvertPackageToModuleAction.isSpecialDirectory(pyPackage);
        }
        return false;
    }

    @Nullable
    private static PsiDirectory getPackageDir(@NotNull PsiElement elem) {
        if (elem == null) {
            PyConvertPackageToModuleAction.$$$reportNull$$$0(1);
        }
        if (elem instanceof PsiDirectory && PyUtil.isPackage((PsiDirectory)elem, null)) {
            return (PsiDirectory)elem;
        }
        if (elem instanceof PsiFile && PyUtil.isPackage((PsiFile)elem)) {
            return ((PsiFile)elem).getParent();
        }
        return null;
    }

    private static boolean isSpecialDirectory(@NotNull PsiDirectory element) {
        Module module;
        if (element == null) {
            PyConvertPackageToModuleAction.$$$reportNull$$$0(2);
        }
        return (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null || PyUtil.getSourceRoots(module).contains(element.getVirtualFile());
    }

    @Nullable
    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PyConvertPackageToModuleAction.$$$reportNull$$$0(3);
        }
        return new RefactoringActionHandler(){

            public void invoke(@NotNull Project project, Editor editor2, PsiFile file, DataContext dataContext) {
                PsiDirectory pyPackage;
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((pyPackage = PyConvertPackageToModuleAction.getPackageDir((PsiElement)file)) != null) {
                    PyConvertPackageToModuleAction.this.createModuleFromPackage(pyPackage);
                }
            }

            public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
                PsiDirectory pyPackage;
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (elements == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (elements.length == 1 && (pyPackage = PyConvertPackageToModuleAction.getPackageDir(elements[0])) != null) {
                    PyConvertPackageToModuleAction.this.createModuleFromPackage(pyPackage);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "elements";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/refactoring/convertModulePackage/PyConvertPackageToModuleAction$1";
                objectArray[2] = "invoke";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @VisibleForTesting
    public void createModuleFromPackage(@NotNull PsiDirectory pyPackage) {
        String moduleName;
        if (pyPackage == null) {
            PyConvertPackageToModuleAction.$$$reportNull$$$0(4);
        }
        if (pyPackage.getParent() == null) {
            return;
        }
        String packageName = pyPackage.getName();
        if (!PyConvertPackageToModuleAction.isEmptyPackage(pyPackage)) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)PyBundle.message("refactoring.convert.package.to.module.error.not.empty.package", packageName), (String)ID, (Project)pyPackage.getProject());
            return;
        }
        VirtualFile parentDirVFile = pyPackage.getParent().getVirtualFile();
        VirtualFile existing = parentDirVFile.findChild(moduleName = packageName + ".py");
        if (existing != null) {
            this.showFileExistsErrorMessage(existing, ID, pyPackage.getProject());
            return;
        }
        PsiFile initPy = pyPackage.findFile("__init__.py");
        WriteCommandAction.runWriteCommandAction((Project)pyPackage.getProject(), () -> {
            try {
                if (initPy != null) {
                    VirtualFile initPyVFile = initPy.getVirtualFile();
                    initPyVFile.rename((Object)this, moduleName);
                    initPyVFile.move((Object)this, parentDirVFile);
                } else {
                    PyClassRefactoringUtil.getOrCreateFile(parentDirVFile.getPath() + "/" + moduleName, pyPackage.getProject());
                }
                pyPackage.getVirtualFile().delete((Object)this);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    private static boolean isEmptyPackage(@NotNull PsiDirectory pyPackage) {
        PsiElement[] children2;
        if (pyPackage == null) {
            PyConvertPackageToModuleAction.$$$reportNull$$$0(5);
        }
        if ((children2 = pyPackage.getChildren()).length == 1) {
            PyFile onlyFile = PyUtil.as(children2[0], PyFile.class);
            return onlyFile != null && onlyFile.getName().equals("__init__.py");
        }
        return children2.length == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyPackage";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/convertModulePackage/PyConvertPackageToModuleAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledOnElementsOutsideEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageDir";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpecialDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createModuleFromPackage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isEmptyPackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

