/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SingleTargetRequestResultProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyCallExpressionNavigator;
import org.jetbrains.annotations.NotNull;

public class PyInitReferenceSearchExecutor
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement element;
        if (queryParameters == null) {
            PyInitReferenceSearchExecutor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PyInitReferenceSearchExecutor.$$$reportNull$$$0(1);
        }
        if (!((element = queryParameters.getElementToSearch()) instanceof PyFunction)) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            PyFunction function = (PyFunction)element;
            PyClass pyClass = PyUtil.turnConstructorIntoClass(function);
            if (pyClass == null) {
                return;
            }
            String className = pyClass.getName();
            if (className == null) {
                return;
            }
            SearchScope searchScope = queryParameters.getEffectiveSearchScope();
            if (searchScope instanceof GlobalSearchScope) {
                searchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)searchScope), (FileType[])new FileType[]{PythonFileType.INSTANCE});
            }
            ClassInitializationProcessor processor2 = new ClassInitializationProcessor(pyClass);
            queryParameters.getOptimizer().searchWord(className, searchScope, (short)1, true, (PsiElement)pyClass, (RequestResultProcessor)processor2);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/psi/search/PyInitReferenceSearchExecutor";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ClassInitializationProcessor
    extends RequestResultProcessor {
        @NotNull
        private final SingleTargetRequestResultProcessor myProcessor;

        private ClassInitializationProcessor(@NotNull PyClass cls) {
            if (cls == null) {
                ClassInitializationProcessor.$$$reportNull$$$0(0);
            }
            super(new Object[]{cls});
            this.myProcessor = new SingleTargetRequestResultProcessor((PsiElement)cls);
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
            if (element == null) {
                ClassInitializationProcessor.$$$reportNull$$$0(1);
            }
            if (consumer == null) {
                ClassInitializationProcessor.$$$reportNull$$$0(2);
            }
            if (PyCallExpressionNavigator.getPyCallExpressionByCallee(element) != null) {
                return this.myProcessor.processTextOccurrence(element, offsetInElement, consumer);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cls";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/search/PyInitReferenceSearchExecutor$ClassInitializationProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTextOccurrence";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

