/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

@State(name="PyPackageService", storages={@Storage(value="packages.xml", roamingType=RoamingType.DISABLED)}, reportStatistic=false)
public class PyPackageService
implements PersistentStateComponent<PyPackageService> {
    public volatile Map<String, Boolean> sdkToUsersite = new ConcurrentHashMap<String, Boolean>();
    public volatile List<String> additionalRepositories = ContainerUtil.createConcurrentList();
    public volatile @SystemIndependent String virtualEnvBasePath;
    public volatile Boolean PYPI_REMOVED = false;

    public PyPackageService getState() {
        return this;
    }

    public void loadState(@NotNull PyPackageService state2) {
        if (state2 == null) {
            PyPackageService.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    public void addSdkToUserSite(String sdk, boolean useUsersite) {
        this.sdkToUsersite.put(sdk, useUsersite);
    }

    public void addRepository(String repository) {
        if (repository == null) {
            return;
        }
        if (PyPIPackageUtil.isPyPIRepository((String)repository)) {
            this.PYPI_REMOVED = false;
        } else {
            if (!((String)repository).endsWith("/")) {
                repository = (String)repository + "/";
            }
            this.additionalRepositories.add((String)repository);
        }
    }

    public void removeRepository(String repository) {
        if (this.additionalRepositories.contains(repository)) {
            this.additionalRepositories.remove(repository);
        } else if (PyPIPackageUtil.isPyPIRepository(repository)) {
            this.PYPI_REMOVED = true;
        }
    }

    public boolean useUserSite(String sdk) {
        if (this.sdkToUsersite.containsKey(sdk)) {
            return this.sdkToUsersite.get(sdk);
        }
        return false;
    }

    public static PyPackageService getInstance() {
        return (PyPackageService)ApplicationManager.getApplication().getService(PyPackageService.class);
    }

    @Nullable
    public @SystemIndependent String getVirtualEnvBasePath() {
        return this.virtualEnvBasePath;
    }

    public void setVirtualEnvBasePath(@NotNull @SystemIndependent String virtualEnvBasePath) {
        if (virtualEnvBasePath == null) {
            PyPackageService.$$$reportNull$$$0(1);
        }
        this.virtualEnvBasePath = virtualEnvBasePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualEnvBasePath";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/packaging/PyPackageService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setVirtualEnvBasePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

