/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject.steps;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkChooserCombo
extends ComboboxWithBrowseButton {
    private final List<ActionListener> myChangedListeners;
    private static final Logger LOG = Logger.getInstance(PythonSdkChooserCombo.class);
    @Deprecated
    @Nullable
    private String myNewProjectPath;

    public PythonSdkChooserCombo(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> sdks, @NotNull Condition<? super Sdk> acceptableSdkCondition) {
        if (sdks == null) {
            PythonSdkChooserCombo.$$$reportNull$$$0(0);
        }
        if (acceptableSdkCondition == null) {
            PythonSdkChooserCombo.$$$reportNull$$$0(1);
        }
        this(project, module, sdks, null, acceptableSdkCondition);
    }

    @Deprecated
    public PythonSdkChooserCombo(final @Nullable Project project, final @Nullable Module module, @NotNull List<? extends Sdk> sdks, @Nullable String newProjectPath, @NotNull Condition<? super Sdk> acceptableSdkCondition) {
        if (sdks == null) {
            PythonSdkChooserCombo.$$$reportNull$$$0(2);
        }
        if (acceptableSdkCondition == null) {
            PythonSdkChooserCombo.$$$reportNull$$$0(3);
        }
        super((JComboBox)new ComboBox());
        this.myChangedListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myNewProjectPath = newProjectPath;
        Sdk initialSelection = (Sdk)ContainerUtil.find(sdks, acceptableSdkCondition);
        JComboBox comboBox = this.getComboBox();
        comboBox.setModel(new CollectionComboBoxModel(sdks, (Object)initialSelection));
        comboBox.setRenderer(new PySdkListCellRenderer());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PythonSdkChooserCombo.this.showOptions(project, module);
                PythonSdkChooserCombo.this.notifyChanged(e);
            }
        });
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PythonSdkChooserCombo.this.notifyChanged(e);
                PythonSdkChooserCombo.this.updateTooltip();
            }
        });
        new ComboboxSpeedSearch(comboBox);
        this.updateTooltip();
    }

    private void updateTooltip() {
        Object item = this.getComboBox().getSelectedItem();
        String sdkHomePath = item instanceof Sdk ? ((Sdk)item).getHomePath() : null;
        this.getComboBox().setToolTipText(sdkHomePath != null ? FileUtil.toSystemDependentName((String)sdkHomePath) : null);
    }

    private void showOptions(@Nullable Project project, @Nullable Module module) {
        PyConfigurableInterpreterList interpreterList = PyConfigurableInterpreterList.getInstance(project);
        Sdk[] sdks = interpreterList.getModel().getSdks();
        JComboBox comboBox = this.getComboBox();
        Sdk oldSelectedSdk = (Sdk)comboBox.getSelectedItem();
        PyAddSdkDialog.show(project, module, Arrays.asList(sdks), sdk -> {
            if (sdk == null) {
                return;
            }
            ProjectSdksModel projectSdksModel = interpreterList.getModel();
            if (projectSdksModel.findSdk(sdk) == null) {
                projectSdksModel.addSdk(sdk);
                try {
                    projectSdksModel.apply();
                }
                catch (ConfigurationException e) {
                    LOG.error("Error adding new python interpreter " + e.getMessage());
                }
            }
            List<Sdk> committedSdks = interpreterList.getAllPythonSdks();
            Sdk copiedSdk = interpreterList.getModel().findSdk(sdk.getName());
            comboBox.setModel(new CollectionComboBoxModel(committedSdks, (Object)oldSelectedSdk));
            comboBox.setSelectedItem(copiedSdk);
            this.notifyChanged(null);
        });
    }

    private void notifyChanged(ActionEvent e) {
        for (ActionListener changedListener : this.myChangedListeners) {
            changedListener.actionPerformed(e);
        }
    }

    public void addChangedListener(ActionListener listener2) {
        this.myChangedListeners.add(listener2);
    }

    @Deprecated
    public void setNewProjectPath(@Nullable String newProjectPath) {
        this.myNewProjectPath = newProjectPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sdks";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "acceptableSdkCondition";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/newProject/steps/PythonSdkChooserCombo";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

