/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.intentions.PyTypeHintGenerationUtil;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyTypeCheckerInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMakeFunctionReturnTypeQuickFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PyFunction> myFunction;
    private final SmartPsiElementPointer<PyExpression> myReturnExpr;
    private final SmartPsiElementPointer<PyAnnotation> myAnnotation;
    private final SmartPsiElementPointer<PsiComment> myTypeCommentAnnotation;
    private final String myReturnTypeName;
    private final boolean myHaveSuggestedType;

    public PyMakeFunctionReturnTypeQuickFix(@NotNull PyFunction function, @Nullable PyExpression returnExpr, @Nullable PyType returnTypeSuggested, @NotNull TypeEvalContext context2) {
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(1);
        }
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)function.getProject());
        this.myFunction = manager.createSmartPsiElementPointer((PsiElement)function);
        this.myReturnExpr = returnExpr != null ? manager.createSmartPsiElementPointer((PsiElement)returnExpr) : null;
        PyAnnotation annotation = function.getAnnotation();
        this.myAnnotation = annotation != null ? manager.createSmartPsiElementPointer((PsiElement)annotation) : null;
        PsiComment typeCommentAnnotation = function.getTypeComment();
        this.myTypeCommentAnnotation = typeCommentAnnotation != null ? manager.createSmartPsiElementPointer((PsiElement)typeCommentAnnotation) : null;
        this.myHaveSuggestedType = returnTypeSuggested != null;
        PyType returnType = this.myHaveSuggestedType ? returnTypeSuggested : function.getReturnStatementType(context2);
        this.myReturnTypeName = PythonDocumentationProvider.getTypeHint(returnType, context2);
    }

    @NotNull
    public String getName() {
        PyFunction function = (PyFunction)this.myFunction.getElement();
        String functionName = function != null ? function.getName() : "function";
        String string = PyPsiBundle.message("QFIX.make.function.return.type", functionName, this.myReturnTypeName);
        if (string == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.make.function.return.type", new Object[0]);
        if (string == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiComment typeComment;
        if (project == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(5);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        if (this.myAnnotation != null) {
            PyAnnotation annotation = (PyAnnotation)this.myAnnotation.getElement();
            if (annotation != null) {
                PyExpression annotationExpr = annotation.getValue();
                if (annotationExpr == null) {
                    return;
                }
                PsiElement newElement = annotationExpr.replace((PsiElement)elementGenerator.createExpressionFromText(LanguageLevel.PYTHON34, this.myReturnTypeName));
                this.addImportsForTypeAnnotations(newElement);
            }
        } else if (this.myTypeCommentAnnotation != null && (typeComment = (PsiComment)this.myTypeCommentAnnotation.getElement()) != null) {
            StringBuilder typeCommentAnnotation = new StringBuilder(typeComment.getText());
            typeCommentAnnotation.delete(typeCommentAnnotation.indexOf("->"), typeCommentAnnotation.length());
            typeCommentAnnotation.append("-> ").append(this.myReturnTypeName);
            PsiComment newTypeComment = elementGenerator.createFromText(LanguageLevel.PYTHON27, PsiComment.class, typeCommentAnnotation.toString());
            PsiElement newElement = typeComment.replace((PsiElement)newTypeComment);
            this.addImportsForTypeAnnotations(newElement);
        }
    }

    private void addImportsForTypeAnnotations(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(6);
        }
        if ((file = element.getContainingFile()) == null) {
            return;
        }
        PyFunction function = (PyFunction)this.myFunction.getElement();
        if (function == null) {
            return;
        }
        Project project = element.getProject();
        TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(project, file);
        PyType typeForImports = this.getTypeForImports(function, typeEvalContext);
        if (typeForImports != null) {
            PyTypeHintGenerationUtil.addImportsForTypeAnnotations(List.of(typeForImports), typeEvalContext, file);
        }
    }

    @Nullable
    private PyType getTypeForImports(@NotNull PyFunction function, @NotNull TypeEvalContext context2) {
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(8);
        }
        PyType returnTypeActual = PyTypeCheckerInspection.Visitor.getActualReturnType(function, this.myReturnExpr != null ? (PyExpression)this.myReturnExpr.getElement() : null, context2);
        if (this.myHaveSuggestedType && returnTypeActual != null) {
            return returnTypeActual;
        }
        return function.getReturnStatementType(context2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionReturnTypeQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionReturnTypeQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addImportsForTypeAnnotations";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForImports";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

