/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.StaticSymbolWhiteSpaceDefinitionStrategy;
import com.jetbrains.python.editor.PythonEnterHandler;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import org.jetbrains.annotations.NotNull;

public class PyWhiteSpaceFormattingStrategy
extends StaticSymbolWhiteSpaceDefinitionStrategy {
    public PyWhiteSpaceFormattingStrategy() {
        super(new char[]{'\\'});
    }

    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull PsiElement startElement, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings) {
        CharSequence whiteSpace;
        if (whiteSpaceText == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(0);
        }
        if (startElement == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(1);
        }
        if ((whiteSpace = super.adjustWhiteSpaceIfNecessary(whiteSpaceText, startElement, startOffset, endOffset, codeStyleSettings)).length() > 0 && whiteSpace.charAt(0) == '\n' && !Strings.contains((CharSequence)whiteSpace, (int)0, (int)whiteSpace.length(), (char)'\\') && PythonEnterHandler.needInsertBackslash(startElement.getContainingFile(), startOffset, false)) {
            return PyWhiteSpaceFormattingStrategy.addBackslashPrefix(whiteSpace, codeStyleSettings);
        }
        return whiteSpace;
    }

    private static String addBackslashPrefix(CharSequence whiteSpace, CodeStyleSettings settings) {
        PyCodeStyleSettings pySettings = (PyCodeStyleSettings)settings.getCustomSettings(PyCodeStyleSettings.class);
        return (pySettings.SPACE_BEFORE_BACKSLASH ? " \\" : "\\") + whiteSpace.toString();
    }

    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull CharSequence text2, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings, ASTNode nodeAfter) {
        Int2IntMap initialBackSlashes;
        if (whiteSpaceText == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(3);
        }
        if ((initialBackSlashes = PyWhiteSpaceFormattingStrategy.countBackSlashes(text2, startOffset, endOffset)).isEmpty()) {
            if (nodeAfter != null && whiteSpaceText.length() > 0 && whiteSpaceText.charAt(0) == '\n' && PythonEnterHandler.needInsertBackslash(nodeAfter, false)) {
                String string = PyWhiteSpaceFormattingStrategy.addBackslashPrefix(whiteSpaceText, codeStyleSettings);
                if (string == null) {
                    PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(4);
                }
                return string;
            }
            CharSequence charSequence = whiteSpaceText;
            if (charSequence == null) {
                PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(5);
            }
            return charSequence;
        }
        Int2IntMap newBackSlashes = PyWhiteSpaceFormattingStrategy.countBackSlashes(whiteSpaceText, 0, whiteSpaceText.length());
        boolean continueProcessing = false;
        IntIterator iterator = initialBackSlashes.keySet().iterator();
        while (iterator.hasNext()) {
            if (newBackSlashes.containsKey(iterator.nextInt())) continue;
            continueProcessing = true;
            break;
        }
        if (!continueProcessing) {
            CharSequence charSequence = whiteSpaceText;
            if (charSequence == null) {
                PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(6);
            }
            return charSequence;
        }
        PyCodeStyleSettings settings = (PyCodeStyleSettings)codeStyleSettings.getCustomSettings(PyCodeStyleSettings.class);
        StringBuilder result = new StringBuilder();
        int line2 = 0;
        for (int i = 0; i < whiteSpaceText.length(); ++i) {
            char c = whiteSpaceText.charAt(i);
            if (c != '\n') {
                result.append(c);
                continue;
            }
            if (!newBackSlashes.containsKey(line2++)) {
                if ((i == 0 || whiteSpaceText.charAt(i - 1) != ' ') && settings.SPACE_BEFORE_BACKSLASH) {
                    result.append(' ');
                }
                result.append('\\');
            }
            result.append(c);
        }
        StringBuilder stringBuilder = result;
        if (stringBuilder == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(7);
        }
        return stringBuilder;
    }

    @NotNull
    static Int2IntMap countBackSlashes(CharSequence text2, int start, int end) {
        Int2IntOpenHashMap result = new Int2IntOpenHashMap();
        int line2 = 0;
        if (end > text2.length()) {
            end = text2.length();
        }
        block4: for (int i = start; i < end; ++i) {
            char c = text2.charAt(i);
            switch (c) {
                case '\n': {
                    ++line2;
                    continue block4;
                }
                case '\\': {
                    result.put(line2, 1);
                }
            }
        }
        Int2IntOpenHashMap int2IntOpenHashMap = result;
        if (int2IntOpenHashMap == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(8);
        }
        return int2IntOpenHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaceText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/formatter/PyWhiteSpaceFormattingStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/formatter/PyWhiteSpaceFormattingStrategy";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustWhiteSpaceIfNecessary";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "countBackSlashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustWhiteSpaceIfNecessary";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

