/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.containerview.PyDataView;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyViewNumericContainerAction
extends XDebuggerTreeActionBase {
    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        Project p;
        if (nodeName == null) {
            PyViewNumericContainerAction.$$$reportNull$$$0(0);
        }
        if ((p = e.getProject()) != null && node != null && node.getValueContainer() instanceof PyDebugValue && node.isComputed()) {
            PyDebugValue debugValue = (PyDebugValue)node.getValueContainer();
            PyViewNumericContainerAction.showNumericViewer(p, debugValue);
        }
    }

    public static void showNumericViewer(Project project, PyDebugValue debugValue) {
        PyDataView.getInstance(project).show(debugValue);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PyViewNumericContainerAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        List selectedNodes;
        if (e == null) {
            PyViewNumericContainerAction.$$$reportNull$$$0(2);
        }
        if ((selectedNodes = PyViewNumericContainerAction.getSelectedNodes((DataContext)e.getDataContext())).size() != 1) {
            e.getPresentation().setVisible(false);
            return;
        }
        XValueNodeImpl node = (XValueNodeImpl)selectedNodes.get(0);
        if (!(node.getValueContainer() instanceof PyDebugValue) || !node.isComputed()) {
            e.getPresentation().setVisible(false);
            return;
        }
        PyDebugValue debugValue = (PyDebugValue)node.getValueContainer();
        String nodeType = debugValue.getType();
        if ("ndarray".equals(nodeType)) {
            e.getPresentation().setText(PyBundle.message("debugger.numeric.view.as.array", new Object[0]));
            e.getPresentation().setVisible(true);
        } else if ("DataFrame".equals(nodeType) || "GeoDataFrame".equals(nodeType)) {
            e.getPresentation().setText(PyBundle.message("debugger.numeric.view.as.dataframe", new Object[0]));
            e.getPresentation().setVisible(true);
        } else if ("Series".equals(nodeType) || "GeoSeries".equals(nodeType)) {
            e.getPresentation().setText(PyBundle.message("debugger.numeric.view.as.series", new Object[0]));
            e.getPresentation().setVisible(true);
        } else {
            e.getPresentation().setVisible(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/containerview/PyViewNumericContainerAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/containerview/PyViewNumericContainerAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

