/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PydevConsoleRunnerUtil;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.ReplaceSubstringFunction;
import com.jetbrains.python.console.completion.PydevConsoleElement;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.parsing.console.PythonConsoleData;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.target.PySdkTargetPaths;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a`\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00020\tj\b\u0012\u0004\u0012\u00020\u0002`\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00020\t0\r2 \u0010\u000e\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\tj\n\u0012\u0004\u0012\u00020\u0002\u0018\u0001`\u000b2\u0006\u0010\u000f\u001a\u00020\u0002\u001a&\u0010\b\u001a\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0002\u001a(\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0018\u001a\"\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0012\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\u0017\u001a\u0004\u0018\u00010\"\u001a\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u000e\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'\u001a\u000e\u0010(\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0006\u001a\u00020\u0007\u001a$\u0010)\u001a\u00020*2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006-"}, d2={"addDefaultEnvironments", "", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "envs", "project", "Lcom/intellij/openapi/project/Project;", "constructPyPathAndWorkingDirCommand", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "pythonPath", "", "workingDirFunction", "command", "workingDir", "findPythonSdkAndModule", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/module/Module;", "contextModule", "getConsoleCommunication", "Lcom/jetbrains/python/console/pydev/ConsoleCommunication;", "element", "Lcom/intellij/psi/PsiElement;", "getConsoleSdk", "getPathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "consoleSettings", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "remoteSdkAdditionalData", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "getPythonConsoleData", "Lcom/jetbrains/python/parsing/console/PythonConsoleData;", "Lcom/intellij/lang/ASTNode;", "hasConsoleKey", "", "isConsoleView", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isInPydevConsole", "setCorrectStdOutEncoding", "", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.python.community.impl"})
@JvmName(name="PydevConsoleRunnerUtil")
public final class PydevConsoleRunnerUtil {
    @Nullable
    public static final PyRemotePathMapper getPathMapper(@NotNull Project project, @Nullable Sdk sdk, @NotNull PyConsoleOptions.PyConsoleSettings consoleSettings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)consoleSettings, (String)"consoleSettings");
        if (sdk == null) {
            return null;
        }
        SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
        return sdkAdditionalData instanceof PyTargetAwareAdditionalData ? PySdkTargetPaths.getPathMapper(project, consoleSettings, (PyTargetAwareAdditionalData)sdkAdditionalData) : (sdkAdditionalData instanceof PyRemoteSdkAdditionalDataBase ? PydevConsoleRunnerUtil.getPathMapper(project, consoleSettings, (PyRemoteSdkAdditionalDataBase)sdkAdditionalData) : null);
    }

    @NotNull
    public static final PyRemotePathMapper getPathMapper(@NotNull Project project, @NotNull PyConsoleOptions.PyConsoleSettings consoleSettings, @NotNull PyRemoteSdkAdditionalDataBase remoteSdkAdditionalData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)consoleSettings, (String)"consoleSettings");
        Intrinsics.checkNotNullParameter((Object)remoteSdkAdditionalData, (String)"remoteSdkAdditionalData");
        PyRemotePathMapper pyRemotePathMapper = PythonRemoteInterpreterManager.appendBasicMappings(project, null, remoteSdkAdditionalData);
        Intrinsics.checkNotNullExpressionValue((Object)pyRemotePathMapper, (String)"PythonRemoteInterpreterM\u2026 remoteSdkAdditionalData)");
        PyRemotePathMapper remotePathMapper = pyRemotePathMapper;
        PathMappingSettings mappingSettings = consoleSettings.getMappingSettings();
        if (mappingSettings != null) {
            remotePathMapper.addAll(mappingSettings.getPathMappings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
        }
        return remotePathMapper;
    }

    @NotNull
    public static final Pair<Sdk, Module> findPythonSdkAndModule(@NotNull Project project, @Nullable Module contextModule) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Sdk sdk = null;
        Module module = null;
        PyConsoleOptions pyConsoleOptions = PyConsoleOptions.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)pyConsoleOptions, (String)"PyConsoleOptions.getInstance(project)");
        PyConsoleOptions.PyConsoleSettings pyConsoleSettings = pyConsoleOptions.getPythonConsoleSettings();
        Intrinsics.checkNotNullExpressionValue((Object)pyConsoleSettings, (String)"PyConsoleOptions.getInst\u2026ct).pythonConsoleSettings");
        PyConsoleOptions.PyConsoleSettings settings = pyConsoleSettings;
        String sdkHome = settings.getSdkHome();
        if (sdkHome != null) {
            sdk = PythonSdkUtil.findSdkByPath(sdkHome);
            if (settings.getModuleName() != null) {
                module = ModuleManager.getInstance((Project)project).findModuleByName(settings.getModuleName());
            } else {
                module = contextModule;
                if (module == null) {
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                    Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                    Module[] moduleArray = moduleManager.getModules();
                    Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
                    Module[] moduleArray2 = moduleArray;
                    if (!(moduleArray2.length == 0)) {
                        ModuleManager moduleManager2 = ModuleManager.getInstance((Project)project);
                        Intrinsics.checkNotNullExpressionValue((Object)moduleManager2, (String)"ModuleManager.getInstance(project)");
                        module = moduleManager2.getModules()[0];
                    }
                }
            }
        }
        if (sdk == null && settings.isUseModuleSdk()) {
            if (contextModule != null) {
                module = contextModule;
            } else if (settings.getModuleName() != null) {
                module = ModuleManager.getInstance((Project)project).findModuleByName(settings.getModuleName());
            }
            if (module != null && PythonSdkUtil.findPythonSdk(module) != null) {
                sdk = PythonSdkUtil.findPythonSdk(module);
            }
        } else if (contextModule != null) {
            if (module == null) {
                module = contextModule;
            }
            if (sdk == null) {
                sdk = PythonSdkUtil.findPythonSdk(module);
            }
        }
        if (sdk == null) {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
            for (Module m : moduleManager.getModules()) {
                if (PythonSdkUtil.findPythonSdk(m) == null) continue;
                sdk = PythonSdkUtil.findPythonSdk(m);
                module = m;
                break;
            }
        }
        if (sdk == null && PythonSdkUtil.getAllSdks().size() > 0) {
            sdk = PythonSdkUtil.getAllSdks().get(0);
        }
        Pair pair = Pair.create((Object)sdk, (Object)module);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"Pair.create(sdk, module)");
        return pair;
    }

    @NotNull
    public static final String constructPyPathAndWorkingDirCommand(@NotNull Collection<String> pythonPath, @Nullable String workingDir, @NotNull String command) {
        Intrinsics.checkNotNullParameter(pythonPath, (String)"pythonPath");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (workingDir != null) {
            pythonPath.add(workingDir);
        }
        String path2 = CollectionsKt.joinToString$default((Iterable)pythonPath, (CharSequence)", ", null, null, (int)0, null, (Function1)constructPyPathAndWorkingDirCommand.path.1.INSTANCE, (int)30, null);
        return StringsKt.replace$default((String)command, (String)"WORKING_DIR_AND_PYTHON_PATHS", (String)path2, (boolean)false, (int)4, null);
    }

    @NotNull
    public static final Function<TargetEnvironment, String> constructPyPathAndWorkingDirCommand(@NotNull Collection<Function<TargetEnvironment, String>> pythonPath, @Nullable Function<TargetEnvironment, String> workingDirFunction, @NotNull String command) {
        Intrinsics.checkNotNullParameter(pythonPath, (String)"pythonPath");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (workingDirFunction != null) {
            pythonPath.add(workingDirFunction);
        }
        Function path2 = TargetEnvironmentFunctions.andThenJoinToString((Function)TargetEnvironmentFunctions.toLinkedSetFunction((Iterable)pythonPath), (CharSequence)", ", (Function1)constructPyPathAndWorkingDirCommand.path.2.INSTANCE);
        return (Function)((Object)new ReplaceSubstringFunction(command, "WORKING_DIR_AND_PYTHON_PATHS", path2));
    }

    @NotNull
    public static final Map<String, String> addDefaultEnvironments(@NotNull Sdk sdk, @NotNull Map<String, String> envs, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PydevConsoleRunnerUtil.setCorrectStdOutEncoding(envs, project);
        PythonEnvUtil.initPythonPath(envs, true, (Collection<String>)PythonCommandLineState.getAddedPaths(sdk));
        return envs;
    }

    private static final void setCorrectStdOutEncoding(Map<String, String> envs, Project project) {
        EncodingProjectManager encodingProjectManager = EncodingProjectManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)encodingProjectManager, (String)"EncodingProjectManager.getInstance(project)");
        Charset charset = encodingProjectManager.getDefaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"EncodingProjectManager.g\u2026e(project).defaultCharset");
        Charset defaultCharset = charset;
        String encoding = defaultCharset.name();
        PythonEnvUtil.setPythonIOEncoding(PythonEnvUtil.setPythonUnbuffered(envs), encoding);
    }

    public static final void setCorrectStdOutEncoding(@NotNull GeneralCommandLine commandLine, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EncodingProjectManager encodingProjectManager = EncodingProjectManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)encodingProjectManager, (String)"EncodingProjectManager.getInstance(project)");
        Charset charset = encodingProjectManager.getDefaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"EncodingProjectManager.g\u2026e(project).defaultCharset");
        Charset defaultCharset = charset;
        commandLine.setCharset(defaultCharset);
        PythonEnvUtil.setPythonIOEncoding(commandLine.getEnvironment(), defaultCharset.name());
    }

    public static final boolean isInPydevConsole(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PydevConsoleElement || PydevConsoleRunnerUtil.getConsoleCommunication(element) != null || PydevConsoleRunnerUtil.hasConsoleKey(element);
    }

    private static final boolean hasConsoleKey(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2.getVirtualFile() == null) {
            return false;
        }
        PsiFile psiFile3 = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"element.containingFile");
        Boolean inConsole = (Boolean)psiFile3.getVirtualFile().getUserData(PythonConsoleView.CONSOLE_KEY);
        return inConsole != null && inConsole != false;
    }

    public static final boolean isConsoleView(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)((Boolean)file.getUserData(PythonConsoleView.CONSOLE_KEY)), (Object)true);
    }

    @Nullable
    public static final PythonConsoleData getPythonConsoleData(@Nullable ASTNode element) {
        block5: {
            block4: {
                if (element == null || element.getPsi() == null) break block4;
                PsiElement psiElement = element.getPsi();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.psi");
                if (psiElement.getContainingFile() != null) break block5;
            }
            return null;
        }
        PsiElement psiElement = element.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.psi");
        VirtualFile virtualFile = PydevConsoleRunnerImpl.getConsoleFile(psiElement.getContainingFile());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        return (PythonConsoleData)file.getUserData(PyConsoleUtil.PYTHON_CONSOLE_DATA);
    }

    private static final ConsoleCommunication getConsoleCommunication(PsiElement element) {
        PsiFile containingFile;
        PsiFile psiFile = containingFile = element.getContainingFile();
        return psiFile != null ? (ConsoleCommunication)psiFile.getCopyableUserData(PydevConsoleRunner.CONSOLE_COMMUNICATION_KEY) : null;
    }

    @Nullable
    public static final Sdk getConsoleSdk(@NotNull PsiElement element) {
        PsiFile containingFile;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = containingFile = element.getContainingFile();
        return psiFile != null ? (Sdk)psiFile.getCopyableUserData(PydevConsoleRunner.CONSOLE_SDK) : null;
    }
}

