/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.numpy.codeInsight;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.numpy.codeInsight.NumpyUfuncs;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.NumpyDocString;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeProviderBase;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.toolbox.Substring;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NumpyDocStringTypeProvider
extends PyTypeProviderBase {
    private static final Map<String, String> NUMPY_ALIAS_TO_REAL_TYPE = new HashMap<String, String>();
    private static final Pattern REDIRECT = Pattern.compile("^Refer to `(.*)` for full documentation.$");
    private static final Pattern NUMPY_UNION_PATTERN = Pattern.compile("^\\{(.*)\\}$");
    private static final Pattern NUMPY_ARRAY_PATTERN = Pattern.compile("(\\(\\.\\.\\..*\\))(.*)");
    public static final String NDARRAY = "numpy.core.multiarray.ndarray";
    private static final String NDARRAY_OR_ITERABLE = "numpy.core.multiarray.ndarray or collections.Iterable or int or long or float";

    @Nullable
    private static NumpyDocString forFunction(@NotNull PyFunction function, @Nullable PsiElement reference, @Nullable String knownSignature) {
        PyClass cls;
        String docString;
        if (function == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(0);
        }
        if ((docString = function.getDocStringValue()) == null && (cls = PyUtil.turnConstructorIntoClass(function)) != null) {
            docString = cls.getDocStringValue();
        }
        if (docString != null) {
            PyFunction resolvedFunction;
            NumpyDocString parsed = (NumpyDocString)DocStringUtil.parseDocStringContent(DocStringFormat.NUMPY, docString);
            if (parsed.getReturnFields().isEmpty() && parsed.getParameterFields().isEmpty()) {
                return null;
            }
            String signature = parsed.getSignature();
            String redirect = NumpyDocStringTypeProvider.findRedirect(parsed.getLines());
            if (redirect != null && reference != null && (resolvedFunction = NumpyDocStringTypeProvider.resolveRedirectToFunction(redirect, reference)) != null) {
                return NumpyDocStringTypeProvider.forFunction(resolvedFunction, reference, knownSignature != null ? knownSignature : signature);
            }
            return parsed;
        }
        return null;
    }

    @Nullable
    public static NumpyDocString forFunction(@NotNull PyFunction function, @Nullable PsiElement reference) {
        if (function == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(1);
        }
        return NumpyDocStringTypeProvider.forFunction(function, reference, null);
    }

    @Nullable
    private static String findRedirect(@NotNull List<Substring> lines) {
        if (lines == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(2);
        }
        for (Substring line2 : lines) {
            Matcher matcher = REDIRECT.matcher(line2);
            if (!matcher.matches() || matcher.groupCount() <= 0) continue;
            return matcher.group(1);
        }
        return null;
    }

    @Nullable
    private static PyFunction resolveRedirectToFunction(@NotNull String redirect, @NotNull PsiElement reference) {
        if (redirect == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(3);
        }
        if (reference == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(4);
        }
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)redirect);
        String functionName = qualifiedName.getLastComponent();
        List<PsiElement> items = PyResolveImportUtil.resolveQualifiedName(qualifiedName.removeLastComponent(), PyResolveImportUtil.fromFoothold(reference));
        for (PsiElement item : items) {
            PsiElement element;
            if (item instanceof PsiDirectory) {
                item = ((PsiDirectory)item).findFile("__init__.py");
            }
            if (!(item instanceof PyFile) || !((element = ((PyFile)item).getElementNamed(functionName)) instanceof PyFunction)) continue;
            return (PyFunction)element;
        }
        return null;
    }

    @Nullable
    public static String cleanupOptional(@NotNull String typeString) {
        int index;
        if (typeString == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(5);
        }
        if ((index = typeString.indexOf(", optional")) >= 0) {
            return typeString.substring(0, index);
        }
        return null;
    }

    @NotNull
    public static List<String> getNumpyUnionType(@NotNull String typeString) {
        Matcher matcher;
        Matcher arrayMatcher;
        if (typeString == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(6);
        }
        if ((arrayMatcher = NUMPY_ARRAY_PATTERN.matcher(typeString)).matches()) {
            typeString = arrayMatcher.group(2);
        }
        if ((matcher = NUMPY_UNION_PATTERN.matcher(typeString)).matches()) {
            typeString = matcher.group(1);
        }
        List<String> list = Arrays.asList(typeString.split(" *, *"));
        if (list == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @Nullable
    public Ref<PyType> getCallType(@NotNull PyFunction function, @NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context2) {
        PyExpression callee;
        NumpyDocString docString;
        if (function == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(8);
        }
        if (callSite == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(9);
        }
        if (context2 == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(10);
        }
        if (NumpyDocStringTypeProvider.isApplicable(function) && (docString = NumpyDocStringTypeProvider.forFunction(function, (PsiElement)(callee = callSite instanceof PyCallExpression ? ((PyCallExpression)callSite).getCallee() : null))) != null) {
            List<SectionBasedDocString.SectionField> returns = docString.getReturnFields();
            PyPsiFacade facade = NumpyDocStringTypeProvider.getPsiFacade(function);
            switch (returns.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return Optional.ofNullable(returns.get(0).getType()).filter(StringUtil::isNotEmpty).map(typeName -> NumpyDocStringTypeProvider.isUfuncType(function, typeName) ? facade.parseTypeAnnotation("T", function) : NumpyDocStringTypeProvider.parseNumpyDocType(function, typeName)).map(type -> PyTypingTypeProvider.toAsyncIfNeeded(function, type)).map(Ref::create).orElse(null);
                }
            }
            ArrayList<PyType> unionMembers = new ArrayList<PyType>();
            ArrayList<PyType> members2 = new ArrayList<PyType>();
            for (int i = 0; i < returns.size(); ++i) {
                boolean isOptional;
                String memberTypeName = returns.get(i).getType();
                PyType returnType = StringUtil.isNotEmpty((String)memberTypeName) ? NumpyDocStringTypeProvider.parseNumpyDocType(function, memberTypeName) : null;
                boolean bl = isOptional = StringUtil.isNotEmpty((String)memberTypeName) && memberTypeName.contains("optional");
                if (isOptional && i != 0) {
                    if (members2.size() > 1) {
                        unionMembers.add(facade.createTupleType(members2, function));
                    } else if (members2.size() == 1) {
                        unionMembers.add((PyType)members2.get(0));
                    }
                }
                members2.add(returnType);
                if (i != returns.size() - 1 || !isOptional) continue;
                unionMembers.add(facade.createTupleType(members2, function));
            }
            PyType type2 = unionMembers.isEmpty() ? facade.createTupleType(members2, function) : facade.createUnionType(unionMembers);
            return Ref.create((Object)PyTypingTypeProvider.toAsyncIfNeeded(function, type2));
        }
        return null;
    }

    @Override
    @Nullable
    public Ref<PyType> getParameterType(@NotNull PyNamedParameter parameter, @NotNull PyFunction function, @NotNull TypeEvalContext context2) {
        PyType type;
        String name2;
        if (parameter == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(11);
        }
        if (function == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(12);
        }
        if (context2 == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(13);
        }
        if (NumpyDocStringTypeProvider.isApplicable(function) && (name2 = parameter.getName()) != null && (type = NumpyDocStringTypeProvider.getParameterType(function, name2)) != null) {
            return Ref.create((Object)type);
        }
        return null;
    }

    public static boolean isInsideNumPy(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(14);
        }
        if ((file = element.getContainingFile()) != null) {
            PyPsiFacade facade = NumpyDocStringTypeProvider.getPsiFacade(element);
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                String name2 = facade.findShortestImportableName(virtualFile, element);
                return name2 != null && (name2.startsWith("numpy.") || name2.startsWith("matplotlib.") || name2.startsWith("scipy."));
            }
        }
        return false;
    }

    private static boolean isApplicable(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(15);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null && PyDocumentationSettings.getInstance(module).isNumpyFormat(element.getContainingFile())) {
            return true;
        }
        return NumpyDocStringTypeProvider.isInsideNumPy(element);
    }

    private static PyPsiFacade getPsiFacade(@NotNull PsiElement anchor) {
        if (anchor == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(16);
        }
        return PyPsiFacade.getInstance(anchor.getProject());
    }

    @Nullable
    private static PyType parseSingleNumpyDocType(@NotNull PsiElement anchor, @NotNull String typeString) {
        String realTypeName;
        PyPsiFacade facade;
        PyType type;
        if (anchor == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(17);
        }
        if (typeString == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(18);
        }
        if ((type = (facade = NumpyDocStringTypeProvider.getPsiFacade(anchor)).parseTypeAnnotation(realTypeName = NumpyDocStringTypeProvider.getNumpyRealTypeName(typeString), anchor)) != null) {
            return type;
        }
        type = facade.parseTypeAnnotation(typeString, anchor);
        if (type != null) {
            return type;
        }
        return NumpyDocStringTypeProvider.getNominalType(anchor, typeString);
    }

    @NotNull
    private static String getNumpyRealTypeName(@NotNull String typeString) {
        String realTypeName;
        if (typeString == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(19);
        }
        if ((realTypeName = NUMPY_ALIAS_TO_REAL_TYPE.get(typeString)) != null) {
            String string = realTypeName;
            if (string == null) {
                NumpyDocStringTypeProvider.$$$reportNull$$$0(20);
            }
            return string;
        }
        List typeSubStrings = StringUtil.split((String)typeString, (String)" ");
        ArrayList<String> typeParts = new ArrayList<String>();
        for (String string : typeSubStrings) {
            String type = NUMPY_ALIAS_TO_REAL_TYPE.get(string);
            typeParts.add(type != null ? type : string);
        }
        String string = typeString = StringUtil.join(typeParts, (String)" ");
        if (string == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    private static PyType getNominalType(@NotNull PsiElement anchor, @NotNull String typeString) {
        PyExpression expression;
        if (anchor == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(22);
        }
        if (typeString == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(23);
        }
        if ((expression = PyUtil.createExpressionFromFragment(typeString, anchor)) != null) {
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(anchor);
            if (expression instanceof PyStringLiteralExpression) {
                return builtinCache.getStrType();
            }
            if (expression instanceof PyNumericLiteralExpression) {
                return builtinCache.getIntType();
            }
        }
        return null;
    }

    @Nullable
    private static PyType parseNumpyDocType(@NotNull PsiElement anchor, @NotNull String typeString) {
        if (anchor == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(24);
        }
        if (typeString == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(25);
        }
        String withoutOptional = NumpyDocStringTypeProvider.cleanupOptional(typeString);
        LinkedHashSet<PyType> types = new LinkedHashSet<PyType>();
        if (withoutOptional != null) {
            typeString = withoutOptional;
        }
        for (String typeName : NumpyDocStringTypeProvider.getNumpyUnionType(typeString)) {
            PyType parsedType = NumpyDocStringTypeProvider.parseSingleNumpyDocType(anchor, typeName);
            if (parsedType == null) continue;
            types.add(parsedType);
        }
        if (!types.isEmpty() && withoutOptional != null) {
            types.add(PyNoneType.INSTANCE);
        }
        return NumpyDocStringTypeProvider.getPsiFacade(anchor).createUnionType(types);
    }

    public static boolean isUfuncType(@NotNull PsiElement anchor, @NotNull String typeString) {
        if (anchor == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(26);
        }
        if (typeString == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(27);
        }
        for (String typeName : NumpyDocStringTypeProvider.getNumpyUnionType(typeString)) {
            if (!(anchor instanceof PyFunction) || !NumpyDocStringTypeProvider.isInsideNumPy(anchor) || !NumpyUfuncs.isUFunc(((PyFunction)anchor).getName()) || !"array_like".equals(typeName) && !"ndarray".equals(typeName)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PyType getParameterType(@NotNull PyFunction function, @NotNull String parameterName) {
        NumpyDocString docString;
        if (function == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(28);
        }
        if (parameterName == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(29);
        }
        if ((docString = NumpyDocStringTypeProvider.forFunction(function, function)) != null) {
            String paramType = docString.getParamType(parameterName);
            if (paramType == null && parameterName.startsWith("p_")) {
                paramType = docString.getParamType(parameterName.substring(2));
            }
            if (paramType != null) {
                if (NumpyDocStringTypeProvider.isUfuncType(function, paramType)) {
                    return NumpyDocStringTypeProvider.getPsiFacade(function).parseTypeAnnotation("numbers.Number or numpy.core.multiarray.ndarray or collections.Iterable", function);
                }
                PyType numpyDocType = NumpyDocStringTypeProvider.parseNumpyDocType(function, paramType);
                if ("size".equals(parameterName)) {
                    return NumpyDocStringTypeProvider.getPsiFacade(function).createUnionType(Arrays.asList(numpyDocType, PyBuiltinCache.getInstance(function).getIntType()));
                }
                return numpyDocType;
            }
        }
        return null;
    }

    @Override
    public Ref<PyType> getReferenceType(@NotNull PsiElement referenceTarget, @NotNull TypeEvalContext context2, @Nullable PsiElement anchor) {
        PyClass uFuncClass;
        if (referenceTarget == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(30);
        }
        if (context2 == null) {
            NumpyDocStringTypeProvider.$$$reportNull$$$0(31);
        }
        if (referenceTarget instanceof PyFunction && NumpyUfuncs.isUFunc(((PyFunction)referenceTarget).getName()) && NumpyDocStringTypeProvider.isInsideNumPy(referenceTarget) && (uFuncClass = PyPsiFacade.getInstance(referenceTarget.getProject()).findClass("numpy.core.ufunc")) != null) {
            return Ref.create((Object)new PyClassTypeImpl(uFuncClass, false));
        }
        return null;
    }

    static {
        NUMPY_ALIAS_TO_REAL_TYPE.put("ndarray", NDARRAY);
        NUMPY_ALIAS_TO_REAL_TYPE.put("numpy.ndarray", NDARRAY);
        NUMPY_ALIAS_TO_REAL_TYPE.put("array_like", NDARRAY_OR_ITERABLE);
        NUMPY_ALIAS_TO_REAL_TYPE.put("array-like", NDARRAY_OR_ITERABLE);
        NUMPY_ALIAS_TO_REAL_TYPE.put("data-type", "object");
        NUMPY_ALIAS_TO_REAL_TYPE.put("dtype", "object");
        NUMPY_ALIAS_TO_REAL_TYPE.put("scalar", "int or long or float or complex");
        NUMPY_ALIAS_TO_REAL_TYPE.put("array", NDARRAY_OR_ITERABLE);
        NUMPY_ALIAS_TO_REAL_TYPE.put("numpy.array", NDARRAY_OR_ITERABLE);
        NUMPY_ALIAS_TO_REAL_TYPE.put("any", "object");
        NUMPY_ALIAS_TO_REAL_TYPE.put("Standard Python scalar object", "int or long or float or complex");
        NUMPY_ALIAS_TO_REAL_TYPE.put("Python type", "object");
        NUMPY_ALIAS_TO_REAL_TYPE.put("callable", "collections.Callable");
        NUMPY_ALIAS_TO_REAL_TYPE.put("number", "int or long or float or complex");
        NUMPY_ALIAS_TO_REAL_TYPE.put("sequence", "collections.Iterable");
        NUMPY_ALIAS_TO_REAL_TYPE.put("set", "collections.Iterable");
        NUMPY_ALIAS_TO_REAL_TYPE.put("list", "collections.Iterable");
        NUMPY_ALIAS_TO_REAL_TYPE.put("tuple", "collections.Iterable or tuple");
        NUMPY_ALIAS_TO_REAL_TYPE.put("ints", "int");
        NUMPY_ALIAS_TO_REAL_TYPE.put("non-zero int", "int");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "redirect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: 
            case 6: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 7: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 10: 
            case 13: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 17: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumpyUnionType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumpyRealTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forFunction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findRedirect";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveRedirectToFunction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "cleanupOptional";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNumpyUnionType";
                break;
            }
            case 7: 
            case 20: 
            case 21: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInsideNumPy";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFacade";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseSingleNumpyDocType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNumpyRealTypeName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getNominalType";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseNumpyDocType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isUfuncType";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

