/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.toolbar;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.ui.toolbar.GitToolbarWidget;
import git4idea.ui.toolbar.GitToolbarWidgetKt;
import git4idea.ui.toolbar.GitWidgetUpdater;
import icons.DvcsImplIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\u0006\u0010\u001a\u001a\u00020\u0017J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u0010H\u0002J\f\u0010\u001f\u001a\u00020\u001e*\u00020\u0010H\u0002R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lgit4idea/ui/toolbar/GitWidgetUpdater;", "Lgit4idea/repo/GitRepositoryChangeListener;", "Lgit4idea/branch/GitBranchIncomingOutgoingManager$GitIncomingOutgoingListener;", "Lcom/intellij/openapi/project/ProjectManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "widget", "Lgit4idea/ui/toolbar/GitToolbarWidget;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/toolbar/GitToolbarWidget;)V", "INCOMING_CHANGES_ICON", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "OUTGOING_CHANGES_ICON", "getProject", "()Lcom/intellij/openapi/project/Project;", "repository", "Lgit4idea/repo/GitRepository;", "swingExecutor", "Ljava/util/concurrent/Executor;", "getWidget", "()Lgit4idea/ui/toolbar/GitToolbarWidget;", "guessCurrentRepo", "incomingOutgoingInfoChanged", "", "repositoryChanged", "repo", "subscribe", "updateIcons", "updateWidget", "calcText", "", "calcTooltip", "intellij.vcs.git"})
final class GitWidgetUpdater
implements GitRepositoryChangeListener,
GitBranchIncomingOutgoingManager.GitIncomingOutgoingListener,
ProjectManagerListener {
    private final Executor swingExecutor;
    private GitRepository repository;
    private final Icon INCOMING_CHANGES_ICON;
    private final Icon OUTGOING_CHANGES_ICON;
    @NotNull
    private final Project project;
    @NotNull
    private final GitToolbarWidget widget;

    public final void subscribe() {
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this.widget);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(widget)");
        MessageBusConnection connection = messageBusConnection;
        Topic<GitRepositoryChangeListener> topic = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"GitRepository.GIT_REPO_CHANGE");
        connection.subscribe(topic, (Object)this);
        Topic<GitBranchIncomingOutgoingManager.GitIncomingOutgoingListener> topic2 = GitBranchIncomingOutgoingManager.GIT_INCOMING_OUTGOING_CHANGED;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"GitBranchIncomingOutgoin\u2026INCOMING_OUTGOING_CHANGED");
        connection.subscribe(topic2, (Object)this);
    }

    @Override
    public void incomingOutgoingInfoChanged() {
        this.swingExecutor.execute(new Runnable(this){
            final /* synthetic */ GitWidgetUpdater this$0;

            public final void run() {
                GitWidgetUpdater.access$updateIcons(this.this$0);
            }
            {
                this.this$0 = gitWidgetUpdater;
            }
        });
    }

    @Override
    public void repositoryChanged(@NotNull GitRepository repo) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        this.swingExecutor.execute(new Runnable(this, repo){
            final /* synthetic */ GitWidgetUpdater this$0;
            final /* synthetic */ GitRepository $repo;

            public final void run() {
                GitWidgetUpdater.access$setRepository$p(this.this$0, this.$repo);
                GitWidgetUpdater.access$updateWidget(this.this$0);
            }
            {
                this.this$0 = gitWidgetUpdater;
                this.$repo = gitRepository;
            }
        });
    }

    private final void updateWidget() {
        this.widget.setProject(this.project);
        this.widget.setRepository(this.repository);
        Object object = this.repository;
        if (object == null || (object = this.calcText((GitRepository)object)) == null) {
            object = GitBundle.message("git.toolbar.widget.no.repo", new Object[0]);
        }
        this.widget.setText((String)object);
        Object object2 = this.repository;
        if (object2 == null || (object2 = this.calcTooltip((GitRepository)object2)) == null) {
            object2 = GitBundle.message("git.toolbar.widget.no.repo.tooltip", new Object[0]);
        }
        this.widget.setToolTipText((String)object2);
        this.updateIcons();
    }

    private final String calcText(GitRepository $this$calcText) {
        String string = GitBranchUtil.getBranchNameOrRev($this$calcText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBranchUtil.getBranchNameOrRev(this)");
        return GitToolbarWidgetKt.access$cutText(string);
    }

    private final String calcTooltip(GitRepository $this$calcTooltip) {
        if ($this$calcTooltip.getState() == Repository.State.DETACHED) {
            String string = GitBundle.message("git.status.bar.widget.tooltip.detached", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"git.s\u2026widget.tooltip.detached\")");
            return string;
        }
        String string = DvcsBundle.message((String)"tooltip.branch.widget.vcs.branch.name.text", (Object[])new Object[]{GitVcs.DISPLAY_NAME.get(), GitBranchUtil.getBranchNameOrRev($this$calcTooltip)});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DvcsBundle.message(\"tool\u2026getBranchNameOrRev(this))");
        Object message = string;
        if (!GitUtil.justOneGitRepository($this$calcTooltip.getProject())) {
            message = (String)message + "\n";
            Object[] objectArray = new Object[1];
            VirtualFile virtualFile = $this$calcTooltip.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"root");
            objectArray[0] = virtualFile.getName();
            message = (String)message + DvcsBundle.message((String)"tooltip.branch.widget.root.name.text", (Object[])objectArray);
        }
        return message;
    }

    private final void updateIcons() {
        List list2;
        Object object = this.repository;
        if (object != null && (object = object.getCurrentBranchName()) != null) {
            Object object2;
            Object branch = object2 = object;
            boolean bl = false;
            List res = new ArrayList();
            GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)gitBranchIncomingOutgoingManager, (String)"GitBranchIncomingOutgoin\u2026ager.getInstance(project)");
            GitBranchIncomingOutgoingManager incomingOutgoingManager = gitBranchIncomingOutgoingManager;
            if (incomingOutgoingManager.hasIncomingFor(this.repository, (String)branch)) {
                res.add(this.INCOMING_CHANGES_ICON);
            }
            if (incomingOutgoingManager.hasOutgoingFor(this.repository, (String)branch)) {
                res.add(this.OUTGOING_CHANGES_ICON);
            }
            list2 = res;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List icons = list2;
        this.widget.setRightIcons(icons);
    }

    private final GitRepository guessCurrentRepo(Project project) {
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        AbstractRepositoryManager abstractRepositoryManager = GitUtil.getRepositoryManager(project);
        GitVcsSettings gitVcsSettings = settings;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcsSettings), (String)"settings");
        return (GitRepository)DvcsUtil.guessCurrentRepositoryQuick((Project)project, (AbstractRepositoryManager)abstractRepositoryManager, (String)gitVcsSettings.getRecentRootPath());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GitToolbarWidget getWidget() {
        return this.widget;
    }

    public GitWidgetUpdater(@NotNull Project project, @NotNull GitToolbarWidget widget) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)widget), (String)"widget");
        this.project = project;
        this.widget = widget;
        this.swingExecutor = swingExecutor.1.INSTANCE;
        Icon icon = DvcsImplIcons.Incoming;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"DvcsImplIcons.Incoming");
        this.INCOMING_CHANGES_ICON = icon;
        Icon icon2 = DvcsImplIcons.Outgoing;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"DvcsImplIcons.Outgoing");
        this.OUTGOING_CHANGES_ICON = icon2;
        this.repository = this.guessCurrentRepo(this.project);
        this.updateWidget();
    }

    public static final /* synthetic */ void access$updateIcons(GitWidgetUpdater $this) {
        $this.updateIcons();
    }

    public static final /* synthetic */ GitRepository access$getRepository$p(GitWidgetUpdater $this) {
        return $this.repository;
    }

    public static final /* synthetic */ void access$setRepository$p(GitWidgetUpdater $this, GitRepository gitRepository) {
        $this.repository = gitRepository;
    }

    public static final /* synthetic */ void access$updateWidget(GitWidgetUpdater $this) {
        $this.updateWidget();
    }
}

