/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.Hash;
import git4idea.GitCommit;
import git4idea.stash.GitStashCache;
import git4idea.stash.GitStashOperations;
import git4idea.stash.GitStashTracker;
import git4idea.stash.GitStashTrackerKt;
import git4idea.ui.StashInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 (2\u00020\u0001:\u0003()*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ \u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010 2\u0006\u0010$\u001a\u00020\u0007H\u0002J\u0016\u0010%\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u001eJ\r\u0010&\u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\b'J\f\u0010\u001a\u001a\u00020\u0007*\u00020\u001eH\u0002RN\u0010\u0005\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006+"}, d2={"Lgit4idea/stash/GitStashCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/github/benmanes/caffeine/cache/AsyncLoadingCache;", "Lgit4idea/stash/GitStashCache$StashId;", "kotlin.jvm.PlatformType", "Lgit4idea/stash/GitStashCache$StashData;", "disposableFlag", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "executor", "Ljava/util/concurrent/ExecutorService;", "getProject", "()Lcom/intellij/openapi/project/Project;", "stashTracker", "Lgit4idea/stash/GitStashTracker;", "getStashTracker", "()Lgit4idea/stash/GitStashTracker;", "clear", "", "clear$intellij_vcs_git", "dispose", "doLoadStashData", "stashId", "getCachedData", "Lgit4idea/stash/GitStashCache$StashData$Changes;", "stashInfo", "Lgit4idea/ui/StashInfo;", "getFutureStashData", "Ljava/util/concurrent/CompletableFuture;", "cached", "", "loadFutureStashData", "id", "loadStashData", "preloadStashes", "preloadStashes$intellij_vcs_git", "Companion", "StashData", "StashId", "intellij.vcs.git"})
public final class GitStashCache
implements Disposable {
    private final CheckedDisposable disposableFlag;
    private final ExecutorService executor;
    private final AsyncLoadingCache<StashId, StashData> cache;
    @NotNull
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    private final GitStashTracker getStashTracker() {
        Project $this$service$iv = this.project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GitStashTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        return (GitStashTracker)object;
    }

    /*
     * WARNING - void declaration
     */
    private final StashData doLoadStashData(StashId stashId) {
        try {
            void changes;
            LOG.debug("Loading stash at '" + stashId.getHash() + "' in '" + stashId.getRoot() + "'");
            Pair<Collection<Change>, List<GitCommit>> pair = GitStashOperations.INSTANCE.loadStashChanges(this.project, stashId.getRoot(), stashId.getHash(), stashId.getParentHashes());
            Collection collection = (Collection)pair.component1();
            List indexChanges = (List)pair.component2();
            return new StashData.Changes((Collection<? extends Change>)changes, indexChanges);
        }
        catch (VcsException e) {
            LOG.warn("Could not load stash at '" + stashId.getHash() + "' in '" + stashId.getRoot() + "'", (Throwable)e);
            return new StashData.Error(e);
        }
        catch (Exception e) {
            if (!(e instanceof ProcessCanceledException)) {
                LOG.error("Could not load stash at '" + stashId.getHash() + "' in '" + stashId.getRoot() + "'", (Throwable)e);
            }
            throw (Throwable)new CompletionException(e);
        }
    }

    @Nullable
    public final CompletableFuture<StashData> loadStashData(@NotNull StashInfo stashInfo) {
        Intrinsics.checkNotNullParameter((Object)stashInfo, (String)"stashInfo");
        return this.getFutureStashData(stashInfo, false);
    }

    @Nullable
    public final StashData.Changes getCachedData(@NotNull StashInfo stashInfo) {
        Intrinsics.checkNotNullParameter((Object)stashInfo, (String)"stashInfo");
        CompletableFuture<StashData> completableFuture = this.getFutureStashData(stashInfo, true);
        StashData stashData = completableFuture != null ? (StashData)GitStashCache.Companion.getNowSafely(completableFuture) : null;
        if (!(stashData instanceof StashData.Changes)) {
            stashData = null;
        }
        return (StashData.Changes)stashData;
    }

    private final CompletableFuture<StashData> getFutureStashData(StashInfo stashInfo, boolean cached) {
        StashId id = this.stashId(stashInfo);
        return cached ? this.cache.getIfPresent((Object)id) : this.loadFutureStashData(id);
    }

    private final CompletableFuture<StashData> loadFutureStashData(StashId id) {
        CompletableFuture future2;
        if (this.disposableFlag.isDisposed()) {
            return null;
        }
        CompletableFuture completableFuture = future2 = this.cache.get((Object)id);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"future");
        return completableFuture.isCancelled() ? this.cache.synchronous().refresh((Object)id) : future2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void preloadStashes$intellij_vcs_git() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = GitStashTrackerKt.allStashes(this.getStashTracker());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StashInfo stashInfo = (StashInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            StashId stashId = this.stashId((StashInfo)it);
            collection.add(stashId);
        }
        Set currentStashes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set previousStashes = this.cache.synchronous().asMap().keySet();
        this.cache.synchronous().invalidateAll((Iterable)SetsKt.minus(previousStashes, (Iterable)currentStashes));
        Iterable $this$forEach$iv = currentStashes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StashId it = (StashId)element$iv;
            boolean bl = false;
            this.loadFutureStashData(it);
        }
    }

    private final StashId stashId(StashInfo $this$stashId) {
        return new StashId($this$stashId.getHash(), $this$stashId.getParentHashes(), $this$stashId.getRoot());
    }

    public final void clear$intellij_vcs_git() {
        this.cache.synchronous().invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.executor.shutdown();
        this.executor.awaitTermination(10L, TimeUnit.MILLISECONDS);
        this.clear$intellij_vcs_git();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public GitStashCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"Disposer.newCheckedDisposable()");
        this.disposableFlag = checkedDisposable;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Git Stash Loader", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026or(\"Git Stash Loader\", 1)");
        this.executor = executorService;
        this.cache = Caffeine.newBuilder().executor((Executor)this.executor).buildAsync(new AsyncCacheLoader(this){
            final /* synthetic */ GitStashCache this$0;

            public final CompletableFuture<? extends StashData> asyncLoad(StashId stashId, Executor executor) {
                BackgroundTaskUtil.BackgroundTask backgroundTask = BackgroundTaskUtil.submitTask((Executor)executor, (Disposable)this.this$0, (Computable)new Computable(this, stashId){
                    final /* synthetic */ cache.1 this$0;
                    final /* synthetic */ StashId $stashId;

                    public final StashData compute() {
                        GitStashCache gitStashCache = this.this$0.this$0;
                        StashId stashId = this.$stashId;
                        Intrinsics.checkNotNullExpressionValue((Object)stashId, (String)"stashId");
                        return GitStashCache.access$doLoadStashData(gitStashCache, stashId);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$stashId = stashId;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)backgroundTask, (String)"BackgroundTaskUtil.submi\u2026LoadStashData(stashId) })");
                return backgroundTask.getFuture();
            }
            {
                this.this$0 = gitStashCache;
            }
        });
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.disposableFlag));
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(GitStashCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(GitStashCache::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ StashData access$doLoadStashData(GitStashCache $this, StashId stashId) {
        return $this.doLoadStashData(stashId);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/stash/GitStashCache$StashData;", "", "()V", "Changes", "Error", "Lgit4idea/stash/GitStashCache$StashData$Changes;", "Lgit4idea/stash/GitStashCache$StashData$Error;", "intellij.vcs.git"})
    public static abstract class StashData {
        private StashData() {
        }

        public /* synthetic */ StashData(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000b"}, d2={"Lgit4idea/stash/GitStashCache$StashData$Changes;", "Lgit4idea/stash/GitStashCache$StashData;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "parentCommits", "Lgit4idea/GitCommit;", "(Ljava/util/Collection;Ljava/util/Collection;)V", "getChanges", "()Ljava/util/Collection;", "getParentCommits", "intellij.vcs.git"})
        public static final class Changes
        extends StashData {
            @NotNull
            private final Collection<Change> changes;
            @NotNull
            private final Collection<GitCommit> parentCommits;

            @NotNull
            public final Collection<Change> getChanges() {
                return this.changes;
            }

            @NotNull
            public final Collection<GitCommit> getParentCommits() {
                return this.parentCommits;
            }

            public Changes(@NotNull Collection<? extends Change> changes, @NotNull Collection<GitCommit> parentCommits) {
                Intrinsics.checkNotNullParameter(changes, (String)"changes");
                Intrinsics.checkNotNullParameter(parentCommits, (String)"parentCommits");
                super(null);
                this.changes = changes;
                this.parentCommits = parentCommits;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/stash/GitStashCache$StashData$Error;", "Lgit4idea/stash/GitStashCache$StashData;", "error", "Lcom/intellij/openapi/vcs/VcsException;", "(Lcom/intellij/openapi/vcs/VcsException;)V", "getError", "()Lcom/intellij/openapi/vcs/VcsException;", "intellij.vcs.git"})
        public static final class Error
        extends StashData {
            @NotNull
            private final VcsException error;

            @NotNull
            public final VcsException getError() {
                return this.error;
            }

            public Error(@NotNull VcsException error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                super(null);
                this.error = error;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lgit4idea/stash/GitStashCache$StashId;", "", "hash", "Lcom/intellij/vcs/log/Hash;", "parentHashes", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/vcs/log/Hash;Ljava/util/List;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getHash", "()Lcom/intellij/vcs/log/Hash;", "getParentHashes", "()Ljava/util/List;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.git"})
    private static final class StashId {
        @NotNull
        private final Hash hash;
        @NotNull
        private final List<Hash> parentHashes;
        @NotNull
        private final VirtualFile root;

        @NotNull
        public final Hash getHash() {
            return this.hash;
        }

        @NotNull
        public final List<Hash> getParentHashes() {
            return this.parentHashes;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        public StashId(@NotNull Hash hash, @NotNull List<? extends Hash> parentHashes, @NotNull VirtualFile root) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter(parentHashes, (String)"parentHashes");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.hash = hash;
            this.parentHashes = parentHashes;
            this.root = root;
        }

        @NotNull
        public final Hash component1() {
            return this.hash;
        }

        @NotNull
        public final List<Hash> component2() {
            return this.parentHashes;
        }

        @NotNull
        public final VirtualFile component3() {
            return this.root;
        }

        @NotNull
        public final StashId copy(@NotNull Hash hash, @NotNull List<? extends Hash> parentHashes, @NotNull VirtualFile root) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter(parentHashes, (String)"parentHashes");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            return new StashId(hash, parentHashes, root);
        }

        public static /* synthetic */ StashId copy$default(StashId stashId, Hash hash, List list2, VirtualFile virtualFile, int n, Object object) {
            if ((n & 1) != 0) {
                hash = stashId.hash;
            }
            if ((n & 2) != 0) {
                list2 = stashId.parentHashes;
            }
            if ((n & 4) != 0) {
                virtualFile = stashId.root;
            }
            return stashId.copy(hash, list2, virtualFile);
        }

        @NotNull
        public String toString() {
            return "StashId(hash=" + this.hash + ", parentHashes=" + this.parentHashes + ", root=" + this.root + ")";
        }

        public int hashCode() {
            Hash hash = this.hash;
            List<Hash> list2 = this.parentHashes;
            VirtualFile virtualFile = this.root;
            return ((hash != null ? hash.hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (virtualFile != null ? virtualFile.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StashId)) break block3;
                    StashId stashId = (StashId)object;
                    if (!Intrinsics.areEqual((Object)this.hash, (Object)stashId.hash) || !Intrinsics.areEqual(this.parentHashes, stashId.parentHashes) || !Intrinsics.areEqual((Object)this.root, (Object)stashId.root)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0006\u001a\u0004\u0018\u0001H\u0007\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\bH\u0002\u00a2\u0006\u0002\u0010\tR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/stash/GitStashCache$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getNowSafely", "T", "Ljava/util/concurrent/CompletableFuture;", "(Ljava/util/concurrent/CompletableFuture;)Ljava/lang/Object;", "intellij.vcs.git"})
    public static final class Companion {
        private final <T> T getNowSafely(CompletableFuture<T> $this$getNowSafely) {
            T t;
            try {
                t = $this$getNowSafely.getNow(null);
            }
            catch (Throwable e) {
                t = null;
            }
            return t;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

