/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.impl.VcsCommitMetadataImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.log.LoadCommitDetailsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0000\u001a2\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getCommitDataFromCache", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "data", "Lcom/intellij/vcs/log/data/VcsLogData;", "commit", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "getOrLoadDetails", "", "project", "Lcom/intellij/openapi/project/Project;", "commitList", "loadDetails", "", "commits", "", "intellij.vcs.git"})
public final class GitLogCommitDetailsLoaderKt {
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VcsCommitMetadata> getOrLoadDetails(@NotNull Project project, @NotNull VcsLogData data, @NotNull List<? extends VcsShortCommitDetails> commitList) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(commitList, (String)"commitList");
        HashSet<VcsShortCommitDetails> commitsToLoad = new HashSet<VcsShortCommitDetails>((Collection)commitList);
        HashMap<VcsShortCommitDetails, VcsCommitMetadata> result2 = new HashMap<VcsShortCommitDetails, VcsCommitMetadata>();
        Iterable $this$forEach$iv = commitList;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            VcsCommitMetadata commitMetadata;
            VcsCommitMetadata vcsCommitMetadata;
            VcsShortCommitDetails commit = (VcsShortCommitDetails)element$iv2;
            boolean bl = false;
            VcsShortCommitDetails vcsShortCommitDetails = commit;
            if (!(vcsShortCommitDetails instanceof VcsCommitMetadata)) {
                vcsShortCommitDetails = null;
            }
            if ((vcsCommitMetadata = (VcsCommitMetadata)vcsShortCommitDetails) == null) {
                vcsCommitMetadata = commitMetadata = GitLogCommitDetailsLoaderKt.getCommitDataFromCache(data, commit);
            }
            if (commitMetadata != null) {
                ((Map)result2).put(commit, commitMetadata);
                continue;
            }
            commitsToLoad.add(commit);
        }
        Map<VcsShortCommitDetails, VcsCommitMetadata> loadedDetails = GitLogCommitDetailsLoaderKt.loadDetails(project, data, (Collection<? extends VcsShortCommitDetails>)commitsToLoad);
        result2.putAll(loadedDetails);
        Iterable $this$map$iv = commitList;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            VcsCommitMetadata vcsCommitMetadata;
            void it;
            VcsShortCommitDetails vcsShortCommitDetails = (VcsShortCommitDetails)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if ((VcsCommitMetadata)result2.get(it) == null) {
                throw (Throwable)new LoadCommitDetailsException();
            }
            collection.add(vcsCommitMetadata);
        }
        return (List)destination$iv$iv;
    }

    private static final VcsCommitMetadata getCommitDataFromCache(VcsLogData data, VcsShortCommitDetails commit) {
        String message;
        int commitIndex = data.getCommitIndex((Hash)commit.getId(), commit.getRoot());
        VcsFullCommitDetails commitData = data.getCommitDetailsGetter().getCommitDataIfAvailable(commitIndex);
        if (commitData != null) {
            return (VcsCommitMetadata)commitData;
        }
        VcsLogIndex vcsLogIndex = data.getIndex();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogIndex, (String)"data.index");
        IndexDataGetter indexDataGetter = vcsLogIndex.getDataGetter();
        String string = message = indexDataGetter != null ? indexDataGetter.getFullMessage(commitIndex) : null;
        if (message != null) {
            return (VcsCommitMetadata)new VcsCommitMetadataImpl((Hash)commit.getId(), commit.getParents(), commit.getCommitTime(), commit.getRoot(), commit.getSubject(), commit.getAuthor(), message, commit.getCommitter(), commit.getAuthorTime());
        }
        return null;
    }

    private static final Map<VcsShortCommitDetails, VcsCommitMetadata> loadDetails(Project project, VcsLogData data, Collection<? extends VcsShortCommitDetails> commits2) {
        HashMap result2 = new HashMap();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(commits2, data, result2, project){
            final /* synthetic */ Collection $commits;
            final /* synthetic */ VcsLogData $data;
            final /* synthetic */ HashMap $result;
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                try {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List commitList = CollectionsKt.toList((Iterable)this.$commits);
                    if (commitList.isEmpty()) {
                        return;
                    }
                    VirtualFile virtualFile = ((VcsShortCommitDetails)CollectionsKt.first((Iterable)this.$commits)).getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"commits.first().root");
                    VirtualFile root = virtualFile;
                    Iterable iterable = commitList;
                    VirtualFile virtualFile2 = root;
                    VcsLogProvider vcsLogProvider = this.$data.getLogProvider(root);
                    boolean $i$f$map = false;
                    void var6_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        VcsShortCommitDetails vcsShortCommitDetails = (VcsShortCommitDetails)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        String string = ((Hash)it.getId()).asString();
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv;
                    List list2 = VcsLogUtil.getDetails((VcsLogProvider)vcsLogProvider, (VirtualFile)virtualFile2, (List)collection);
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"VcsLogUtil.getDetails(da\u2026map { it.id.asString() })");
                    List commitListData = list2;
                    MapsKt.putAll((Map)this.$result, (Iterable)CollectionsKt.zip((Iterable)commitList, (Iterable)commitListData));
                }
                catch (VcsException e) {
                    String string = GitBundle.message("rebase.log.action.loading.commit.message.failed.message", this.$commits.size());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"rebas\u2026d.message\", commits.size)");
                    String error = string;
                    GitLogCommitDetailsLoaderKt.access$getLOG$p().warn(error, (Throwable)e);
                    Notification notification2 = VcsNotifier.STANDARD_NOTIFICATION.createNotification(error, NotificationType.ERROR).setDisplayId("git.log.could.not.load.changes.of.commit");
                    Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"VcsNotifier.STANDARD_NOT\u2026AD_CHANGES_OF_COMMIT_LOG)");
                    Notification notification3 = notification2;
                    Intrinsics.checkNotNullExpressionValue((Object)VcsNotifier.getInstance((Project)this.$project).notify(notification3), (String)"VcsNotifier.getInstance(\u2026ect).notify(notification)");
                }
            }
            {
                this.$commits = collection;
                this.$data = vcsLogData;
                this.$result = hashMap;
                this.$project = project;
            }
        }, GitBundle.message("rebase.log.action.progress.indicator.loading.commit.message.title", commits2.size()), true, project);
        return result2;
    }

    static {
        Logger logger = Logger.getInstance((String)"Git.Rebase.Log.Action.CommitDetailsLoader");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"Git.\u2026ion.CommitDetailsLoader\")");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

