/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.history.GitLogUtil;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "", "()V", "Complete", "Incomplete", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Incomplete;", "intellij.vcs.git"})
public abstract class GitCommitEditingOperationResult {
    private GitCommitEditingOperationResult() {
    }

    public /* synthetic */ GitCommitEditingOperationResult(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "repository", "Lgit4idea/repo/GitRepository;", "base", "", "oldHead", "newHead", "(Lgit4idea/repo/GitRepository;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "firstChangedHash", "Lcom/intellij/vcs/log/Hash;", "getRepository", "()Lgit4idea/repo/GitRepository;", "checkUndoPossibility", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility;", "findFirstChangedHash", "undo", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult;", "UndoPossibility", "UndoResult", "intellij.vcs.git"})
    public static final class Complete
    extends GitCommitEditingOperationResult {
        private final Hash firstChangedHash;
        @NotNull
        private final GitRepository repository;
        private final String base;
        private final String oldHead;
        private final String newHead;

        private final Hash findFirstChangedHash() {
            String changedCommitsRange = this.base + ".." + this.newHead;
            VcsLogProvider.DetailedLogData detailedLogData = GitLogUtil.collectMetadata(this.repository.getProject(), this.repository.getRoot(), changedCommitsRange);
            Intrinsics.checkNotNullExpressionValue((Object)detailedLogData, (String)"GitLogUtil.collectMetada\u2026oot, changedCommitsRange)");
            List list2 = detailedLogData.getCommits();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"GitLogUtil.collectMetada\u2026ngedCommitsRange).commits");
            List changedCommits = list2;
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)CollectionsKt.lastOrNull((List)changedCommits);
            return vcsCommitMetadata != null ? (Hash)vcsCommitMetadata.getId() : null;
        }

        @NotNull
        public final UndoPossibility checkUndoPossibility() {
            this.repository.update();
            if (Intrinsics.areEqual((Object)this.repository.getCurrentRevision(), (Object)this.newHead) ^ true) {
                return UndoPossibility.Impossible.HeadMoved.INSTANCE;
            }
            if (this.firstChangedHash == null) {
                return UndoPossibility.Possible.INSTANCE;
            }
            String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranchContainingCommit(this.repository, this.firstChangedHash);
            if (protectedBranch != null) {
                return new UndoPossibility.Impossible.PushedToProtectedBranch(protectedBranch);
            }
            return UndoPossibility.Possible.INSTANCE;
        }

        @NotNull
        public final UndoResult undo() {
            UndoResult undoResult;
            GitCommandResult gitCommandResult = Git.getInstance().reset(this.repository, GitResetMode.KEEP, this.oldHead, new GitLineHandlerListener[0]);
            Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"Git.getInstance().reset(\u2026tResetMode.KEEP, oldHead)");
            GitCommandResult res = gitCommandResult;
            this.repository.update();
            if (res.success()) {
                GitUtil.updateAndRefreshChangedVfs(this.repository, HashImpl.build((String)this.newHead));
                undoResult = UndoResult.Success.INSTANCE;
            } else {
                String string = res.getErrorOutputAsHtmlString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"res.errorOutputAsHtmlString");
                undoResult = new UndoResult.Error(string);
            }
            return undoResult;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        public Complete(@NotNull GitRepository repository, @NotNull String base, @NotNull String oldHead, @NotNull String newHead) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)oldHead, (String)"oldHead");
            Intrinsics.checkNotNullParameter((Object)newHead, (String)"newHead");
            super(null);
            this.repository = repository;
            this.base = base;
            this.oldHead = oldHead;
            this.newHead = newHead;
            this.firstChangedHash = this.findFirstChangedHash();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult;", "", "()V", "Error", "Success", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult$Success;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult$Error;", "intellij.vcs.git"})
        public static abstract class UndoResult {
            private UndoResult() {
            }

            public /* synthetic */ UndoResult(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult$Success;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult;", "()V", "intellij.vcs.git"})
            public static final class Success
            extends UndoResult {
                @NotNull
                public static final Success INSTANCE;

                private Success() {
                    super(null);
                }

                static {
                    Success success;
                    INSTANCE = success = new Success();
                }
            }

            @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult$Error;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult;", "errorHtml", "", "(Ljava/lang/String;)V", "getErrorHtml", "()Ljava/lang/String;", "intellij.vcs.git"})
            public static final class Error
            extends UndoResult {
                @NotNull
                private final String errorHtml;

                @NotNull
                public final String getErrorHtml() {
                    return this.errorHtml;
                }

                public Error(@NlsContexts.NotificationContent @NotNull String errorHtml) {
                    Intrinsics.checkNotNullParameter((Object)errorHtml, (String)"errorHtml");
                    super(null);
                    this.errorHtml = errorHtml;
                }
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility;", "", "()V", "Impossible", "Possible", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Possible;", "intellij.vcs.git"})
        public static abstract class UndoPossibility {
            private UndoPossibility() {
            }

            public /* synthetic */ UndoPossibility(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility;", "()V", "HeadMoved", "PushedToProtectedBranch", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible$HeadMoved;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible$PushedToProtectedBranch;", "intellij.vcs.git"})
            public static abstract class Impossible
            extends UndoPossibility {
                private Impossible() {
                    super(null);
                }

                public /* synthetic */ Impossible(DefaultConstructorMarker $constructor_marker) {
                    this();
                }

                @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible$HeadMoved;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible;", "()V", "intellij.vcs.git"})
                public static final class HeadMoved
                extends Impossible {
                    @NotNull
                    public static final HeadMoved INSTANCE;

                    private HeadMoved() {
                        super(null);
                    }

                    static {
                        HeadMoved headMoved;
                        INSTANCE = headMoved = new HeadMoved();
                    }
                }

                @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible$PushedToProtectedBranch;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible;", "branch", "", "(Ljava/lang/String;)V", "getBranch", "()Ljava/lang/String;", "intellij.vcs.git"})
                public static final class PushedToProtectedBranch
                extends Impossible {
                    @NotNull
                    private final String branch;

                    @NotNull
                    public final String getBranch() {
                        return this.branch;
                    }

                    public PushedToProtectedBranch(@NotNull String branch) {
                        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                        super(null);
                        this.branch = branch;
                    }
                }
            }

            @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Possible;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility;", "()V", "intellij.vcs.git"})
            public static final class Possible
            extends UndoPossibility {
                @NotNull
                public static final Possible INSTANCE;

                private Possible() {
                    super(null);
                }

                static {
                    Possible possible;
                    INSTANCE = possible = new Possible();
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperationResult$Incomplete;", "Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "()V", "intellij.vcs.git"})
    public static final class Incomplete
    extends GitCommitEditingOperationResult {
        @NotNull
        public static final Incomplete INSTANCE;

        private Incomplete() {
            super(null);
        }

        static {
            Incomplete incomplete;
            INSTANCE = incomplete = new Incomplete();
        }
    }
}

