/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.ui.presentation;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.intellij.plugins.markdown.editor.tables.TableFormattingUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.TableActionKeys;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.GraphicsUtils;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.PresentationWithCustomCursor;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.TableInlayProperties;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.VerticalBarPresentation$WhenMappings;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 52\u00020\u0001:\u0003456B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\rH\u0002J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001fH\u0002J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001fH\u0002J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0005H\u0002J\u0018\u0010(\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001fH\u0016J\u0018\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010-\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010.\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010/\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J\b\u00100\u001a\u00020\u0007H\u0002J\b\u00101\u001a\u00020\u0017H\u0002J\b\u00102\u001a\u000203H\u0016R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000f\u00a8\u00067"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "row", "Lcom/intellij/psi/PsiElement;", "hover", "", "accent", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiElement;ZZ)V", "boundsState", "Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation$BoundsState;", "height", "", "getHeight", "()I", "rowLocation", "Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation$RowLocation;", "getRowLocation", "()Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation$RowLocation;", "width", "getWidth", "actuallyPaintBar", "", "graphics", "Ljava/awt/Graphics2D;", "rect", "Ljava/awt/Rectangle;", "calculateBarRect", "location", "calculateToolbarPosition", "Ljava/awt/Point;", "componentHeight", "handleMouseLeftClick", "event", "Ljava/awt/event/MouseEvent;", "translated", "handleMouseLeftDoubleClick", "hasRowAfter", "element", "mouseClicked", "paint", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "paintFirstCircles", "paintLastCircles", "paintOtherCircles", "paintRow", "shouldShowInlay", "showToolbar", "toString", "", "BoundsState", "Companion", "RowLocation", "intellij.markdown.core"})
public final class VerticalBarPresentation
extends BasePresentation {
    private BoundsState boundsState;
    private final Editor editor;
    private final PsiElement row;
    private final boolean hover;
    private final boolean accent;
    public static final int barWidth = 6;
    private static final BoundsState initialState;
    @NotNull
    public static final Companion Companion;

    private final boolean shouldShowInlay() {
        if (!this.row.isValid() || this.editor.isDisposed()) {
            return false;
        }
        MarkdownTable markdownTable = TableUtils.findTable(this.row);
        if (markdownTable == null) {
            return false;
        }
        MarkdownTable table = markdownTable;
        return !TableFormattingUtils.INSTANCE.isSoftWrapping(table, this.editor);
    }

    public int getWidth() {
        return this.boundsState.getWidth();
    }

    public int getHeight() {
        return this.boundsState.getHeight();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final RowLocation getRowLocation() {
        PsiElement psiElement;
        RowLocation rowLocation;
        PsiElement psiElement2 = this.row;
        if (!(psiElement2 instanceof MarkdownTableRow)) {
            psiElement2 = null;
        }
        MarkdownTableRow markdownTableRow = (MarkdownTableRow)psiElement2;
        if (markdownTableRow != null) {
            if (TableUtils.INSTANCE.isHeaderRow(markdownTableRow)) {
                rowLocation = RowLocation.FIRST;
                return rowLocation;
            }
        }
        if (!((psiElement = this.row) instanceof MarkdownTableRow)) {
            psiElement = null;
        }
        MarkdownTableRow markdownTableRow2 = (MarkdownTableRow)psiElement;
        if (markdownTableRow2 != null) {
            if (TableUtils.INSTANCE.isLast(markdownTableRow2)) {
                rowLocation = RowLocation.LAST;
                return rowLocation;
            }
        }
        rowLocation = this.row instanceof MarkdownTableSeparatorRow && !this.hasRowAfter(this.row) ? RowLocation.LAST : RowLocation.OTHER;
        return rowLocation;
    }

    private final boolean hasRowAfter(PsiElement element2) {
        Object v0;
        block1: {
            Sequence sequence;
            Sequence sequence2 = sequence = PsiTreeUtilKt.siblings$default((PsiElement)element2, (boolean)true, (boolean)false, (int)2, null);
            for (Object e : sequence2) {
                PsiElement it = (PsiElement)e;
                boolean bl = false;
                if (!(it instanceof MarkdownTableRow)) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    public void paint(@NotNull Graphics2D graphics, @NotNull TextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (!this.row.isValid() || this.editor.isDisposed() || Intrinsics.areEqual((Object)this.boundsState, (Object)initialState)) {
            return;
        }
        GraphicsUtil.setupAntialiasing((Graphics)graphics);
        GraphicsUtil.setupRoundedBorderAntialiasing((Graphics)graphics);
        this.paintRow(graphics, this.getRowLocation());
    }

    private final Rectangle calculateBarRect(RowLocation location) {
        Rectangle rectangle;
        switch (VerticalBarPresentation$WhenMappings.$EnumSwitchMapping$0[location.ordinal()]) {
            case 1: {
                rectangle = new Rectangle(0, 0, 6, this.getHeight());
                break;
            }
            case 2: {
                rectangle = new Rectangle(0, 3, 6, this.getHeight() - 3);
                break;
            }
            case 3: {
                rectangle = new Rectangle(0, 0, 6, this.getHeight() - 3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return rectangle;
    }

    private final void paintRow(Graphics2D graphics, RowLocation location) {
        Rectangle rect = this.calculateBarRect(location);
        this.actuallyPaintBar(graphics, rect, this.hover, this.accent);
        graphics.setColor(TableInlayProperties.INSTANCE.getCircleColor());
        switch (VerticalBarPresentation$WhenMappings.$EnumSwitchMapping$1[location.ordinal()]) {
            case 1: {
                this.paintOtherCircles(graphics, rect);
                break;
            }
            case 2: {
                this.paintFirstCircles(graphics, rect);
                break;
            }
            case 3: {
                this.paintLastCircles(graphics, rect);
                break;
            }
        }
    }

    private final void paintOtherCircles(Graphics2D graphics, Rectangle rect) {
        int n = 2;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            GraphicsUtils.INSTANCE.fillHalfOval(graphics, rect.x, rect.y - 3, 6, 6, true);
            GraphicsUtils.INSTANCE.fillHalfOval(graphics, rect.x, rect.y + rect.height - 3, 6, 6, false);
        }
    }

    private final void paintFirstCircles(Graphics2D graphics, Rectangle rect) {
        int n = 2;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            graphics.fillOval(rect.x, rect.y - 3, 6, 6);
            GraphicsUtils.INSTANCE.fillHalfOval(graphics, rect.x, rect.y + rect.height - 3, 6, 6, false);
        }
    }

    private final void paintLastCircles(Graphics2D graphics, Rectangle rect) {
        int n = 2;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            GraphicsUtils.INSTANCE.fillHalfOval(graphics, rect.x, rect.y - 3, 6, 6, true);
            graphics.fillOval(rect.x, rect.y + rect.height - 3, 6, 6);
        }
    }

    private final void actuallyPaintBar(Graphics2D graphics, Rectangle rect, boolean hover, boolean accent) {
        int paintCount = accent ? 2 : 1;
        for (int i = 0; i < paintCount; ++i) {
            int it = i;
            boolean bl = false;
            graphics.setColor(hover ? TableInlayProperties.INSTANCE.getBarHoverColor() : TableInlayProperties.INSTANCE.getBarColor());
            graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        GraphicsUtils.INSTANCE.clearHalfOvalOverEditor(graphics, rect.x, rect.y - 3, 6, 6, true);
        GraphicsUtils.INSTANCE.clearHalfOvalOverEditor(graphics, rect.x, rect.y + rect.height - 3, 6, 6, false);
    }

    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        block1: {
            block0: {
                int n;
                int n2;
                int n3;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
                if (!SwingUtilities.isLeftMouseButton(event) || (n3 = (n2 = event.getClickCount()) % (n = 2)) + (n & ((n3 ^ n) & (n3 | -n3)) >> 31) != 0) break block0;
                this.handleMouseLeftDoubleClick(event, translated);
                break block1;
            }
            if (!SwingUtilities.isLeftMouseButton(event)) break block1;
            this.handleMouseLeftClick(event, translated);
        }
    }

    private final void handleMouseLeftClick(MouseEvent event, Point translated) {
        this.showToolbar();
    }

    private final void handleMouseLeftDoubleClick(MouseEvent event, Point translated) {
        event.consume();
        Project project$iv = this.row.getProject();
        String name$iv = null;
        String groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this){
            final /* synthetic */ VerticalBarPresentation this$0;
            {
                this.this$0 = verticalBarPresentation;
            }

            public final void run() {
                Caret caret;
                boolean bl = false;
                TextRange textRange = VerticalBarPresentation.access$getRow$p(this.this$0).getTextRange();
                CaretModel caretModel = VerticalBarPresentation.access$getEditor$p(this.this$0).getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                Caret $this$with = caret = caretModel.getCurrentCaret();
                boolean bl2 = false;
                TextRange textRange2 = textRange;
                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"textRange");
                $this$with.moveToOffset(textRange2.getStartOffset());
                $this$with.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
            }
        }, name$iv, (Object)groupId$iv);
    }

    @NotNull
    public String toString() {
        return "VerticalBarPresentation";
    }

    private final Point calculateToolbarPosition(int componentHeight) {
        Point point = this.editor.offsetToXY(UtilsKt.getStartOffset((PsiElement)this.row));
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"editor.offsetToXY(row.startOffset)");
        Point position = point;
        JComponent jComponent = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.contentComponent");
        Container container = jComponent.getTopLevelAncestor();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"editor.contentComponent.topLevelAncestor");
        Point editorParent = container.getLocationOnScreen();
        JComponent jComponent2 = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"editor.contentComponent");
        Point editorPosition = jComponent2.getLocationOnScreen();
        position.translate(editorPosition.x - editorParent.x, editorPosition.y - editorParent.y);
        position.translate(0, -this.editor.getLineHeight());
        position.translate(0, -componentHeight);
        Rectangle rect = this.calculateBarRect(this.getRowLocation());
        int bottomPadding = 2;
        position.translate(rect.x, -rect.y - 12 - bottomPadding);
        return position;
    }

    private final void showToolbar() {
        ActionToolbar actionToolbar2 = TableActionKeys.INSTANCE.createActionToolbar(VerticalBarPresentation.Companion.getRowActionGroup(), true, this.editor, VerticalBarPresentation.Companion.createDataProvider(this.row));
        LightweightHint hint = new LightweightHint(actionToolbar2.getComponent());
        hint.setForceShowAsPopup(true);
        JComponent jComponent = hint.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"hint.component");
        Point targetPoint = this.calculateToolbarPosition(jComponent.getPreferredSize().height);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        hintManager.hideAllHints();
        int flags = 1065;
        hintManager.showEditorHint(hint, this.editor, targetPoint, flags, 0, false);
    }

    public VerticalBarPresentation(@NotNull Editor editor2, @NotNull PsiElement row, boolean hover, boolean accent) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        this.editor = editor2;
        this.row = row;
        this.hover = hover;
        this.accent = accent;
        this.boundsState = initialState;
        PsiDocumentManager.getInstance((Project)this.row.getProject()).performForCommittedDocument(this.editor.getDocument(), new Runnable(){

            @Override
            public final void run() {
                ModalityState modalityState$iv = ModalityState.stateForComponent((Component)editor.getContentComponent());
                boolean $i$f$invokeLater = false;
                Application application = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(this){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        boolean bl = false;
                        if (VerticalBarPresentation.access$shouldShowInlay(this.this$0.this)) {
                            BoundsState calculated = new BoundsState(6, VerticalBarPresentation.access$getEditor$p(this.this$0.this).getLineHeight());
                            VerticalBarPresentation.access$setBoundsState$p(this.this$0.this, calculated);
                            this.this$0.this.fireSizeChanged(new Dimension(0, 0), new Dimension(calculated.getWidth(), calculated.getHeight()));
                        }
                    }
                };
                ModalityState modalityState = modalityState$iv;
                if (modalityState == null) {
                    ModalityState modalityState2 = ModalityState.defaultModalityState();
                    modalityState = modalityState2;
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"ModalityState.defaultModalityState()");
                }
                application.invokeLater(runnable, modalityState);
            }
        });
    }

    public /* synthetic */ VerticalBarPresentation(Editor editor2, PsiElement psiElement, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(editor2, psiElement, bl, bl2);
    }

    static {
        Companion = new Companion(null);
        initialState = new BoundsState(0, 0);
    }

    public static final /* synthetic */ PsiElement access$getRow$p(VerticalBarPresentation $this) {
        return $this.row;
    }

    public static final /* synthetic */ boolean access$shouldShowInlay(VerticalBarPresentation $this) {
        return $this.shouldShowInlay();
    }

    public static final /* synthetic */ BoundsState access$getBoundsState$p(VerticalBarPresentation $this) {
        return $this.boundsState;
    }

    public static final /* synthetic */ void access$setBoundsState$p(VerticalBarPresentation $this, BoundsState boundsState) {
        $this.boundsState = boundsState;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation$BoundsState;", "", "width", "", "height", "(II)V", "getHeight", "()I", "getWidth", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.markdown.core"})
    private static final class BoundsState {
        private final int width;
        private final int height;

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public BoundsState(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        @NotNull
        public final BoundsState copy(int width, int height) {
            return new BoundsState(width, height);
        }

        public static /* synthetic */ BoundsState copy$default(BoundsState boundsState, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = boundsState.width;
            }
            if ((n3 & 2) != 0) {
                n2 = boundsState.height;
            }
            return boundsState.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "BoundsState(width=" + this.width + ", height=" + this.height + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.width) * 31 + Integer.hashCode(this.height);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BoundsState)) break block3;
                    BoundsState boundsState = (BoundsState)object;
                    if (this.width != boundsState.width || this.height != boundsState.height) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation$RowLocation;", "", "(Ljava/lang/String;I)V", "FIRST", "LAST", "OTHER", "intellij.markdown.core"})
    private static final class RowLocation
    extends Enum<RowLocation> {
        public static final /* enum */ RowLocation FIRST;
        public static final /* enum */ RowLocation LAST;
        public static final /* enum */ RowLocation OTHER;
        private static final /* synthetic */ RowLocation[] $VALUES;

        static {
            RowLocation[] rowLocationArray = new RowLocation[3];
            RowLocation[] rowLocationArray2 = rowLocationArray;
            rowLocationArray[0] = FIRST = new RowLocation();
            rowLocationArray[1] = LAST = new RowLocation();
            rowLocationArray[2] = OTHER = new RowLocation();
            $VALUES = rowLocationArray;
        }

        public static RowLocation[] values() {
            return (RowLocation[])$VALUES.clone();
        }

        public static RowLocation valueOf(String string) {
            return Enum.valueOf(RowLocation.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation$Companion;", "", "()V", "barWidth", "", "initialState", "Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation$BoundsState;", "rowActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getRowActionGroup", "()Lcom/intellij/openapi/actionSystem/ActionGroup;", "create", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "factory", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "editor", "Lcom/intellij/openapi/editor/Editor;", "row", "Lcom/intellij/psi/PsiElement;", "createDataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "wrapPresentation", "presentation", "intellij.markdown.core"})
    public static final class Companion {
        private final ActionGroup getRowActionGroup() {
            AnAction anAction = ActionManager.getInstance().getAction("Markdown.TableRowActions");
            if (anAction == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            }
            return (ActionGroup)anAction;
        }

        private final DataProvider createDataProvider(PsiElement row) {
            WeakReference<PsiElement> elementReference = new WeakReference<PsiElement>(row);
            return new DataProvider(elementReference){
                final /* synthetic */ WeakReference $elementReference;

                @Nullable
                public final Object getData(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return TableActionKeys.INSTANCE.getELEMENT().is(it) ? this.$elementReference : null;
                }
                {
                    this.$elementReference = weakReference;
                }
            };
        }

        private final InlayPresentation wrapPresentation(PresentationFactory factory, Editor editor2, InlayPresentation presentation) {
            return (InlayPresentation)PresentationFactory.inset$default((PresentationFactory)factory, (InlayPresentation)((InlayPresentation)new PresentationWithCustomCursor(editor2, presentation)), (int)2, (int)2, (int)0, (int)0, (int)24, null);
        }

        @NotNull
        public final InlayPresentation create(@NotNull PresentationFactory factory, @NotNull Editor editor2, @NotNull PsiElement row) {
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            return PresentationFactory.changeOnHover$default((PresentationFactory)factory, (InlayPresentation)this.wrapPresentation(factory, editor2, (InlayPresentation)new VerticalBarPresentation(editor2, row, false, false, 8, null)), (Function0)((Function0)new Function0<InlayPresentation>(factory, editor2, row){
                final /* synthetic */ PresentationFactory $factory;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ PsiElement $row;

                @NotNull
                public final InlayPresentation invoke() {
                    return org.intellij.plugins.markdown.editor.tables.ui.presentation.VerticalBarPresentation$Companion.access$wrapPresentation(VerticalBarPresentation.Companion, this.$factory, this.$editor, (InlayPresentation)new VerticalBarPresentation(this.$editor, this.$row, true, false, 8, null));
                }
                {
                    this.$factory = presentationFactory;
                    this.$editor = editor2;
                    this.$row = psiElement;
                    super(0);
                }
            }), null, (int)4, null);
        }

        private Companion() {
        }

        public static final /* synthetic */ InlayPresentation access$wrapPresentation(Companion $this, PresentationFactory factory, Editor editor2, InlayPresentation presentation) {
            return $this.wrapPresentation(factory, editor2, presentation);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

