/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.properties;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.properties.PropertiesMap;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class CmdPropertyClient
extends BaseSvnClient
implements PropertyClient {
    private static final Logger LOG = Logger.getInstance(CmdPropertyClient.class);

    @Override
    @Nullable
    public PropertyValue getProperty(@NotNull Target target, @NotNull String property, boolean revisionProperty, @Nullable Revision revision) throws SvnBindException {
        PropertyData data;
        block6: {
            if (target == null) {
                CmdPropertyClient.$$$reportNull$$$0(0);
            }
            if (property == null) {
                CmdPropertyClient.$$$reportNull$$$0(1);
            }
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(property);
            if (!revisionProperty) {
                CommandUtil.put(parameters, target);
                CommandUtil.put(parameters, revision);
            } else {
                this.assertFile(target);
                CommandUtil.put(parameters, target, false);
                parameters.add("--revprop");
                CommandUtil.put(parameters, this.resolveRevisionNumber(target.getFile(), revision));
            }
            parameters.add("--xml");
            data = null;
            try {
                CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.propget, parameters, null);
                data = this.parseSingleProperty(target, command);
            }
            catch (SvnBindException e) {
                if (CmdPropertyClient.isPropertyNotFoundError(e)) break block6;
                throw e;
            }
        }
        return data != null ? data.getValue() : null;
    }

    @Override
    public void getProperty(@NotNull Target target, @NotNull String property, @Nullable Revision revision, @Nullable Depth depth, @Nullable PropertyConsumer handler) throws SvnBindException {
        block4: {
            if (target == null) {
                CmdPropertyClient.$$$reportNull$$$0(2);
            }
            if (property == null) {
                CmdPropertyClient.$$$reportNull$$$0(3);
            }
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(property);
            this.fillListParameters(target, revision, depth, parameters, false);
            try {
                CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.propget, parameters, null);
                CmdPropertyClient.parseOutput(target, command, handler);
            }
            catch (SvnBindException e) {
                if (CmdPropertyClient.isPropertyNotFoundError(e)) break block4;
                throw e;
            }
        }
    }

    @Override
    public void list(@NotNull Target target, @Nullable Revision revision, @Nullable Depth depth, @Nullable PropertyConsumer handler) throws SvnBindException {
        if (target == null) {
            CmdPropertyClient.$$$reportNull$$$0(4);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        this.fillListParameters(target, revision, depth, parameters, true);
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.proplist, parameters, null);
        CmdPropertyClient.parseOutput(target, command, handler);
    }

    @Override
    public void setProperty(@NotNull File file, @NotNull String property, @Nullable PropertyValue value, @Nullable Depth depth, boolean force) throws SvnBindException {
        if (file == null) {
            CmdPropertyClient.$$$reportNull$$$0(5);
        }
        if (property == null) {
            CmdPropertyClient.$$$reportNull$$$0(6);
        }
        this.runSetProperty(Target.on(file), property, null, depth, value, force);
    }

    @Override
    public void setProperties(@NotNull File file, @NotNull PropertiesMap properties) throws SvnBindException {
        if (file == null) {
            CmdPropertyClient.$$$reportNull$$$0(7);
        }
        if (properties == null) {
            CmdPropertyClient.$$$reportNull$$$0(8);
        }
        PropertiesMap currentProperties = this.collectPropertiesToDelete(file);
        currentProperties.putAll(properties);
        for (Map.Entry<String, PropertyValue> entry : currentProperties.entrySet()) {
            this.setProperty(file, entry.getKey(), entry.getValue(), Depth.EMPTY, true);
        }
    }

    private static boolean isPropertyNotFoundError(@NotNull SvnBindException e) {
        if (e == null) {
            CmdPropertyClient.$$$reportNull$$$0(9);
        }
        return e.contains(ErrorCode.BASE) && e.contains(ErrorCode.PROPERTY_NOT_FOUND);
    }

    @NotNull
    private PropertiesMap collectPropertiesToDelete(@NotNull File file) throws SvnBindException {
        if (file == null) {
            CmdPropertyClient.$$$reportNull$$$0(10);
        }
        final PropertiesMap result = new PropertiesMap();
        this.list(Target.on(file), null, Depth.EMPTY, new PropertyConsumer(){

            @Override
            public void handleProperty(File path, PropertyData property) {
                result.put(property.getName(), null);
            }
        });
        PropertiesMap propertiesMap = result;
        if (propertiesMap == null) {
            CmdPropertyClient.$$$reportNull$$$0(11);
        }
        return propertiesMap;
    }

    @Override
    public void setRevisionProperty(@NotNull Target target, @NotNull String property, @NotNull Revision revision, @Nullable PropertyValue value, boolean force) throws SvnBindException {
        if (target == null) {
            CmdPropertyClient.$$$reportNull$$$0(12);
        }
        if (property == null) {
            CmdPropertyClient.$$$reportNull$$$0(13);
        }
        if (revision == null) {
            CmdPropertyClient.$$$reportNull$$$0(14);
        }
        this.runSetProperty(target, property, revision, null, value, force);
    }

    private void runSetProperty(@NotNull Target target, @NotNull String property, @Nullable Revision revision, @Nullable Depth depth, @Nullable PropertyValue value, boolean force) throws SvnBindException {
        if (target == null) {
            CmdPropertyClient.$$$reportNull$$$0(15);
        }
        if (property == null) {
            CmdPropertyClient.$$$reportNull$$$0(16);
        }
        boolean isDelete = value == null;
        Command command = this.newCommand(isDelete ? SvnCommandName.propdel : SvnCommandName.propset);
        command.put(property);
        if (revision != null) {
            command.put("--revprop");
            command.put(revision);
        }
        if (!isDelete) {
            command.setPropertyValue(value);
            command.put("--force", force);
        }
        command.put(target);
        command.put(depth);
        this.execute(this.myVcs, target, null, command, null);
    }

    private void fillListParameters(@NotNull Target target, @Nullable Revision revision, @Nullable Depth depth, @NotNull List<String> parameters, boolean verbose) {
        if (target == null) {
            CmdPropertyClient.$$$reportNull$$$0(17);
        }
        if (parameters == null) {
            CmdPropertyClient.$$$reportNull$$$0(18);
        }
        CommandUtil.put(parameters, target);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, depth);
        parameters.add("--xml");
        CommandUtil.put(parameters, verbose, "--verbose");
    }

    @Nullable
    private PropertyData parseSingleProperty(Target target, @NotNull CommandExecutor command) throws SvnBindException {
        if (command == null) {
            CmdPropertyClient.$$$reportNull$$$0(19);
        }
        final PropertyData[] data = new PropertyData[1];
        PropertyConsumer handler = new PropertyConsumer(){

            @Override
            public void handleProperty(File path, PropertyData property) {
                data[0] = property;
            }

            @Override
            public void handleProperty(Url url, PropertyData property) {
                data[0] = property;
            }

            @Override
            public void handleProperty(long revision, PropertyData property) {
                data[0] = property;
            }
        };
        CmdPropertyClient.parseOutput(target, command, handler);
        return data[0];
    }

    private static void parseOutput(Target target, @NotNull CommandExecutor command, PropertyConsumer handler) throws SvnBindException {
        if (command == null) {
            CmdPropertyClient.$$$reportNull$$$0(20);
        }
        try {
            Properties properties = CommandUtil.parse(command.getOutput(), Properties.class);
            if (properties != null) {
                for (PropertiesTarget childInfo : properties.targets) {
                    Target childTarget = SvnUtil.append(target, childInfo.path);
                    for (Property property : childInfo.properties) {
                        CmdPropertyClient.invokeHandler(childTarget, CmdPropertyClient.create(property.name, property.value), handler);
                    }
                }
                if (properties.revisionProperties != null) {
                    for (Property property : properties.revisionProperties.properties) {
                        CmdPropertyClient.invokeHandler(properties.revisionProperties.revisionNumber(), CmdPropertyClient.create(property.name, property.value), handler);
                    }
                }
            }
        }
        catch (JAXBException e) {
            LOG.error("Could not parse properties. Command: " + command.getCommandText() + ", Warning: " + command.getErrorOutput(), new Attachment[]{new Attachment("output.xml", command.getOutput())});
            throw new SvnBindException(e);
        }
    }

    private static void invokeHandler(@NotNull Target target, @Nullable PropertyData data, @Nullable PropertyConsumer handler) throws SvnBindException {
        if (target == null) {
            CmdPropertyClient.$$$reportNull$$$0(21);
        }
        if (handler != null && data != null) {
            if (target.isFile()) {
                handler.handleProperty(target.getFile(), data);
            } else {
                handler.handleProperty(target.getUrl(), data);
            }
        }
    }

    private static void invokeHandler(long revision, @Nullable PropertyData data, @Nullable PropertyConsumer handler) throws SvnBindException {
        if (handler != null && data != null) {
            handler.handleProperty(revision, data);
        }
    }

    @Nullable
    private static PropertyData create(@NotNull String property, @Nullable String value) {
        if (property == null) {
            CmdPropertyClient.$$$reportNull$$$0(22);
        }
        PropertyData result = null;
        if (value != null) {
            result = new PropertyData(property, PropertyValue.create(value.trim()));
        }
        return result;
    }

    private Revision resolveRevisionNumber(@NotNull File path, @Nullable Revision revision) throws SvnBindException {
        long result;
        if (path == null) {
            CmdPropertyClient.$$$reportNull$$$0(23);
        }
        long l = result = revision != null ? revision.getNumber() : -1L;
        if (Revision.BASE.equals(revision)) {
            Info info2 = this.myVcs.getInfo(path, Revision.BASE);
            long l2 = result = info2 != null ? info2.getRevision().getNumber() : -1L;
        }
        if (result == -1L) {
            throw new SvnBindException(SvnBundle.message("error.could.not.determine.revision.number.for.file.and.revision", path, revision));
        }
        return Revision.of(result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 13: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/properties/CmdPropertyClient";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/properties/CmdPropertyClient";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPropertiesToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setProperties";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyNotFoundError";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectPropertiesToDelete";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setRevisionProperty";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runSetProperty";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fillListParameters";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseSingleProperty";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseOutput";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "invokeHandler";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveRevisionNumber";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Property {
        @XmlAttribute(name="name")
        public String name;
        @XmlValue
        public String value;
    }

    public static class RevisionProperties {
        @XmlAttribute(name="rev")
        public String revision;
        @XmlElement(name="property")
        public List<Property> properties = new ArrayList<Property>();

        public long revisionNumber() {
            return Long.parseLong(this.revision);
        }
    }

    public static class PropertiesTarget {
        @XmlAttribute(name="path")
        public String path;
        @XmlElement(name="property")
        public List<Property> properties = new ArrayList<Property>();
    }

    @XmlRootElement(name="properties")
    public static class Properties {
        @XmlElement(name="target")
        public List<PropertiesTarget> targets = new ArrayList<PropertiesTarget>();
        @XmlElement(name="revprops")
        public RevisionProperties revisionProperties;
    }
}

