/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkout;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.ui.VcsCloneComponent;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.welcomeScreen.cloneableProjects.CloneableProjectsService;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.ExclusiveBackgroundVcsAction;
import org.jetbrains.idea.svn.actions.SvnExcludingIgnoredOperation;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.checkin.IdeaCommitHandler;
import org.jetbrains.idea.svn.checkout.CheckoutEventHandler;
import org.jetbrains.idea.svn.checkout.ExportClient;
import org.jetbrains.idea.svn.dialogs.CheckoutDialog;
import org.jetbrains.idea.svn.dialogs.SvnCloneDialogExtension;
import org.jetbrains.idea.svn.dialogs.UpgradeFormatDialog;

public class SvnCheckoutProvider
implements CheckoutProvider {
    public void doCheckout(@NotNull Project project, CheckoutProvider.Listener listener2) {
        if (project == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(0);
        }
        CheckoutDialog dialog = new CheckoutDialog(project, listener2);
        dialog.show();
    }

    @Deprecated(forRemoval=true)
    public static void doCheckout(@NotNull Project project, @NotNull File target, String url, Revision revision, Depth depth, boolean ignoreExternals, @Nullable CheckoutProvider.Listener listener2) {
        if (project == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(1);
        }
        if (target == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(2);
        }
        SvnCheckoutProvider.doCheckout(project, target, SvnUtil.parseUrl(url), revision, depth, ignoreExternals, listener2);
    }

    public static void doCheckout(@NotNull Project project, @NotNull File target, @NotNull Url url, Revision revision, Depth depth, boolean ignoreExternals, @Nullable CheckoutProvider.Listener listener2) {
        WorkingCopyFormat selectedFormat;
        if (project == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(3);
        }
        if (target == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(4);
        }
        if (url == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(5);
        }
        if (!target.exists()) {
            target.mkdirs();
        }
        if ((selectedFormat = SvnCheckoutProvider.promptForWCopyFormat(target, project)) != WorkingCopyFormat.UNKNOWN) {
            SvnCheckoutProvider.checkout(project, target, url, revision, depth, ignoreExternals, listener2, selectedFormat);
        }
    }

    @NotNull
    public static ClientFactory getFactory(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(6);
        }
        ClientFactory clientFactory = vcs.getFactoryFromSettings();
        if (clientFactory == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(7);
        }
        return clientFactory;
    }

    public static void checkout(final Project project, final File target, final @NotNull Url url, final Revision revision, final Depth depth, final boolean ignoreExternals, final CheckoutProvider.Listener listener2, final WorkingCopyFormat selectedFormat) {
        if (url == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(8);
        }
        String projectAbsolutePath = target.getAbsolutePath();
        String projectPath = FileUtilRt.toSystemIndependentName((String)projectAbsolutePath);
        CloneableProjectsService.CloneTask cloneTask = new CloneableProjectsService.CloneTask(){
            final Ref<Boolean> checkoutSuccessful = new Ref();

            @NotNull
            public CloneableProjectsService.CloneTaskInfo taskInfo() {
                return new CloneableProjectsService.CloneTaskInfo(SvnBundle.message("progress.title.check.out", new Object[0]), SvnBundle.message("progress.title.check.out.cancel", new Object[0]), SvnBundle.message("checkout.repository", new Object[0]), SvnBundle.message("checkout.repository.tooltip", new Object[0]), SvnBundle.message("checkout.repository.failed", new Object[0]), SvnBundle.message("checkout.repository.canceled", new Object[0]), SvnBundle.message("checkout.stop.message.title", new Object[0]), SvnBundle.message("checkout.stop.message.description", url.toString()));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public CloneableProjectsService.CloneStatus run(@NotNull ProgressIndicator indicator) {
                CloneableProjectsService.CloneStatus cloneStatus;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                WorkingCopyFormat format = selectedFormat == null ? WorkingCopyFormat.UNKNOWN : selectedFormat;
                SvnVcs vcs = SvnVcs.getInstance(project);
                CheckoutEventHandler handler = new CheckoutEventHandler(vcs, false, ProgressManager.getInstance().getProgressIndicator());
                indicator.setText(SvnBundle.message("progress.text.checking.out", target.getAbsolutePath()));
                try {
                    SvnCheckoutProvider.getFactory(vcs).createCheckoutClient().checkout(Target.on(url), target, revision, depth, ignoreExternals, true, format, handler);
                    this.checkoutSuccessful.set((Object)Boolean.TRUE);
                    CloneableProjectsService.CloneStatus cloneStatus2 = CloneableProjectsService.CloneStatus.SUCCESS;
                    cloneStatus = cloneStatus2;
                }
                catch (VcsException exception) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.checkout", exception.getMessage()), (String)SvnBundle.message("dialog.title.check.out", new Object[0])));
                    CloneableProjectsService.CloneStatus cloneStatus3 = CloneableProjectsService.CloneStatus.FAILURE;
                    CloneableProjectsService.CloneStatus cloneStatus4 = cloneStatus3;
                    if (cloneStatus4 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return cloneStatus4;
                }
                finally {
                    VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(target);
                    if (vf != null) {
                        vf.refresh(true, true, () -> ApplicationManager.getApplication().invokeLater(() -> this.notifyListener()));
                    } else {
                        this.notifyListener();
                    }
                }
                if (cloneStatus == null) {
                    1.$$$reportNull$$$0(1);
                }
                return cloneStatus;
            }

            private void notifyListener() {
                SvnCheckoutProvider.notifyRootManagerIfUnderProject(project, target);
                if (listener2 != null) {
                    if (!this.checkoutSuccessful.isNull()) {
                        listener2.directoryCheckedOut(target, SvnVcs.getKey());
                    }
                    listener2.checkoutCompleted();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "run";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        CloneableProjectsService.getInstance().runCloneTask(projectPath, cloneTask);
    }

    private static void notifyRootManagerIfUnderProject(@NotNull Project project, @NotNull File directory) {
        VirtualFile[] files;
        if (project == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(9);
        }
        if (directory == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(10);
        }
        if (project.isDefault()) {
            return;
        }
        for (VirtualFile file : files = SvnVcs.getInstance(project).getSvnFileUrlMapping().getNotFilteredRoots()) {
            if (!FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)file), (File)directory, (boolean)false)) continue;
            ProjectLevelVcsManagerEx.getInstanceEx((Project)project).fireDirectoryMappingsChanged();
            return;
        }
    }

    @RequiresEdt
    @NotNull
    public static WorkingCopyFormat promptForWCopyFormat(@NotNull File target, @NotNull Project project) {
        if (target == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(11);
        }
        if (project == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(12);
        }
        WorkingCopyFormat workingCopyFormat = new CheckoutFormatFromUserProvider(project, target).prompt();
        if (workingCopyFormat == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(13);
        }
        return workingCopyFormat;
    }

    public static void doExport(Project project, File target, Url url, Depth depth, boolean ignoreExternals, boolean force, String eolStyle) {
        try {
            VcsException[] exception = new VcsException[1];
            SvnVcs vcs = SvnVcs.getInstance(project);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                CheckoutEventHandler handler = new CheckoutEventHandler(vcs, true, progressIndicator);
                try {
                    progressIndicator.setText(SvnBundle.message("progress.text.export", target.getAbsolutePath()));
                    Target from = Target.on(url);
                    ExportClient client = vcs.getFactoryFromSettings().createExportClient();
                    client.export(from, target, Revision.HEAD, depth, eolStyle, force, ignoreExternals, handler);
                }
                catch (VcsException e) {
                    exception[0] = e;
                }
            }, SvnBundle.message("message.title.export", new Object[0]), true, project);
            if (exception[0] != null) {
                throw exception[0];
            }
        }
        catch (VcsException e1) {
            Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.export", e1.getMessage()), (String)SvnBundle.message("message.title.export", new Object[0]));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void doImport(Project project, File target, Url url, Depth depth, boolean includeIgnored, String message) {
        @Nls Ref errorMessage = new Ref();
        SvnVcs vcs = SvnVcs.getInstance(project);
        String targetPath = target.getAbsolutePath();
        ExclusiveBackgroundVcsAction.run(project, () -> ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            FileIndexFacade facade = (FileIndexFacade)project.getService(FileIndexFacade.class);
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            try {
                progressIndicator.setText(SvnBundle.message("progress.text.import", targetPath));
                VirtualFile targetVf = SvnUtil.getVirtualFile(targetPath);
                if (targetVf == null) {
                    errorMessage.set((Object)SvnBundle.message("error.can.not.find.file", targetPath));
                } else {
                    boolean isInContent = (Boolean)ReadAction.compute(() -> facade.isInContent(targetVf));
                    IdeaCommitHandler handler = new IdeaCommitHandler(progressIndicator);
                    boolean useFileFilter = !project.isDefault() && isInContent;
                    MyFilter filter = useFileFilter ? new MyFilter(new SvnExcludingIgnoredOperation.Filter(project)) : null;
                    long revision = vcs.getFactoryFromSettings().createImportClient().doImport(target, url, depth, message, includeIgnored, handler, filter);
                    if (revision > 0L) {
                        StatusBar.Info.set((String)SvnBundle.message("status.text.committed.revision", revision), (Project)project);
                    }
                }
            }
            catch (VcsException e) {
                errorMessage.set((Object)e.getMessage());
            }
        }, SvnBundle.message("message.title.import", new Object[0]), true, project));
        if (!errorMessage.isNull()) {
            Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.import", errorMessage.get()), (String)SvnBundle.message("message.title.import", new Object[0]));
        }
    }

    public String getVcsName() {
        return "_Subversion";
    }

    @NotNull
    public VcsCloneComponent buildVcsCloneComponent(@NotNull Project project, @NotNull ModalityState modalityState, @NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        if (project == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(14);
        }
        if (modalityState == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(15);
        }
        if (dialogStateListener == null) {
            SvnCheckoutProvider.$$$reportNull$$$0(16);
        }
        return new SvnCloneDialogExtension(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogStateListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "promptForWCopyFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doCheckout";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFactory";
                break;
            }
            case 7: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkout";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "notifyRootManagerIfUnderProject";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "promptForWCopyFormat";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildVcsCloneComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CheckoutFormatFromUserProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        private final SvnVcs myVcs;
        @NotNull
        private final File myPath;
        @NotNull
        private final AtomicReference<String> error;

        public CheckoutFormatFromUserProvider(@NotNull Project project, @NotNull File path) {
            if (project == null) {
                CheckoutFormatFromUserProvider.$$$reportNull$$$0(0);
            }
            if (path == null) {
                CheckoutFormatFromUserProvider.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myVcs = SvnVcs.getInstance(project);
            this.myPath = path;
            this.error = new AtomicReference();
        }

        @RequiresEdt
        public WorkingCopyFormat prompt() {
            assert (!ApplicationManager.getApplication().isUnitTestMode());
            WorkingCopyFormat result = this.displayUpgradeDialog();
            ((Runnable)BackgroundTaskUtil.syncPublisher(SvnVcs.WC_CONVERTED)).run();
            return result;
        }

        @NotNull
        private WorkingCopyFormat displayUpgradeDialog() {
            UpgradeFormatDialog dialog = new UpgradeFormatDialog(this.myProject, this.myPath, false);
            ModalityState dialogState = ModalityState.any();
            dialog.startLoading();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                List<WorkingCopyFormat> formats = this.loadSupportedFormats();
                ApplicationManager.getApplication().invokeLater(() -> {
                    String errorMessage = this.error.get();
                    if (errorMessage != null) {
                        dialog.doCancelAction();
                        Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.load.supported.formats", errorMessage), (String)SvnBundle.message("dialog.title.check.out", new Object[0]));
                    } else {
                        dialog.setSupported(formats);
                        dialog.setData((WorkingCopyFormat)((Object)((Object)((Object)ContainerUtil.getFirstItem((Collection)formats, (Object)((Object)WorkingCopyFormat.UNKNOWN))))));
                        dialog.stopLoading();
                    }
                }, dialogState);
            });
            WorkingCopyFormat workingCopyFormat = dialog.showAndGet() ? dialog.getUpgradeMode() : WorkingCopyFormat.UNKNOWN;
            if (workingCopyFormat == null) {
                CheckoutFormatFromUserProvider.$$$reportNull$$$0(2);
            }
            return workingCopyFormat;
        }

        @NotNull
        private List<WorkingCopyFormat> loadSupportedFormats() {
            ArrayList<WorkingCopyFormat> result = new ArrayList<WorkingCopyFormat>();
            try {
                result.addAll(this.myVcs.getFactoryFromSettings().createCheckoutClient().getSupportedFormats());
            }
            catch (VcsException e) {
                this.error.set(e.getMessage());
            }
            ArrayList<WorkingCopyFormat> arrayList = result;
            if (arrayList == null) {
                CheckoutFormatFromUserProvider.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider$CheckoutFormatFromUserProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider$CheckoutFormatFromUserProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "displayUpgradeDialog";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadSupportedFormats";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyFilter
    implements Predicate<File> {
        @NotNull
        private final LocalFileSystem myLfs;
        @NotNull
        private final SvnExcludingIgnoredOperation.Filter myFilter;

        private MyFilter(@NotNull SvnExcludingIgnoredOperation.Filter filter) {
            if (filter == null) {
                MyFilter.$$$reportNull$$$0(0);
            }
            this.myLfs = LocalFileSystem.getInstance();
            this.myFilter = filter;
        }

        @Override
        public boolean test(@NotNull File file) {
            VirtualFile vf;
            if (file == null) {
                MyFilter.$$$reportNull$$$0(1);
            }
            return (vf = this.myLfs.findFileByIoFile(file)) != null && this.myFilter.accept(vf);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/svn/checkout/SvnCheckoutProvider$MyFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "test";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

