/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSpecificCaseRule;
import org.languagetool.rules.Example;

public class EnglishSpecificCaseRule
extends AbstractSpecificCaseRule {
    @Override
    public String getPhrasesPath() {
        return "/en/specific_case.txt";
    }

    @Override
    public String getInitialCapitalMessage() {
        return "If the term is a proper noun, use initial capitals.";
    }

    @Override
    public String getOtherCapitalizationMessage() {
        return "If the term is a proper noun, use the suggested capitalization.";
    }

    @Override
    public String getShortMessage() {
        return "Proper noun";
    }

    public EnglishSpecificCaseRule(ResourceBundle messages) {
        super(messages);
        this.addExamplePair(Example.wrong("I really like <marker>Harry potter</marker>."), Example.fixed("I really like <marker>Harry Potter</marker>."));
    }

    @Override
    public final String getId() {
        return "EN_SPECIFIC_CASE";
    }

    @Override
    public String getDescription() {
        return "Checks upper/lower case spelling of some proper nouns";
    }
}

