/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import gnu.trove.THashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.languagetool.JLanguageTool;

public class WordCoherencyDataLoader {
    public Map<String, Set<String>> loadWords(String path) {
        InputStream stream = JLanguageTool.getDataBroker().getFromRulesDirAsStream(path);
        THashMap map2 = new THashMap();
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
             BufferedReader br2 = new BufferedReader(reader);){
            String line;
            while ((line = br2.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                String[] parts = line.split(";");
                if (parts.length != 2) {
                    throw new IOException("Format error in file " + path + ", line: " + line);
                }
                if (map2.containsKey(parts[0])) {
                    ((Set)map2.get(parts[0])).add(parts[1]);
                } else {
                    map2.put(parts[0], Stream.of(parts[1]).collect(Collectors.toSet()));
                }
                if (map2.containsKey(parts[1])) {
                    ((Set)map2.get(parts[1])).add(parts[0]);
                    continue;
                }
                map2.put(parts[1], Stream.of(parts[0]).collect(Collectors.toSet()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load coherency data from " + path, e);
        }
        return Collections.unmodifiableMap(map2);
    }
}

