/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class DoublePunctuationRule
extends Rule {
    public DoublePunctuationRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.PUNCTUATION.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Typographical);
    }

    @Override
    public String getId() {
        return "DOUBLE_PUNCTUATION";
    }

    @Override
    public final String getDescription() {
        return this.messages.getString("desc_double_punct");
    }

    public String getCommaCharacter() {
        return ",";
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        int startPos = 0;
        int dotCount = 0;
        int commaCount = 0;
        for (int i2 = 1; i2 < tokens.length; ++i2) {
            RuleMatch ruleMatch;
            int fromPos;
            String token = tokens[i2].getToken();
            String nextToken = null;
            String prevToken = null;
            if (i2 < tokens.length - 1) {
                nextToken = tokens[i2 + 1].getToken();
            }
            if (i2 > 1) {
                prevToken = tokens[i2 - 2].getToken();
            }
            if (".".equals(token)) {
                ++dotCount;
                commaCount = 0;
                startPos = tokens[i2].getStartPos();
            } else if (this.getCommaCharacter().equals(token)) {
                ++commaCount;
                dotCount = 0;
                startPos = tokens[i2].getStartPos();
            }
            if (!(dotCount != 2 || ".".equals(nextToken) || "?".equals(prevToken) || "!".equals(prevToken))) {
                fromPos = Math.max(0, startPos - 1);
                ruleMatch = new RuleMatch(this, sentence, fromPos, startPos + 1, this.getDotMessage(), this.messages.getString("double_dots_short"));
                ruleMatch.addSuggestedReplacement(".");
                ruleMatch.addSuggestedReplacement("\u2026");
                ruleMatches.add(ruleMatch);
                dotCount = 0;
            } else if (commaCount == 2 && !this.getCommaCharacter().equals(nextToken)) {
                fromPos = Math.max(0, startPos - 1);
                ruleMatch = new RuleMatch(this, sentence, fromPos, startPos + 1, this.getCommaMessage(), this.messages.getString("double_commas_short"));
                ruleMatch.setSuggestedReplacement(this.getCommaCharacter());
                ruleMatches.add(ruleMatch);
                commaCount = 0;
            }
            if (".".equals(token) || this.getCommaCharacter().equals(token)) continue;
            dotCount = 0;
            commaCount = 0;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    protected String getDotMessage() {
        return this.messages.getString("two_dots");
    }

    protected String getCommaMessage() {
        return this.messages.getString("two_commas");
    }
}

