/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.gdpr.ConsentConfigurable;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public final class OpenEventLogFileAction
extends DumbAwareAction {
    private final String myRecorderId;

    public OpenEventLogFileAction(String recorderId) {
        super(StatisticsBundle.message((String)"stats.open.0.event.log", (Object[])new Object[]{recorderId}), ActionsBundle.message((String)"group.OpenEventLogFileAction.description", (Object[])new Object[0]), AllIcons.FileTypes.Text);
        this.myRecorderId = recorderId;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OpenEventLogFileAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenEventLogFileAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile logVFile;
        Project project;
        if (e == null) {
            OpenEventLogFileAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        EventLogFile logFile = StatisticsEventLogProviderUtil.getEventLogProvider((String)this.myRecorderId).getActiveLogFile();
        VirtualFile virtualFile = logVFile = logFile != null ? LocalFileSystem.getInstance().refreshAndFindFileByIoFile(logFile.getFile()) : null;
        if (logVFile == null) {
            OpenEventLogFileAction.showNotification(project, StatisticsBundle.message((String)"stats.there.is.no.active.event.log", (Object[])new Object[0]));
            return;
        }
        FileEditorManager.getInstance((Project)project).openFile(logVFile, true);
    }

    private static void showNotification(@NotNull Project project, @NotNull String message) {
        if (project == null) {
            OpenEventLogFileAction.$$$reportNull$$$0(3);
        }
        if (message == null) {
            OpenEventLogFileAction.$$$reportNull$$$0(4);
        }
        String title = StatisticsBundle.message((String)"stats.feature.usage.statistics", (Object[])new Object[0]);
        new Notification("FeatureUsageStatistics", title, message, NotificationType.WARNING).addAction((AnAction)NotificationAction.createSimple((String)StatisticsBundle.message((String)"stats.enable.data.sharing", (Object[])new Object[0]), () -> new SingleConfigurableEditor(project, (Configurable)new ConsentConfigurable()).show())).notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/devkit/actions/OpenEventLogFileAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/devkit/actions/OpenEventLogFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

