/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.emojipicker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class EmojiSearchIndex
implements Serializable {
    @NonNls
    private final String myChars;
    private final int[] myData;
    private final int myRootNodeOffset;
    private final int myTotalEmojiIndices;

    private EmojiSearchIndex(@NonNls String chars, int[] data, int rootNodeOffset, int totalEmojiIndices) {
        this.myChars = chars;
        this.myData = data;
        this.myRootNodeOffset = rootNodeOffset;
        this.myTotalEmojiIndices = totalEmojiIndices;
    }

    private int findNodeForPrefix(@NonNls String key, int prefixOffset, int nodeOffset) {
        if (prefixOffset == key.length()) {
            return nodeOffset;
        }
        int children = this.myData[nodeOffset + 2];
        for (int c = 0; c < children; ++c) {
            int i;
            int child = this.myData[nodeOffset + 3 + c];
            int childCharsFrom = this.myData[child];
            int childCharsTo = this.myData[child + 1];
            int limit = Math.min(key.length() - prefixOffset, childCharsTo - childCharsFrom);
            for (i = 0; i < limit && key.charAt(prefixOffset + i) == this.myChars.charAt(childCharsFrom + i); ++i) {
            }
            if (i == childCharsTo - childCharsFrom) {
                return this.findNodeForPrefix(key, prefixOffset + i, child);
            }
            if (i == key.length() - prefixOffset) {
                return child;
            }
            if (i <= 0) continue;
            return -1;
        }
        return -1;
    }

    private void collectIdsFromSubtree(boolean[] idMap, int nodeOffset) {
        int i;
        int children = this.myData[nodeOffset + 2];
        int ids = this.myData[nodeOffset + 3 + children];
        for (i = 0; i < ids; ++i) {
            int id = this.myData[nodeOffset + 4 + children + i];
            idMap[id] = true;
        }
        for (i = 0; i < children; ++i) {
            int child = this.myData[nodeOffset + 3 + i];
            this.collectIdsFromSubtree(idMap, child);
        }
    }

    public boolean lookupIds(boolean[] idMap, @NonNls String prefix) {
        if (idMap.length < this.myTotalEmojiIndices) {
            throw new IllegalArgumentException("Output array is too small: " + idMap.length + ", but there are " + this.myTotalEmojiIndices + "emoji indices");
        }
        int node = this.findNodeForPrefix(prefix, 0, this.myRootNodeOffset);
        if (node == -1) {
            return false;
        }
        Arrays.fill(idMap, false);
        this.collectIdsFromSubtree(idMap, node);
        return true;
    }

    public int getTotalEmojiIndices() {
        return this.myTotalEmojiIndices;
    }

    public static class PrefixTree {
        @NonNls
        private String myPrefix;
        private final List<PrefixTree> myChildren = new ArrayList<PrefixTree>();
        private final List<Integer> myValues = new ArrayList<Integer>();

        private PrefixTree(@NonNls String prefix) {
            this.myPrefix = prefix;
        }

        public PrefixTree() {
            this("");
        }

        public void add(@NonNls String key, int value) {
            if (key.isEmpty()) {
                this.myValues.add(value);
                return;
            }
            for (int c = 0; c < this.myChildren.size(); ++c) {
                int i;
                PrefixTree child = this.myChildren.get(c);
                int limit = Math.min(key.length(), child.myPrefix.length());
                for (i = 0; i < limit && key.charAt(i) == child.myPrefix.charAt(i); ++i) {
                }
                if (i == child.myPrefix.length()) {
                    child.add(key.substring(limit), value);
                    return;
                }
                if (i <= 0) continue;
                PrefixTree firstPart = new PrefixTree(key.substring(0, i));
                child.myPrefix = child.myPrefix.substring(i);
                firstPart.myChildren.add(child);
                this.myChildren.set(c, firstPart);
                firstPart.add(key.substring(i), value);
                return;
            }
            PrefixTree newSubtree = new PrefixTree(key);
            newSubtree.myValues.add(value);
            this.myChildren.add(newSubtree);
        }

        public EmojiSearchIndex buildIndex() {
            BuildData data = new BuildData();
            data.myChars = new StringBuffer(2000000);
            data.myData = new int[4000000];
            int first = this.collectToIndex(data);
            return new EmojiSearchIndex(data.myChars.toString(), Arrays.copyOf(data.myData, data.myDataPointer), first, data.myMaxEmojiId + 1);
        }

        private int collectToIndex(BuildData data) {
            int[] childrenLinks = new int[this.myChildren.size()];
            for (int i = 0; i < childrenLinks.length; ++i) {
                childrenLinks[i] = this.myChildren.get(i).collectToIndex(data);
            }
            int charsFrom = data.myChars.length();
            data.myChars.append(this.myPrefix);
            int index = data.myDataPointer;
            data.ensureDataCapacity(4 + childrenLinks.length + this.myValues.size());
            data.write(charsFrom).write(data.myChars.length()).write(childrenLinks.length);
            System.arraycopy(childrenLinks, 0, data.myData, data.myDataPointer, childrenLinks.length);
            data.myDataPointer += childrenLinks.length;
            data.write(this.myValues.size());
            for (int i : this.myValues) {
                if (i > data.myMaxEmojiId) {
                    data.myMaxEmojiId = i;
                }
                data.write(i);
            }
            return index;
        }

        private static class BuildData {
            StringBuffer myChars;
            int[] myData;
            int myDataPointer;
            int myMaxEmojiId = -1;

            private BuildData() {
            }

            private void ensureDataCapacity(int remaining) {
                if (this.myDataPointer + remaining > this.myData.length) {
                    this.myData = Arrays.copyOf(this.myData, this.myData.length * 2);
                }
            }

            private BuildData write(int i) {
                this.myData[this.myDataPointer++] = i;
                return this;
            }
        }
    }
}

