# Notes on file extensions

The Proxmark3 client uses a wide range of files. Here is a brief recap to get you up to speed.

| extension | description|
|---|---|
| .exe | windows executable |
| .bin | binary file,  can be firmware or memory dump of a tag |
| .eml | text file, with memory dump of a tag |
| .mfd | binary file, MIFARE file dump, name comes from NFC-Tools. Usually created with Mifare Classic Tool app (MCT) or NFC-Tools,  contains memory dump of tag. Very similar to .bin file |
| .json | JSON file, usually settings file or it can also be a memory dump of a tag |
| .dic | dictionary file. textual, with keys/passwords one line / key |
| .elf | binary proxmark3 device firmware file. |
| .cmd | text file, contains proxmark3 client commands used to call client with -s |
| .lua | text file, contains lua script to be run inside client.  or called with -l |
| .pm3 | text file, with numbers ranging 0-255 or -127 - 128.  Contains trace signal data for low frequency tags (data load / data save) |
| .wav | binary file,  PCM8 with samplerate 125000,  one channel. (data save)
| .trace | binary file,  contains trace log data usually from high frequency tags.  (trace load) |
| .log | text file, our log file, contains the output from almost all commands you run inside Proxmark3 client |
| .history | text file, our command log file, contains the commands you ran inside Proxmark3 client |
