/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.api.ThemeStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.USymbols;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.ClusterDecoration;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.FrontierCalculator;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.IShapePseudo;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svek.RoundedContainer;
import net.sourceforge.plantuml.svek.ShapePseudoImpl;
import net.sourceforge.plantuml.svek.SvekLine;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGroupType;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColors;
import net.sourceforge.plantuml.utils.UniqueSequence;

public class Cluster
implements Moveable {
    private static final String RANK_SAME = "same";
    private static final String RANK_SOURCE = "source";
    private static final String RANK_SINK = "sink";
    private static final String ID_EE = "ee";
    public static final String CENTER_ID = "za";
    private final Cluster parentCluster;
    private final IGroup group;
    private final List<SvekNode> nodes = new ArrayList<SvekNode>();
    private final List<Cluster> children = new ArrayList<Cluster>();
    private final int color;
    private final int colorTitle;
    private final ISkinParam skinParam;
    private int titleAndAttributeWidth;
    private int titleAndAttributeHeight;
    private TextBlock ztitle;
    private TextBlock zstereo;
    private double xTitle;
    private double yTitle;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        this.xTitle += deltaX;
        this.minX += deltaX;
        this.maxX += deltaX;
        this.yTitle += deltaY;
        this.minY += deltaY;
        this.maxY += deltaY;
    }

    private Set<EntityPosition> entityPositionsExceptNormal() {
        EnumSet<EntityPosition> result = EnumSet.noneOf(EntityPosition.class);
        for (SvekNode sh : this.nodes) {
            if (sh.getEntityPosition() == EntityPosition.NORMAL) continue;
            result.add(sh.getEntityPosition());
        }
        return Collections.unmodifiableSet(result);
    }

    public Cluster(ColorSequence colorSequence, ISkinParam skinParam, IGroup root) {
        this(null, colorSequence, skinParam, root);
    }

    private Cluster(Cluster parentCluster, ColorSequence colorSequence, ISkinParam skinParam, IGroup group) {
        if (group == null) {
            throw new IllegalStateException();
        }
        this.parentCluster = parentCluster;
        this.group = group;
        this.color = colorSequence.getValue();
        this.colorTitle = colorSequence.getValue();
        this.skinParam = group.getColors().mute(skinParam);
    }

    public String toString() {
        return super.toString() + " " + this.group;
    }

    public final Cluster getParentCluster() {
        return this.parentCluster;
    }

    public void addNode(SvekNode node) {
        this.nodes.add(Objects.requireNonNull(node));
        node.setCluster(this);
    }

    public final List<SvekNode> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    private List<SvekNode> getNodesOrderedTop(Collection<SvekLine> lines) {
        ArrayList<SvekNode> firsts = new ArrayList<SvekNode>();
        HashSet<String> tops = new HashSet<String>();
        HashMap<String, SvekNode> shs = new HashMap<String, SvekNode>();
        for (SvekNode node : this.nodes) {
            shs.put(node.getUid(), node);
            if (!node.isTop() || node.getEntityPosition() != EntityPosition.NORMAL) continue;
            firsts.add(node);
            tops.add(node.getUid());
        }
        for (SvekLine l : lines) {
            SvekNode sh;
            if (tops.contains(l.getStartUidPrefix()) && (sh = (SvekNode)shs.get(l.getEndUidPrefix())) != null && sh.getEntityPosition() == EntityPosition.NORMAL) {
                firsts.add(0, sh);
            }
            if (!l.isInverted() || (sh = (SvekNode)shs.get(l.getStartUidPrefix())) == null || sh.getEntityPosition() != EntityPosition.NORMAL) continue;
            firsts.add(0, sh);
        }
        return firsts;
    }

    private List<SvekNode> getNodesOrderedWithoutTop(Collection<SvekLine> lines) {
        ArrayList<SvekNode> all = new ArrayList<SvekNode>(this.nodes);
        HashSet<String> tops = new HashSet<String>();
        HashMap<String, SvekNode> shs = new HashMap<String, SvekNode>();
        Iterator it = all.iterator();
        while (it.hasNext()) {
            SvekNode sh = (SvekNode)it.next();
            if (sh.getEntityPosition() != EntityPosition.NORMAL) {
                it.remove();
                continue;
            }
            shs.put(sh.getUid(), sh);
            if (!sh.isTop()) continue;
            tops.add(sh.getUid());
            it.remove();
        }
        for (SvekLine l : lines) {
            SvekNode sh;
            if (tops.contains(l.getStartUidPrefix()) && (sh = (SvekNode)shs.get(l.getEndUidPrefix())) != null) {
                all.remove(sh);
            }
            if (!l.isInverted() || (sh = (SvekNode)shs.get(l.getStartUidPrefix())) == null) continue;
            all.remove(sh);
        }
        return all;
    }

    public final List<Cluster> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Cluster createChild(int titleAndAttributeWidth, int titleAndAttributeHeight, TextBlock title, TextBlock stereo, ColorSequence colorSequence, ISkinParam skinParam, IGroup g) {
        Cluster child = new Cluster(this, colorSequence, skinParam, g);
        child.titleAndAttributeWidth = titleAndAttributeWidth;
        child.titleAndAttributeHeight = titleAndAttributeHeight;
        child.ztitle = title;
        child.zstereo = stereo;
        this.children.add(child);
        return child;
    }

    public final Set<IGroup> getGroups() {
        return Collections.singleton(this.group);
    }

    public final int getTitleAndAttributeWidth() {
        return this.titleAndAttributeWidth;
    }

    public final int getTitleAndAttributeHeight() {
        return this.titleAndAttributeHeight;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getMinX() {
        return this.minX;
    }

    public ClusterPosition getClusterPosition() {
        return new ClusterPosition(this.minX, this.minY, this.maxX, this.maxY);
    }

    public void setTitlePosition(double x, double y) {
        this.xTitle = x;
        this.yTitle = y;
    }

    public static StyleSignatureBasic getDefaultStyleDefinition(SName diagramStyleName, USymbol symbol) {
        if (diagramStyleName == SName.stateDiagram) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state, SName.group);
        }
        if (symbol == null) {
            return StyleSignatureBasic.of(SName.root, SName.element, diagramStyleName, SName.group);
        }
        return StyleSignatureBasic.of(SName.root, SName.element, diagramStyleName, SName.group, symbol.getSName());
    }

    public static StyleSignature getDefaultStyleDefinitionStateGroup(Stereotype stereotype) {
        if (stereotype == null) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state, SName.group);
        }
        return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state, SName.group).withTOBECHANGED(stereotype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawU(UGraphic ug, UmlDiagramType umlDiagramType, ISkinParam skinParam2unused) {
        if (this.group.isHidden()) {
            return;
        }
        String fullName = this.group.getCodeGetName();
        if (!fullName.startsWith("##")) {
            ug.draw(new UComment("cluster " + fullName));
        }
        USymbol uSymbol = this.group.getUSymbol() == null ? USymbols.PACKAGE : this.group.getUSymbol();
        Style style = Cluster.getDefaultStyleDefinition(umlDiagramType.getStyleName(), uSymbol).withTOBECHANGED(this.group.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        double shadowing = style.value(PName.Shadowing).asDouble();
        HColor borderColor = this.group.getColors().getColor(ColorType.LINE) != null ? this.group.getColors().getColor(ColorType.LINE) : style.value(PName.LineColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        double rounded = style.value(PName.RoundCorner).asDouble();
        double diagonalCorner = style.value(PName.DiagonalCorner).asDouble();
        ug.startGroup(Collections.singletonMap(UGroupType.ID, "cluster_" + fullName));
        Url url = this.group.getUrl99();
        if (url != null) {
            ug.startUrl(url);
        }
        try {
            boolean isState;
            if (this.entityPositionsExceptNormal().size() > 0) {
                this.manageEntryExitPoint(ug.getStringBounder());
            }
            if (this.skinParam.useSwimlanes(umlDiagramType)) {
                this.drawSwinLinesState(ug, borderColor);
                return;
            }
            boolean bl = isState = umlDiagramType == UmlDiagramType.STATE;
            if (isState && this.group.getUSymbol() == null) {
                this.drawUState(ug, umlDiagramType, rounded, shadowing);
                return;
            }
            PackageStyle packageStyle = this.group.getPackageStyle();
            if (packageStyle == null) {
                packageStyle = this.skinParam.packageStyle();
            }
            UStroke stroke = Cluster.getStrokeInternal(this.group, style);
            HColor backColor = this.getBackColor(umlDiagramType, style);
            backColor = Cluster.getBackColor(backColor, this.group.getStereotype(), umlDiagramType.getStyleName(), this.group.getUSymbol(), this.skinParam.getCurrentStyleBuilder(), this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
            if (this.ztitle != null || this.zstereo != null) {
                ClusterDecoration decoration = new ClusterDecoration(packageStyle, this.group.getUSymbol(), this.ztitle, this.zstereo, this.minX, this.minY, this.maxX, this.maxY, stroke);
                decoration.drawU(ug, backColor, borderColor, shadowing, rounded, this.skinParam.getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null), this.skinParam.getStereotypeAlignment(), diagonalCorner);
                return;
            }
            URectangle rect = new URectangle(this.maxX - this.minX, this.maxY - this.minY);
            rect.setDeltaShadow(shadowing);
            ug = ug.apply(backColor.bg()).apply(borderColor);
            ug.apply(new UStroke(2.0)).apply(new UTranslate(this.minX, this.minY)).draw(rect);
        }
        finally {
            if (url != null) {
                ug.closeUrl();
            }
            ug.closeGroup();
        }
    }

    public static UStroke getStrokeInternal(IGroup group, Style style) {
        Colors colors = group.getColors();
        if (colors.getSpecificLineStroke() != null) {
            return colors.getSpecificLineStroke();
        }
        return style.getStroke();
    }

    public void manageEntryExitPoint(StringBounder stringBounder) {
        ArrayList<ClusterPosition> insides = new ArrayList<ClusterPosition>();
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (SvekNode sh : this.nodes) {
            if (sh.getEntityPosition() == EntityPosition.NORMAL) {
                insides.add(sh.getClusterPosition());
                continue;
            }
            points.add(sh.getClusterPosition().getPointCenter());
        }
        for (Cluster in : this.children) {
            insides.add(in.getClusterPosition());
        }
        FrontierCalculator frontierCalculator = new FrontierCalculator(this.getClusterPosition(), insides, points);
        if (this.titleAndAttributeHeight > 0 && this.titleAndAttributeWidth > 0) {
            frontierCalculator.ensureMinWidth(this.titleAndAttributeWidth + 10);
        }
        ClusterPosition forced = frontierCalculator.getSuggestedPosition();
        this.xTitle += (forced.getMinX() - this.minX + (forced.getMaxX() - this.maxX)) / 2.0;
        this.minX = forced.getMinX();
        this.minY = forced.getMinY();
        this.maxX = forced.getMaxX();
        this.maxY = forced.getMaxY();
        this.yTitle = this.minY + 5.0;
        double widthTitle = this.ztitle.calculateDimension(stringBounder).getWidth();
        this.xTitle = this.minX + (this.maxX - this.minX - widthTitle) / 2.0;
    }

    private void drawSwinLinesState(UGraphic ug, HColor borderColor) {
        if (this.ztitle != null) {
            this.ztitle.drawU(ug.apply(UTranslate.dx(this.xTitle)));
        }
        ULine line = ULine.vline(this.maxY - this.minY);
        ug = ug.apply(borderColor);
        ug.apply(UTranslate.dx(this.minX)).draw(line);
        ug.apply(UTranslate.dx(this.maxX)).draw(line);
    }

    private Style getStyleStateHeader() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state, SName.header).withTOBECHANGED(this.group.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private Style getStyleState() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state).withTOBECHANGED(this.group.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private Style getStyleStateBody() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.stateBody).withTOBECHANGED(this.group.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private void drawUState(UGraphic ug, UmlDiagramType umlDiagramType, double rounded, double shadowing) {
        Stereotype stereotype;
        boolean withSymbol;
        HColor backColor;
        Dimension2DDouble total = new Dimension2DDouble(this.maxX - this.minX, this.maxY - this.minY);
        double suppY = this.ztitle == null ? 0.0 : this.ztitle.calculateDimension(ug.getStringBounder()).getHeight() + 5.0 + 5.0;
        Style styleGroup = Cluster.getDefaultStyleDefinitionStateGroup(this.group.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        HColor borderColor = this.group.getColors().getColor(ColorType.LINE);
        if (borderColor == null) {
            borderColor = this.getStyleState().value(PName.LineColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        }
        if ((backColor = this.group.getColors().getColor(ColorType.BACK)) == null) {
            backColor = this.getStyleState().value(PName.BackGroundColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        }
        HColor imgBackcolor = this.getStyleStateBody().value(PName.BackGroundColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        TextBlock attribute = GeneralImageBuilder.stateHeader(this.group, styleGroup, this.skinParam);
        double attributeHeight = attribute.calculateDimension(ug.getStringBounder()).getHeight();
        if (((Dimension2D)total).getWidth() == 0.0) {
            System.err.println("Cluster::drawUState issue");
            return;
        }
        UStroke stroke = this.group.getColors().getSpecificLineStroke();
        if (stroke == null) {
            stroke = this.getStyleState().getStroke();
        }
        RoundedContainer r = new RoundedContainer(total, suppY, attributeHeight + (double)(attributeHeight > 0.0 ? 5 : 0), borderColor, backColor, imgBackcolor, stroke, rounded, shadowing);
        r.drawU(ug.apply(new UTranslate(this.minX, this.minY)));
        if (this.ztitle != null) {
            this.ztitle.drawU(ug.apply(new UTranslate(this.xTitle, this.yTitle)));
        }
        if (attributeHeight > 0.0) {
            attribute.drawU(ug.apply(new UTranslate(this.minX + 5.0, this.minY + suppY + 2.5)));
        }
        boolean bl = withSymbol = (stereotype = this.group.getStereotype()) != null && stereotype.isWithOOSymbol();
        if (withSymbol) {
            EntityImageState.drawSymbol(ug.apply(borderColor), this.maxX, this.maxY);
        }
    }

    public void setPosition(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    private boolean isThereALinkFromOrToGroup(Collection<SvekLine> lines) {
        for (SvekLine line : lines) {
            if (!line.isLinkFromOrTo(this.group)) continue;
            return true;
        }
        return false;
    }

    public void printCluster1(StringBuilder sb, Collection<SvekLine> lines, StringBounder stringBounder) {
        for (SvekNode node : this.getNodesOrderedTop(lines)) {
            node.appendShape(sb, stringBounder);
        }
    }

    private List<IShapePseudo> addProtection(List<? extends IShapePseudo> entries, double width) {
        ArrayList<IShapePseudo> result = new ArrayList<IShapePseudo>();
        result.add(entries.get(0));
        for (int i = 1; i < entries.size(); ++i) {
            result.add(new ShapePseudoImpl("psd" + UniqueSequence.getValue(), width, 5.0));
            result.add(entries.get(i));
        }
        return result;
    }

    private double getMaxWidthFromLabelForEntryExit(List<? extends IShapePseudo> entries, StringBounder stringBounder) {
        double result = -1.7976931348623157E308;
        for (IShapePseudo iShapePseudo : entries) {
            double w = this.getMaxWidthFromLabelForEntryExit(iShapePseudo, stringBounder);
            if (!(w > result)) continue;
            result = w;
        }
        return result;
    }

    private double getMaxWidthFromLabelForEntryExit(IShapePseudo node, StringBounder stringBounder) {
        return node.getMaxWidthFromLabelForEntryExit(stringBounder);
    }

    /*
     * WARNING - void declaration
     */
    private void printRanks(String rank, List<? extends IShapePseudo> entries, StringBuilder sb, StringBounder stringBounder) {
        if (entries.size() > 0) {
            sb.append("{rank=" + rank + ";");
            for (IShapePseudo iShapePseudo : entries) {
                sb.append(iShapePseudo.getUid() + ";");
            }
            sb.append("}");
            SvekUtils.println(sb);
            for (IShapePseudo iShapePseudo : entries) {
                iShapePseudo.appendShape(sb, stringBounder);
            }
            SvekUtils.println(sb);
            if (this.hasPort()) {
                void var6_11;
                boolean arrow = false;
                Object var6_10 = null;
                for (IShapePseudo iShapePseudo : entries) {
                    if (arrow) {
                        sb.append("->");
                    }
                    arrow = true;
                    String string = iShapePseudo.getUid();
                    sb.append(string);
                }
                sb.append(';');
                SvekUtils.println(sb);
                sb.append((String)var6_11 + "->" + this.empty() + ";");
                SvekUtils.println(sb);
            }
        }
    }

    private List<? extends IShapePseudo> withPositionProtected(StringBounder stringBounder, Set<EntityPosition> targets) {
        List<SvekNode> result = this.withPosition(targets);
        double maxWith = this.getMaxWidthFromLabelForEntryExit(result, stringBounder);
        double naturalSpace = 70.0;
        if (maxWith > 70.0) {
            return this.addProtection(result, maxWith - 70.0);
        }
        return result;
    }

    private List<SvekNode> withPosition(Set<EntityPosition> positions) {
        ArrayList<SvekNode> result = new ArrayList<SvekNode>();
        for (SvekNode sh : this.nodes) {
            if (!positions.contains((Object)sh.getEntityPosition())) continue;
            result.add(sh);
        }
        return result;
    }

    private void printClusterEntryExit(StringBuilder sb, StringBounder stringBounder) {
        this.printRanks(RANK_SOURCE, this.withPositionProtected(stringBounder, EntityPosition.getInputs()), sb, stringBounder);
        this.printRanks(RANK_SAME, this.withPositionProtected(stringBounder, EntityPosition.getSame()), sb, stringBounder);
        this.printRanks(RANK_SINK, this.withPositionProtected(stringBounder, EntityPosition.getOutputs()), sb, stringBounder);
    }

    public SvekNode printCluster2(StringBuilder sb, Collection<SvekLine> lines, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType type) {
        SvekNode added = null;
        for (SvekNode node : this.getNodesOrderedWithoutTop(lines)) {
            node.appendShape(sb, stringBounder);
            added = node;
        }
        if (this.skinParam.useRankSame() && dotMode != DotMode.NO_LEFT_RIGHT_AND_XLABEL && !graphvizVersion.ignoreHorizontalLinks()) {
            this.appendRankSame(sb, lines);
        }
        for (Cluster child : this.getChildren()) {
            child.printInternal(sb, lines, stringBounder, dotMode, graphvizVersion, type);
        }
        return added;
    }

    private void appendRankSame(StringBuilder sb, Collection<SvekLine> lines) {
        for (String same : this.getRankSame(lines)) {
            sb.append(same);
            SvekUtils.println(sb);
        }
    }

    private Set<String> getRankSame(Collection<SvekLine> lines) {
        HashSet<String> rankSame = new HashSet<String>();
        for (SvekLine l : lines) {
            String same;
            if (l.hasEntryPoint()) continue;
            String startUid = l.getStartUidPrefix();
            String endUid = l.getEndUidPrefix();
            if (!this.isInCluster(startUid) || !this.isInCluster(endUid) || (same = l.rankSame()) == null) continue;
            rankSame.add(same);
        }
        return rankSame;
    }

    public void fillRankMin(Set<String> rankMin) {
        for (SvekNode sh : this.getNodes()) {
            if (!sh.isTop()) continue;
            rankMin.add(sh.getUid());
        }
        for (Cluster child : this.getChildren()) {
            child.fillRankMin(rankMin);
        }
    }

    private boolean isInCluster(String uid) {
        for (SvekNode node : this.nodes) {
            if (!node.getUid().equals(uid)) continue;
            return true;
        }
        return false;
    }

    public String getClusterId() {
        return "cluster" + this.color;
    }

    public static String getSpecialPointId(IEntity group) {
        return CENTER_ID + group.getUid();
    }

    private boolean protection0(UmlDiagramType type) {
        return !this.skinParam.useSwimlanes(type);
    }

    private boolean protection1(UmlDiagramType type) {
        if (this.group.getUSymbol() == USymbols.NODE) {
            return true;
        }
        return !this.skinParam.useSwimlanes(type);
    }

    public String getMinPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "minPoint" + this.color;
        }
        return null;
    }

    public String getMaxPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "maxPoint" + this.color;
        }
        return null;
    }

    private String getSourceInPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "sourceIn" + this.color;
        }
        return null;
    }

    private String getSinkInPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "sinkIn" + this.color;
        }
        return null;
    }

    private void printInternal(StringBuilder sb, Collection<SvekLine> lines, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType type) {
        String label;
        Set<EntityPosition> entityPositionsExceptNormal;
        boolean thereALinkFromOrToGroup2;
        boolean thereALinkFromOrToGroup1 = thereALinkFromOrToGroup2 = this.isThereALinkFromOrToGroup(lines);
        boolean useProtectionWhenThereALinkFromOrToGroup = graphvizVersion.useProtectionWhenThereALinkFromOrToGroup();
        if (!useProtectionWhenThereALinkFromOrToGroup) {
            thereALinkFromOrToGroup1 = false;
        }
        if (thereALinkFromOrToGroup1) {
            this.subgraphClusterNoLabel(sb, "a");
        }
        if ((entityPositionsExceptNormal = this.entityPositionsExceptNormal()).size() > 0) {
            for (SvekLine line : lines) {
                if (!line.isLinkFromOrTo(this.group)) continue;
                line.setProjectionCluster(this);
            }
        }
        boolean protection0 = this.protection0(type);
        boolean protection1 = this.protection1(type);
        if (entityPositionsExceptNormal.size() > 0 || !useProtectionWhenThereALinkFromOrToGroup) {
            protection0 = false;
            protection1 = false;
        }
        if (protection0) {
            this.subgraphClusterNoLabel(sb, "p0");
        }
        sb.append("subgraph " + this.getClusterId() + " {");
        sb.append("style=solid;");
        sb.append("color=\"" + StringUtils.sharp000000(this.color) + "\";");
        if (this.isLabel()) {
            StringBuilder sblabel = new StringBuilder("<");
            SvekLine.appendTable(sblabel, this.getTitleAndAttributeWidth(), this.getTitleAndAttributeHeight() - 5, this.colorTitle);
            sblabel.append(">");
            label = sblabel.toString();
            HorizontalAlignment align = this.skinParam.getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null);
            sb.append("labeljust=\"" + align.getGraphVizValue() + "\";");
        } else {
            label = "\"\"";
        }
        if (entityPositionsExceptNormal.size() > 0) {
            this.printClusterEntryExit(sb, stringBounder);
            if (this.hasPort()) {
                this.subgraphClusterNoLabel(sb, ID_EE);
            } else {
                this.subgraphClusterWithLabel(sb, ID_EE, label);
            }
        } else {
            sb.append("label=" + label + ";");
            SvekUtils.println(sb);
        }
        if (thereALinkFromOrToGroup2) {
            sb.append(Cluster.getSpecialPointId(this.group) + " [shape=point,width=.01,label=\"\"];");
        }
        if (thereALinkFromOrToGroup1) {
            this.subgraphClusterNoLabel(sb, "i");
        }
        if (protection1) {
            this.subgraphClusterNoLabel(sb, "p1");
        }
        if (this.skinParam.useSwimlanes(type)) {
            sb.append("{rank = source; ");
            sb.append(this.getSourceInPoint(type));
            sb.append(" [shape=point,width=.01,label=\"\"];");
            sb.append(this.getMinPoint(type) + "->" + this.getSourceInPoint(type) + "  [weight=999];");
            sb.append("}");
            SvekUtils.println(sb);
            sb.append("{rank = sink; ");
            sb.append(this.getSinkInPoint(type));
            sb.append(" [shape=point,width=.01,label=\"\"];");
            sb.append("}");
            sb.append(this.getSinkInPoint(type) + "->" + this.getMaxPoint(type) + "  [weight=999];");
            SvekUtils.println(sb);
        }
        SvekUtils.println(sb);
        this.printCluster1(sb, lines, stringBounder);
        SvekNode added = this.printCluster2(sb, lines, stringBounder, dotMode, graphvizVersion, type);
        if (entityPositionsExceptNormal.size() > 0) {
            if (this.hasPort()) {
                sb.append(this.empty() + " [shape=rect,width=.01,height=.01,label=");
                sb.append(label);
                sb.append("];");
            } else if (added == null) {
                sb.append(this.empty() + " [shape=point,width=.01,label=\"\"];");
            }
        }
        SvekUtils.println(sb);
        sb.append("}");
        if (protection1) {
            sb.append("}");
        }
        if (thereALinkFromOrToGroup1) {
            sb.append("}");
            sb.append("}");
        }
        if (entityPositionsExceptNormal.size() > 0) {
            sb.append("}");
        }
        if (protection0) {
            sb.append("}");
        }
        SvekUtils.println(sb);
    }

    private boolean hasPort() {
        for (EntityPosition pos : this.entityPositionsExceptNormal()) {
            if (!pos.isPort()) continue;
            return true;
        }
        return false;
    }

    private String empty() {
        return Cluster.getSpecialPointId(this.group);
    }

    public boolean isLabel() {
        return this.getTitleAndAttributeHeight() > 0 && this.getTitleAndAttributeWidth() > 0;
    }

    private void subgraphClusterNoLabel(StringBuilder sb, String id) {
        this.subgraphClusterWithLabel(sb, id, "\"\"");
    }

    private void subgraphClusterWithLabel(StringBuilder sb, String id, String label) {
        sb.append("subgraph " + this.getClusterId() + id + " {");
        sb.append("label=" + label + ";");
    }

    public int getColor() {
        return this.color;
    }

    public int getTitleColor() {
        return this.colorTitle;
    }

    private final HColor getBackColor(UmlDiagramType umlDiagramType, Style style) {
        if (EntityUtils.groupRoot(this.group)) {
            return null;
        }
        HColor result = this.group.getColors().getColor(ColorType.BACK);
        if (result != null) {
            return result;
        }
        Stereotype stereo = this.group.getStereotype();
        return style.value(PName.BackGroundColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
    }

    public boolean isClusterOf(IEntity ent) {
        if (!ent.isGroup()) {
            return false;
        }
        return this.group == ent;
    }

    public static HColor getBackColor(HColor backColor, Stereotype stereotype, SName styleName, USymbol symbol, StyleBuilder styleBuilder, ThemeStyle themeStyle, HColorSet colorSet) {
        Style style = Cluster.getDefaultStyleDefinition(styleName, symbol).getMergedStyle(styleBuilder);
        if (backColor == null) {
            backColor = style.value(PName.BackGroundColor).asColor(themeStyle, colorSet);
        }
        if (backColor == null || backColor.equals(HColors.transparent())) {
            backColor = HColors.transparent();
        }
        return backColor;
    }

    public double checkFolderPosition(Point2D pt, StringBounder stringBounder) {
        if (this.getClusterPosition().isPointJustUpper(pt)) {
            if (this.ztitle == null) {
                return 0.0;
            }
            Dimension2D dimTitle = this.ztitle.calculateDimension(stringBounder);
            if (pt.getX() < this.getClusterPosition().getMinX() + dimTitle.getWidth()) {
                return 0.0;
            }
            return this.getClusterPosition().getMinY() - pt.getY() + dimTitle.getHeight();
        }
        return 0.0;
    }
}

