/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class LinkArg {
    private final Display label;
    private final int length;
    private final String qualifier1;
    private final String qualifier2;
    private final String labeldistance;
    private final String labelangle;
    private final HColor specificColor;
    private VisibilityModifier visibilityModifier;

    public LinkArg(Display label, int length) {
        this(label, length, null, null, null, null, null);
    }

    public LinkArg withQualifier(String qualifier1, String qualifier2) {
        return new LinkArg(this.label, this.length, qualifier1, qualifier2, this.labeldistance, this.labelangle, this.specificColor);
    }

    public LinkArg withDistanceAngle(String labeldistance, String labelangle) {
        return new LinkArg(this.label, this.length, this.qualifier1, this.qualifier2, labeldistance, labelangle, this.specificColor);
    }

    public LinkArg withColor(HColor specificColor) {
        return new LinkArg(this.label, this.length, this.qualifier1, this.qualifier2, this.labeldistance, this.labelangle, specificColor);
    }

    private LinkArg(Display label, int length, String qualifier1, String qualifier2, String labeldistance, String labelangle, HColor specificColor) {
        if (Display.isNull(label)) {
            this.label = Display.NULL;
        } else {
            this.label = label.manageGuillemet();
            if (VisibilityModifier.isVisibilityCharacter(label.get(0))) {
                this.visibilityModifier = VisibilityModifier.getVisibilityModifier(label.get(0), false);
            }
        }
        this.length = length;
        this.qualifier1 = qualifier1;
        this.qualifier2 = qualifier2;
        this.labeldistance = labeldistance;
        this.labelangle = labelangle;
        this.specificColor = specificColor;
    }

    public final Display getLabel() {
        return this.label;
    }

    public final int getLength() {
        return this.length;
    }

    public final String getQualifier1() {
        return this.qualifier1;
    }

    public final String getQualifier2() {
        return this.qualifier2;
    }

    public final String getLabeldistance() {
        return this.labeldistance;
    }

    public final String getLabelangle() {
        return this.labelangle;
    }

    public final HColor getSpecificColor() {
        return this.specificColor;
    }

    public final VisibilityModifier getVisibilityModifier() {
        return this.visibilityModifier;
    }
}

