/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class FtileCircleEnd
extends AbstractFtile {
    private static final int SIZE = 20;
    private HColor borderColor;
    private HColor backColor;
    private final Swimlane swimlane;
    private double shadowing;

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    public FtileCircleEnd(ISkinParam skinParam, HColor backColor, HColor borderColor, Swimlane swimlane, Style style) {
        super(skinParam);
        this.borderColor = borderColor;
        this.backColor = backColor;
        this.swimlane = swimlane;
        this.shadowing = style.value(PName.Shadowing).asDouble();
        this.backColor = style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        this.borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic ug) {
        double xTheoricalPosition = 0.0;
        double yTheoricalPosition = 0.0;
        xTheoricalPosition = Math.round(xTheoricalPosition);
        yTheoricalPosition = Math.round(yTheoricalPosition);
        UEllipse circle = new UEllipse(20.0, 20.0);
        circle.setDeltaShadow(this.shadowing);
        ug = ug.apply(this.borderColor);
        double thickness = 2.5;
        ug.apply(this.backColor.bg()).apply(new UStroke(1.5)).apply(new UTranslate(xTheoricalPosition, yTheoricalPosition)).draw(circle);
        double size2 = 17.5 / Math.sqrt(2.0);
        double delta = (20.0 - size2) / 2.0;
        ug = ug.apply(new UStroke(2.5));
        ug.apply(new UTranslate(delta, delta)).draw(new ULine(size2, size2));
        ug.apply(new UTranslate(delta, 20.0 - delta)).draw(new ULine(size2, -size2));
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        return new FtileGeometry(20.0, 20.0, 10.0, 0.0);
    }
}

