/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class FtileBlackBlock
extends AbstractFtile {
    private final double labelMargin = 5.0;
    private double width;
    private double height;
    private TextBlock label = TextBlockUtils.empty(0.0, 0.0);
    private final Swimlane swimlane;

    public FtileBlackBlock(ISkinParam skinParam, Swimlane swimlane) {
        super(skinParam);
        this.swimlane = swimlane;
    }

    public void setBlackBlockDimension(double width, double height) {
        this.height = height;
        this.width = width;
    }

    public void setLabel(TextBlock label) {
        this.label = Objects.requireNonNull(label);
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        double supp = this.label.calculateDimension(stringBounder).getWidth();
        if (supp > 0.0) {
            supp += 5.0;
        }
        return new FtileGeometry(this.width + supp, this.height, this.width / 2.0, 0.0, this.height);
    }

    private StyleSignatureBasic getSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activityBar);
    }

    @Override
    public void drawU(UGraphic ug) {
        URectangle rect = new URectangle(this.width, this.height).rounded(5.0).ignoreForCompressionOnX();
        Style style = this.getSignature().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
        double shadowing = style.value(PName.Shadowing).asDouble();
        rect.setDeltaShadow(shadowing);
        HColor colorBar = style.value(PName.BackGroundColor).asColor(this.skinParam().getThemeStyle(), this.getIHtmlColorSet());
        ug.apply(colorBar).apply(colorBar.bg()).draw(rect);
        Dimension2D dimLabel = this.label.calculateDimension(ug.getStringBounder());
        this.label.drawU(ug.apply(new UTranslate(this.width + 5.0, -dimLabel.getHeight() / 2.0)));
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }
}

