/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileImageData;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.NewpagedDiagram;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SplitParam;
import net.sourceforge.plantuml.SuggestedFile;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.html.CucaDiagramHtmlMaker;
import net.sourceforge.plantuml.png.PngSplitter;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class PSystemUtils {
    public static List<FileImageData> exportDiagrams(Diagram system, SuggestedFile suggested, FileFormatOption fileFormatOption) throws IOException {
        return PSystemUtils.exportDiagrams(system, suggested, fileFormatOption, false);
    }

    public static List<FileImageData> exportDiagrams(Diagram system, SuggestedFile suggestedFile, FileFormatOption fileFormatOption, boolean checkMetadata) throws IOException {
        boolean sameMetadata;
        SFile existingFile = suggestedFile.getFile(0);
        if (checkMetadata && fileFormatOption.getFileFormat().doesSupportMetadata() && existingFile.exists() && system.getNbImages() == 1 && (sameMetadata = fileFormatOption.getFileFormat().equalsMetadata(system.getMetadata(), existingFile))) {
            Log.info("Skipping " + existingFile.getPrintablePath() + " because metadata has not changed.");
            return Arrays.asList(new FileImageData(existingFile, null));
        }
        if (system instanceof NewpagedDiagram) {
            return PSystemUtils.exportDiagramsNewpaged((NewpagedDiagram)system, suggestedFile, fileFormatOption);
        }
        if (system instanceof SequenceDiagram) {
            return PSystemUtils.exportDiagramsSequence((SequenceDiagram)system, suggestedFile, fileFormatOption);
        }
        if (system instanceof CucaDiagram && fileFormatOption.getFileFormat() == FileFormat.HTML) {
            return PSystemUtils.createFilesHtml((CucaDiagram)system, suggestedFile);
        }
        return PSystemUtils.exportDiagramsDefault(system, suggestedFile, fileFormatOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileImageData> exportDiagramsNewpaged(NewpagedDiagram system, SuggestedFile suggestedFile, FileFormatOption fileFormat) throws IOException {
        ArrayList<FileImageData> result = new ArrayList<FileImageData>();
        int nbImages = system.getNbImages();
        for (int i = 0; i < nbImages; ++i) {
            SFile f = suggestedFile.getFile(i);
            if (!PSystemUtils.canFileBeWritten(f)) {
                return result;
            }
            ImageData cmap = null;
            try (BufferedOutputStream fos = f.createBufferedOutputStream();){
                system.exportDiagram(fos, i, fileFormat);
            }
            Log.info("File size : " + f.length());
            result.add(new FileImageData(f, cmap));
        }
        return result;
    }

    public static boolean canFileBeWritten(SFile f) {
        Log.info("Creating file: " + f.getAbsolutePath());
        if (f.exists() && !f.canWrite()) {
            if (OptionFlags.getInstance().isOverwrite()) {
                Log.info("Overwrite " + f);
                f.setWritable(true);
                f.delete();
                return true;
            }
            Log.error("Cannot write to file " + f.getAbsolutePath());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileImageData> exportDiagramsSequence(SequenceDiagram system, SuggestedFile suggestedFile, FileFormatOption fileFormat) throws IOException {
        ArrayList<FileImageData> result = new ArrayList<FileImageData>();
        int nbImages = system.getNbImages();
        for (int i = 0; i < nbImages; ++i) {
            SFile f = suggestedFile.getFile(i);
            if (!PSystemUtils.canFileBeWritten(suggestedFile.getFile(i))) {
                return result;
            }
            ImageData cmap = null;
            try (BufferedOutputStream fos = f.createBufferedOutputStream();){
                cmap = system.exportDiagram(fos, i, fileFormat);
            }
            if (cmap != null && cmap.containsCMapData()) {
                system.exportCmap(suggestedFile, i, cmap);
            }
            Log.info("File size : " + f.length());
            result.add(new FileImageData(f, cmap));
        }
        return result;
    }

    private static List<FileImageData> createFilesHtml(CucaDiagram system, SuggestedFile suggestedFile) throws IOException {
        String name = suggestedFile.getName();
        int idx = name.lastIndexOf(46);
        SFile dir = suggestedFile.getParentFile().file(name.substring(0, idx));
        CucaDiagramHtmlMaker maker = new CucaDiagramHtmlMaker(system, dir);
        return maker.create();
    }

    private static List<FileImageData> splitPng(TitledDiagram diagram, SuggestedFile pngFile, ImageData imageData, FileFormatOption fileFormatOption) throws IOException {
        List<SFile> files = new PngSplitter(pngFile, diagram.getSplitPagesHorizontal(), diagram.getSplitPagesVertical(), fileFormatOption.isWithMetadata() ? diagram.getMetadata() : null, diagram.getSkinParam().getDpi(), diagram instanceof GanttDiagram ? new SplitParam(HColors.BLACK, null, 5) : diagram.getSkinParam().getSplitParam()).getFiles();
        ArrayList<FileImageData> result = new ArrayList<FileImageData>();
        for (SFile f : files) {
            result.add(new FileImageData(f, imageData));
        }
        return result;
    }

    private static List<FileImageData> exportDiagramsDefault(Diagram system, SuggestedFile suggestedFile, FileFormatOption fileFormatOption) throws IOException {
        ImageData imageData;
        SFile outputFile = suggestedFile.getFile(0);
        if (outputFile.isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + suggestedFile);
        }
        if (!PSystemUtils.canFileBeWritten(outputFile)) {
            return Collections.emptyList();
        }
        try (BufferedOutputStream os = outputFile.createBufferedOutputStream();){
            imageData = system.exportDiagram(os, 0, fileFormatOption);
        }
        if (imageData == null) {
            return Collections.emptyList();
        }
        if (imageData.containsCMapData() && system instanceof UmlDiagram) {
            ((UmlDiagram)system).exportCmap(suggestedFile, 0, imageData);
        }
        if (system instanceof TitledDiagram && fileFormatOption.getFileFormat() == FileFormat.PNG) {
            return PSystemUtils.splitPng((TitledDiagram)system, suggestedFile, imageData, fileFormatOption);
        }
        return Collections.singletonList(new FileImageData(outputFile, imageData));
    }
}

