#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 pandoc
version:              2.19.2
visibility:           public
id:                   pandoc-2.19.2-GwVlPrQTBqALdft4pG37VU
key:                  pandoc-2.19.2-GwVlPrQTBqALdft4pG37VU
license:              GPL-2.0-or-later
copyright:            (c) 2006-2022 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, and plain text.
    It includes a powerful system for automatic citations
    and bibliographies, and it can be customized extensively
    using templates, filters, and custom readers and writers
    written in Lua.

category:             Text
abi:                  6f6071d36b1996627a7c4b70ae777725
exposed:              True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify
    Text.Pandoc.Citeproc Text.Pandoc.Class Text.Pandoc.Emoji
    Text.Pandoc.Error Text.Pandoc.Extensions Text.Pandoc.Filter
    Text.Pandoc.Highlighting Text.Pandoc.ImageSize Text.Pandoc.Logging
    Text.Pandoc.Lua Text.Pandoc.MIME Text.Pandoc.MediaBag
    Text.Pandoc.Options Text.Pandoc.PDF Text.Pandoc.Parsing
    Text.Pandoc.Process Text.Pandoc.Readers Text.Pandoc.Readers.BibTeX
    Text.Pandoc.Readers.CSV Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.Creole Text.Pandoc.Readers.CslJson
    Text.Pandoc.Readers.Custom Text.Pandoc.Readers.DocBook
    Text.Pandoc.Readers.Docx Text.Pandoc.Readers.DokuWiki
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.EndNote
    Text.Pandoc.Readers.FB2 Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.Ipynb
    Text.Pandoc.Readers.JATS Text.Pandoc.Readers.Jira
    Text.Pandoc.Readers.LaTeX Text.Pandoc.Readers.Man
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.MediaWiki
    Text.Pandoc.Readers.Muse Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.OPML Text.Pandoc.Readers.Odt
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.RIS
    Text.Pandoc.Readers.RST Text.Pandoc.Readers.RTF
    Text.Pandoc.Readers.TWiki Text.Pandoc.Readers.Textile
    Text.Pandoc.Readers.TikiWiki Text.Pandoc.Readers.Txt2Tags
    Text.Pandoc.Readers.Vimwiki Text.Pandoc.SelfContained
    Text.Pandoc.Server Text.Pandoc.Shared Text.Pandoc.Sources
    Text.Pandoc.Templates Text.Pandoc.UTF8 Text.Pandoc.Writers
    Text.Pandoc.Writers.AnnotatedTable Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.BibTeX Text.Pandoc.Writers.CommonMark
    Text.Pandoc.Writers.ConTeXt Text.Pandoc.Writers.CslJson
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.Ipynb
    Text.Pandoc.Writers.JATS Text.Pandoc.Writers.Jira
    Text.Pandoc.Writers.LaTeX Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.Math
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.Ms
    Text.Pandoc.Writers.Muse Text.Pandoc.Writers.Native
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.OOXML
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.Powerpoint
    Text.Pandoc.Writers.RST Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.Shared Text.Pandoc.Writers.TEI
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.XWiki Text.Pandoc.Writers.ZimWiki
    Text.Pandoc.XML

hidden-modules:
    Text.Pandoc.App.CommandLineOptions Text.Pandoc.App.FormatHeuristics
    Text.Pandoc.App.Opt Text.Pandoc.App.OutputSettings
    Text.Pandoc.Class.CommonState Text.Pandoc.Class.IO
    Text.Pandoc.Class.PandocMonad Text.Pandoc.Class.PandocIO
    Text.Pandoc.Class.PandocPure Text.Pandoc.Class.Sandbox
    Text.Pandoc.Filter.Environment Text.Pandoc.Filter.JSON
    Text.Pandoc.Filter.Lua Text.Pandoc.Parsing.Capabilities
    Text.Pandoc.Parsing.Citations Text.Pandoc.Parsing.General
    Text.Pandoc.Parsing.GridTable Text.Pandoc.Parsing.Lists
    Text.Pandoc.Parsing.Math Text.Pandoc.Parsing.Smart
    Text.Pandoc.Parsing.State Text.Pandoc.Parsing.Types
    Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
    Text.Pandoc.Readers.Docx.Parse
    Text.Pandoc.Readers.Docx.Parse.Styles Text.Pandoc.Readers.Docx.Util
    Text.Pandoc.Readers.Docx.Fields Text.Pandoc.Readers.HTML.Parsing
    Text.Pandoc.Readers.HTML.Table
    Text.Pandoc.Readers.HTML.TagCategories
    Text.Pandoc.Readers.HTML.Types Text.Pandoc.Readers.LaTeX.Inline
    Text.Pandoc.Readers.LaTeX.Citation Text.Pandoc.Readers.LaTeX.Lang
    Text.Pandoc.Readers.LaTeX.Macro Text.Pandoc.Readers.LaTeX.Math
    Text.Pandoc.Readers.LaTeX.Parsing Text.Pandoc.Readers.LaTeX.SIunitx
    Text.Pandoc.Readers.LaTeX.Table Text.Pandoc.Readers.LaTeX.Types
    Text.Pandoc.Readers.Odt.Base Text.Pandoc.Readers.Odt.Namespaces
    Text.Pandoc.Readers.Odt.StyleReader
    Text.Pandoc.Readers.Odt.ContentReader
    Text.Pandoc.Readers.Odt.Generic.Fallible
    Text.Pandoc.Readers.Odt.Generic.SetMap
    Text.Pandoc.Readers.Odt.Generic.Utils
    Text.Pandoc.Readers.Odt.Generic.Namespaces
    Text.Pandoc.Readers.Odt.Generic.XMLConverter
    Text.Pandoc.Readers.Odt.Arrows.State
    Text.Pandoc.Readers.Odt.Arrows.Utils
    Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
    Text.Pandoc.Readers.Org.DocumentTree
    Text.Pandoc.Readers.Org.ExportSettings
    Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
    Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
    Text.Pandoc.Readers.Org.Shared Text.Pandoc.Readers.Metadata
    Text.Pandoc.Readers.Roff Text.Pandoc.Writers.Docx.StyleMap
    Text.Pandoc.Writers.Docx.Table Text.Pandoc.Writers.Docx.Types
    Text.Pandoc.Writers.GridTable Text.Pandoc.Writers.JATS.References
    Text.Pandoc.Writers.JATS.Table Text.Pandoc.Writers.JATS.Types
    Text.Pandoc.Writers.LaTeX.Caption Text.Pandoc.Writers.LaTeX.Notes
    Text.Pandoc.Writers.LaTeX.Table Text.Pandoc.Writers.LaTeX.Lang
    Text.Pandoc.Writers.LaTeX.Types Text.Pandoc.Writers.LaTeX.Citation
    Text.Pandoc.Writers.LaTeX.Util Text.Pandoc.Writers.Markdown.Table
    Text.Pandoc.Writers.Markdown.Types
    Text.Pandoc.Writers.Markdown.Inline Text.Pandoc.Writers.Roff
    Text.Pandoc.Writers.Blaze
    Text.Pandoc.Writers.Powerpoint.Presentation
    Text.Pandoc.Writers.Powerpoint.Output
    Text.Pandoc.Lua.ErrorConversion Text.Pandoc.Lua.Filter
    Text.Pandoc.Lua.Global Text.Pandoc.Lua.Init
    Text.Pandoc.Lua.Marshal.CommonState Text.Pandoc.Lua.Marshal.Context
    Text.Pandoc.Lua.Marshal.PandocError
    Text.Pandoc.Lua.Marshal.ReaderOptions
    Text.Pandoc.Lua.Marshal.Reference Text.Pandoc.Lua.Marshal.Sources
    Text.Pandoc.Lua.Marshal.Template
    Text.Pandoc.Lua.Marshal.WriterOptions
    Text.Pandoc.Lua.Module.MediaBag Text.Pandoc.Lua.Module.Pandoc
    Text.Pandoc.Lua.Module.System Text.Pandoc.Lua.Module.Template
    Text.Pandoc.Lua.Module.Types Text.Pandoc.Lua.Module.Utils
    Text.Pandoc.Lua.Orphans Text.Pandoc.Lua.PandocLua
    Text.Pandoc.Lua.Writer.Classic Text.Pandoc.XML.Light
    Text.Pandoc.XML.Light.Types Text.Pandoc.XML.Light.Proc
    Text.Pandoc.XML.Light.Output Text.Pandoc.Network.HTTP
    Text.Pandoc.CSS Text.Pandoc.CSV Text.Pandoc.RoffChar
    Text.Pandoc.UUID Text.Pandoc.Translations Text.Pandoc.Slides
    Text.Pandoc.Image Text.Pandoc.Citeproc.BibTeX
    Text.Pandoc.Citeproc.CslJson Text.Pandoc.Citeproc.Data
    Text.Pandoc.Citeproc.Locator Text.Pandoc.Citeproc.MetaValue
    Text.Pandoc.Citeproc.Util Paths_pandoc

import-dirs:          /usr/lib/ghc-9.0.2/site-local/pandoc-2.19.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/pandoc-2.19.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/pandoc
hs-libraries:         HSpandoc-2.19.2-GwVlPrQTBqALdft4pG37VU
depends:
    Glob-0.10.2-2hpHTQOFOu786tzr1Hmjwm
    JuicyPixels-3.3.7-7TmSTPxhYz2HnGAcoLTyZw
    SHA-1.6.4.4-1UNVNO3JXJdDGqRoMkntZx
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    aeson-pretty-0.8.9-HIKDmSQGmI0DQYiuXhljjd array-0.5.4.0
    attoparsec-0.14.4-9SQv4o2tq0k4n7CegIwza1 base-4.15.1.0
    base64-0.4.2.4-G4e78r5RGs9KhnijZEDeLF binary-0.8.8.0
    blaze-html-0.9.1.2-AIRGwJuJakcDOfrsYtfKDl
    blaze-markup-0.8.2.8-3wZdN7kDxS97Q5eM0mxELA bytestring-0.10.12.1
    case-insensitive-1.2.1.0-9P0gl8mW2it6Cg0EClpHns
    citeproc-0.8.0.2-9nCcFrdQCnd7DjDHf2xtET
    commonmark-0.2.2-DBus3b9sqSI4PDFIf8KWvt
    commonmark-extensions-0.2.3.3-K1dXI0nKc7y4j6PxKZbs6i
    commonmark-pandoc-0.2.1.2-A4mxJQ08ET79wMSwWzoYuX
    connection-0.3.1-JYI1k0aRYnU8j2StkrJ4ln containers-0.6.4.1
    data-default-0.7.1.1-BkZarJ3J3008hHF2JOuYeW deepseq-1.4.5.0
    directory-1.3.6.2 doclayout-0.4-JUNdJMPDpmeDSop0PqDUQK
    doctemplates-0.10.0.2-Lph0mRg8xrH2l5E9egm4Eg
    emojis-0.1.2-3hcHsPqy0kd1wz0wi4f1T8 exceptions-0.10.4
    file-embed-0.0.15.0-FF5xUPWKaB3GI64c6hgPnn filepath-1.4.2.1
    gridtables-0.1.0.0-59JPWY1bEACDybrTKNvLLl
    haddock-library-1.10.0-H2ebzKszXHDEPKTZl4XQyW
    hslua-2.2.1-44kucnvr9vu7w7UJh4vcRs
    hslua-aeson-2.2.1-E1DrwEfFWv05RV5MuO20de
    hslua-module-doclayout-1.0.4-G1NBNWpsb42A9KzGiiR7GT
    hslua-module-path-1.0.3-KDinst3G9Ep4AMn3GfxE9o
    hslua-module-system-1.0.2-2bOElkgg7TjH93zpQtNtrj
    hslua-module-text-1.0.2-FGNIU1cDpYvcWy1YTnatk
    hslua-module-version-1.0.3-FSdWnKZSeqE91X12aBmkQm
    http-client-0.7.13.1-IUPmZAWhHcS7Jd2UKXuikW
    http-client-tls-0.3.6.1-KvEPoRWqIbH3HwtuX8a907
    http-types-0.12.3-L4VBkj9wBbpJhmiMCXrA05
    ipynb-0.2-ASOYGi09triBkvuYeJZcrE
    jira-wiki-markup-1.4.0-AFdwXX9lkSzAzKtF2Sn6Y0
    lpeg-1.0.3-KZO3AzHPzQzG7SHaa8Upxw mtl-2.2.2
    network-3.1.2.7-2x6X3kWddA03AmOITnySLy
    network-uri-2.6.4.1-CJy9K6CUGBYDMBcoIm8TMq
    pandoc-lua-marshal-0.1.7-BB8a9XvKqjjJhS66346itC
    pandoc-types-1.22.2.1-1T6Kd9AZiZ6EUNN63A2kLH parsec-3.1.14.0
    pretty-1.1.3.6 pretty-show-1.10-30ddFMLbEm1DQ0GcmAHjnN
    process-1.6.13.2 random-1.2.1.1-LHneN0qmdBg2HhYYKMDrs5
    safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q
    scientific-0.3.7.0-1l3L5iYBn9JD8GP8kLjgG7
    servant-server-0.19.2-5pb18vutHQg9KOupyhEmIH
    skylighting-0.13.1.1-KWdFk3S1T5j239sUlisJSZ
    skylighting-core-0.13.1.1-1YbMVbrFD1tI9WC8Q1Dv8s
    split-0.2.3.5-1ZFbiAR4sQhKaqqBevLjN8
    syb-0.7.2.2-JvKYfJw95RM7Y4GXhTvfdV
    tagsoup-0.14.8-HHgzaP147yNJ8Ak228ab3Q
    temporary-1.3-HXIdO020OG29nAlGx7vsUT
    texmath-0.12.5.4-9nYABVYAvNq5wv8Iu2evkv text-1.2.5.0
    text-conversions-0.3.1.1-HlhgOSFBkVSAxic3bVR8Zi time-1.9.3
    unicode-collation-0.1.3.3-AqV3CLmuuAR6uN6bgaglor
    unicode-transforms-0.4.0.1-BPJclhxoeaPJkCCeQn4Ic unix-2.7.2.2
    wai-3.2.3-4BBvzsOByYiKnH9wzG1k6K xml-1.3.14-6hlhhPBptprHwK7nsE7OzM
    xml-conduit-1.9.1.1-IWNYIVGsz09Gb3PPcGC31a
    xml-types-0.3.8-5QCBKSWiifmEtQB2jlqHYu
    yaml-0.11.8.0-EFN1CMgVIdSAIGSdgvEPUP
    zip-archive-0.4.2.2-E9rdfhhdvGpuXMTfHS9Es
    zlib-0.6.3.0-vb12epxNFtI6q1EYqoP1g

haddock-interfaces:   /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

