/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf.impl.v6;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auth.internal.InternalAuthenticationBackend;

public class ConfigV6 {
    public Dynamic dynamic;

    public String toString() {
        return "Config [dynamic=" + this.dynamic + "]";
    }

    public static class AuthzDomain {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public boolean http_enabled = true;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public boolean transport_enabled = true;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public boolean enabled = true;
        public AuthzBackend authorization_backend = new AuthzBackend();

        public String toString() {
            return "AuthzDomain [http_enabled=" + this.http_enabled + ", transport_enabled=" + this.transport_enabled + ", enabled=" + this.enabled + ", authorization_backend=" + this.authorization_backend + "]";
        }
    }

    public static class Authz {
        @JsonIgnore
        private final Map<String, AuthzDomain> domains = new HashMap<String, AuthzDomain>();

        @JsonAnySetter
        void setDomains(String key, AuthzDomain value) {
            this.domains.put(key, value);
        }

        @JsonAnyGetter
        public Map<String, AuthzDomain> getDomains() {
            return this.domains;
        }

        public String toString() {
            return "Authz [domains=" + this.domains + "]";
        }
    }

    public static class AuthcBackend {
        public String type = InternalAuthenticationBackend.class.getName();
        public Map<String, Object> config = Collections.emptyMap();

        @JsonIgnore
        public String configAsJson() {
            try {
                return DefaultObjectMapper.writeValueAsString(this.config, false);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "AuthcBackend [type=" + this.type + ", config=" + this.config + "]";
        }
    }

    public static class AuthzBackend {
        public String type = "noop";
        public Map<String, Object> config = Collections.emptyMap();

        @JsonIgnore
        public String configAsJson() {
            try {
                return DefaultObjectMapper.writeValueAsString(this.config, false);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "AuthzBackend [type=" + this.type + ", config=" + this.config + "]";
        }
    }

    public static class HttpAuthenticator {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public boolean challenge = true;
        public String type;
        public Map<String, Object> config = Collections.emptyMap();

        @JsonIgnore
        public String configAsJson() {
            try {
                return DefaultObjectMapper.writeValueAsString(this.config, false);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "HttpAuthenticator [challenge=" + this.challenge + ", type=" + this.type + ", config=" + this.config + "]";
        }
    }

    public static class AuthcDomain {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public boolean http_enabled = true;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public boolean transport_enabled = true;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public boolean enabled = true;
        public int order = 0;
        public HttpAuthenticator http_authenticator = new HttpAuthenticator();
        public AuthcBackend authentication_backend = new AuthcBackend();

        public String toString() {
            return "AuthcDomain [http_enabled=" + this.http_enabled + ", transport_enabled=" + this.transport_enabled + ", enabled=" + this.enabled + ", order=" + this.order + ", http_authenticator=" + this.http_authenticator + ", authentication_backend=" + this.authentication_backend + "]";
        }
    }

    public static class Authc {
        @JsonIgnore
        private final Map<String, AuthcDomain> domains = new HashMap<String, AuthcDomain>();

        @JsonAnySetter
        void setDomains(String key, AuthcDomain value) {
            this.domains.put(key, value);
        }

        @JsonAnyGetter
        public Map<String, AuthcDomain> getDomains() {
            return this.domains;
        }

        public String toString() {
            return "Authc [domains=" + this.domains + "]";
        }
    }

    public static class Xff {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public boolean enabled = true;
        public String internalProxies = Pattern.compile("10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|172\\.1[6-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.2[0-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.3[0-1]{1}\\.\\d{1,3}\\.\\d{1,3}").toString();
        public String remoteIpHeader = "X-Forwarded-For";
        public String proxiesHeader = "X-Forwarded-By";
        public String trustedProxies;

        public String toString() {
            return "Xff [enabled=" + this.enabled + ", internalProxies=" + this.internalProxies + ", remoteIpHeader=" + this.remoteIpHeader + ", proxiesHeader=" + this.proxiesHeader + ", trustedProxies=" + this.trustedProxies + "]";
        }
    }

    public static class AuthFailureListener {
        public String type;
        public String authentication_backend;
        public int allowed_tries = 10;
        public int time_window_seconds = 3600;
        public int block_expiry_seconds = 600;
        public int max_blocked_clients = 100000;
        public int max_tracked_clients = 100000;

        @JsonIgnore
        public String asJson() {
            try {
                return DefaultObjectMapper.writeValueAsString(this, false);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class AuthFailureListeners {
        @JsonIgnore
        private final Map<String, AuthFailureListener> listeners = new HashMap<String, AuthFailureListener>();

        @JsonAnySetter
        void setListeners(String key, AuthFailureListener value) {
            this.listeners.put(key, value);
        }

        @JsonAnyGetter
        public Map<String, AuthFailureListener> getListeners() {
            return this.listeners;
        }
    }

    public static class Http {
        public boolean anonymous_auth_enabled = false;
        public Xff xff = new Xff();

        public String toString() {
            return "Http [anonymous_auth_enabled=" + this.anonymous_auth_enabled + ", xff=" + this.xff + "]";
        }
    }

    public static class Kibana {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public boolean multitenancy_enabled = true;
        public String server_username = "kibanaserver";
        public String opendistro_role = null;
        public String index = ".kibana";
        public boolean do_not_fail_on_forbidden;

        public String toString() {
            return "Kibana [multitenancy_enabled=" + this.multitenancy_enabled + ", server_username=" + this.server_username + ", opendistro_role=" + this.opendistro_role + ", index=" + this.index + ", do_not_fail_on_forbidden=" + this.do_not_fail_on_forbidden + "]";
        }
    }

    public static class Dynamic {
        public String filtered_alias_mode = "warn";
        public boolean disable_rest_auth;
        public boolean disable_intertransport_auth;
        public boolean respect_request_indices_options;
        public String license;
        public Kibana kibana = new Kibana();
        public Http http = new Http();
        public Authc authc = new Authc();
        public Authz authz = new Authz();
        public AuthFailureListeners auth_failure_listeners = new AuthFailureListeners();
        public boolean do_not_fail_on_forbidden;
        public boolean multi_rolespan_enabled;
        public String hosts_resolver_mode = "ip-only";
        public String transport_userrname_attribute;
        public boolean do_not_fail_on_forbidden_empty;

        public String toString() {
            return "Dynamic [filtered_alias_mode=" + this.filtered_alias_mode + ", kibana=" + this.kibana + ", http=" + this.http + ", authc=" + this.authc + ", authz=" + this.authz + "]";
        }
    }
}

