/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.FailedNodeException;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.action.configupdate.ConfigUpdateAction;
import org.opensearch.security.action.configupdate.ConfigUpdateRequest;
import org.opensearch.security.action.configupdate.ConfigUpdateResponse;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import org.opensearch.security.dlic.rest.validation.NoOpValidator;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.threadpool.ThreadPool;

public class FlushCacheApiAction
extends AbstractApiAction {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.DELETE, "/cache"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/cache"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/cache"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/cache")));

    @Inject
    public FlushCacheApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.CACHE;
    }

    @Override
    protected void handleDelete(final RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        client.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(CType.lcStringValues().toArray(new String[0])), (ActionListener)new ActionListener<ConfigUpdateResponse>(){

            public void onResponse(ConfigUpdateResponse ur) {
                if (ur.hasFailures()) {
                    FlushCacheApiAction.this.log.error("Cannot flush cache due to", (Throwable)ur.failures().get(0));
                    FlushCacheApiAction.this.internalErrorResponse(channel, "Cannot flush cache due to " + ((FailedNodeException)ur.failures().get(0)).getMessage() + ".");
                    return;
                }
                FlushCacheApiAction.this.successResponse(channel, "Cache flushed successfully.");
                if (FlushCacheApiAction.this.log.isDebugEnabled()) {
                    FlushCacheApiAction.this.log.debug("cache flushed successfully");
                }
            }

            public void onFailure(Exception e) {
                FlushCacheApiAction.this.log.error("Cannot flush cache due to", (Throwable)e);
                FlushCacheApiAction.this.internalErrorResponse(channel, "Cannot flush cache due to " + e.getMessage() + ".");
            }
        });
    }

    @Override
    protected void handlePost(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.POST);
    }

    @Override
    protected void handleGet(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.GET);
    }

    @Override
    protected void handlePut(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.PUT);
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... param) {
        return new NoOpValidator(request, ref, this.settings, param);
    }

    @Override
    protected String getResourceName() {
        return null;
    }

    @Override
    protected CType getConfigName() {
        return null;
    }

    @Override
    protected void consumeParameters(RestRequest request) {
    }
}

