/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleWithWebIdentitySessionCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.http.SystemPropertyTlsKeyManagersProvider;
import com.amazonaws.http.conn.ssl.SdkTLSSocketFactory;
import com.amazonaws.internal.SdkSSLContext;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.common.settings.Settings;
import org.opensearch.repositories.s3.AmazonS3Reference;
import org.opensearch.repositories.s3.AmazonS3WithCredentials;
import org.opensearch.repositories.s3.ProxySettings;
import org.opensearch.repositories.s3.S3BasicCredentials;
import org.opensearch.repositories.s3.S3ClientSettings;
import org.opensearch.repositories.s3.S3Repository;
import org.opensearch.repositories.s3.SocketAccess;

class S3Service
implements Closeable {
    private static final Logger logger = LogManager.getLogger(S3Service.class);
    private static final String STS_ENDPOINT_OVERRIDE_SYSTEM_PROPERTY = "com.amazonaws.sdk.stsEndpointOverride";
    private volatile Map<S3ClientSettings, AmazonS3Reference> clientsCache = Collections.emptyMap();
    private volatile Map<String, S3ClientSettings> staticClientSettings = MapBuilder.newMapBuilder().put((Object)"default", (Object)S3ClientSettings.getClientSettings(Settings.EMPTY, "default")).immutableMap();
    private volatile Map<Settings, S3ClientSettings> derivedClientSettings = Collections.emptyMap();

    S3Service() {
    }

    public synchronized void refreshAndClearCache(Map<String, S3ClientSettings> clientsSettings) {
        this.releaseCachedClients();
        this.staticClientSettings = MapBuilder.newMapBuilder(clientsSettings).immutableMap();
        this.derivedClientSettings = Collections.emptyMap();
        assert (this.staticClientSettings.containsKey("default")) : "always at least have 'default'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonS3Reference client(RepositoryMetadata repositoryMetadata) {
        S3ClientSettings clientSettings = this.settings(repositoryMetadata);
        AmazonS3Reference clientReference = this.clientsCache.get(clientSettings);
        if (clientReference != null && clientReference.tryIncRef()) {
            return clientReference;
        }
        S3Service s3Service = this;
        synchronized (s3Service) {
            AmazonS3Reference existing = this.clientsCache.get(clientSettings);
            if (existing != null && existing.tryIncRef()) {
                return existing;
            }
            AmazonS3Reference clientReference2 = new AmazonS3Reference(this.buildClient(clientSettings));
            clientReference2.incRef();
            this.clientsCache = MapBuilder.newMapBuilder(this.clientsCache).put((Object)clientSettings, (Object)clientReference2).immutableMap();
            return clientReference2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    S3ClientSettings settings(RepositoryMetadata repositoryMetadata) {
        Settings settings = repositoryMetadata.settings();
        S3ClientSettings existing = this.derivedClientSettings.get(settings);
        if (existing != null) {
            return existing;
        }
        String clientName = (String)S3Repository.CLIENT_NAME.get(settings);
        S3ClientSettings staticSettings = this.staticClientSettings.get(clientName);
        if (staticSettings != null) {
            S3Service s3Service = this;
            synchronized (s3Service) {
                S3ClientSettings existing2 = this.derivedClientSettings.get(settings);
                if (existing2 != null) {
                    return existing2;
                }
                S3ClientSettings newSettings = staticSettings.refine(settings);
                this.derivedClientSettings = MapBuilder.newMapBuilder(this.derivedClientSettings).put((Object)settings, (Object)newSettings).immutableMap();
                return newSettings;
            }
        }
        throw new IllegalArgumentException("Unknown s3 client name [" + clientName + "]. Existing client configs: " + Strings.collectionToDelimitedString(this.staticClientSettings.keySet(), (String)","));
    }

    AmazonS3WithCredentials buildClient(S3ClientSettings clientSettings) {
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        AWSCredentialsProvider credentials = S3Service.buildCredentials(logger, clientSettings);
        builder.withCredentials(credentials);
        builder.withClientConfiguration(S3Service.buildConfiguration(clientSettings));
        Object endpoint = Strings.hasLength((String)clientSettings.endpoint) ? clientSettings.endpoint : "s3.amazonaws.com";
        if (!(((String)endpoint).startsWith("http://") || ((String)endpoint).startsWith("https://"))) {
            endpoint = clientSettings.protocol.toString() + "://" + (String)endpoint;
        }
        String region = Strings.hasLength((String)clientSettings.region) ? clientSettings.region : null;
        logger.debug("using endpoint [{}] and region [{}]", endpoint, (Object)region);
        builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration((String)endpoint, region));
        if (clientSettings.pathStyleAccess) {
            builder.enablePathStyleAccess();
        }
        if (clientSettings.disableChunkedEncoding) {
            builder.disableChunkedEncoding();
        }
        AmazonS3 client = SocketAccess.doPrivileged(() -> ((AmazonS3ClientBuilder)builder).build());
        return AmazonS3WithCredentials.create(client, credentials);
    }

    static ClientConfiguration buildConfiguration(final S3ClientSettings clientSettings) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        clientConfiguration.setProtocol(clientSettings.protocol);
        if (clientSettings.proxySettings != ProxySettings.NO_PROXY_SETTINGS) {
            if (clientSettings.proxySettings.getType() == ProxySettings.ProxyType.SOCKS) {
                SocketAccess.doPrivilegedVoid(() -> {
                    if (clientSettings.proxySettings.isAuthenticated()) {
                        Authenticator.setDefault(new Authenticator(){

                            @Override
                            protected PasswordAuthentication getPasswordAuthentication() {
                                return new PasswordAuthentication(clientSettings.proxySettings.getUsername(), clientSettings.proxySettings.getPassword().toCharArray());
                            }
                        });
                    }
                    clientConfiguration.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)S3Service.createSocksSslConnectionSocketFactory(clientSettings.proxySettings.getAddress()));
                });
            } else {
                if (clientSettings.proxySettings.getType() != ProxySettings.ProxyType.DIRECT) {
                    clientConfiguration.setProxyProtocol(clientSettings.proxySettings.getType().toProtocol());
                }
                clientConfiguration.setProxyHost(clientSettings.proxySettings.getHostName());
                clientConfiguration.setProxyPort(clientSettings.proxySettings.getPort());
                clientConfiguration.setProxyUsername(clientSettings.proxySettings.getUsername());
                clientConfiguration.setProxyPassword(clientSettings.proxySettings.getPassword());
            }
        }
        if (Strings.hasLength((String)clientSettings.signerOverride)) {
            clientConfiguration.setSignerOverride(clientSettings.signerOverride);
        }
        clientConfiguration.setMaxErrorRetry(clientSettings.maxRetries);
        clientConfiguration.setUseThrottleRetries(clientSettings.throttleRetries);
        clientConfiguration.setSocketTimeout(clientSettings.readTimeoutMillis);
        return clientConfiguration;
    }

    private static SSLConnectionSocketFactory createSocksSslConnectionSocketFactory(final InetSocketAddress address) {
        SSLContext sslCtx = SdkSSLContext.getPreferredSSLContext((KeyManager[])new SystemPropertyTlsKeyManagersProvider().getKeyManagers(), (SecureRandom)new SecureRandom());
        return new SdkTLSSocketFactory(sslCtx, (HostnameVerifier)new DefaultHostnameVerifier()){

            public Socket createSocket(HttpContext ctx) throws IOException {
                return new Socket(new Proxy(Proxy.Type.SOCKS, address));
            }
        };
    }

    static AWSCredentialsProvider buildCredentials(Logger logger, S3ClientSettings clientSettings) {
        S3BasicCredentials basicCredentials = clientSettings.credentials;
        S3ClientSettings.IrsaCredentials irsaCredentials = S3Service.buildFromEnviroment(clientSettings.irsaCredentials);
        if (irsaCredentials != null) {
            String region;
            logger.debug("Using IRSA credentials");
            AWSSecurityTokenService securityTokenService = null;
            String string = region = Strings.hasLength((String)clientSettings.region) ? clientSettings.region : null;
            if (region != null || basicCredentials != null) {
                securityTokenService = SocketAccess.doPrivileged(() -> {
                    AWSSecurityTokenServiceClientBuilder builder = AWSSecurityTokenServiceClientBuilder.standard();
                    String stsEndpoint = System.getProperty(STS_ENDPOINT_OVERRIDE_SYSTEM_PROPERTY);
                    builder = region != null && stsEndpoint != null ? (AWSSecurityTokenServiceClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(stsEndpoint, region)) : (AWSSecurityTokenServiceClientBuilder)builder.withRegion(region);
                    if (basicCredentials != null) {
                        builder = (AWSSecurityTokenServiceClientBuilder)builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)basicCredentials));
                    }
                    return (AWSSecurityTokenService)builder.build();
                });
            }
            if (irsaCredentials.getIdentityTokenFile() == null) {
                return new PrivilegedSTSAssumeRoleSessionCredentialsProvider<STSAssumeRoleSessionCredentialsProvider>(securityTokenService, new STSAssumeRoleSessionCredentialsProvider.Builder(irsaCredentials.getRoleArn(), irsaCredentials.getRoleSessionName()).withStsClient(securityTokenService).build());
            }
            return new PrivilegedSTSAssumeRoleSessionCredentialsProvider<STSAssumeRoleWithWebIdentitySessionCredentialsProvider>(securityTokenService, new STSAssumeRoleWithWebIdentitySessionCredentialsProvider.Builder(irsaCredentials.getRoleArn(), irsaCredentials.getRoleSessionName(), irsaCredentials.getIdentityTokenFile()).withStsClient(securityTokenService).build());
        }
        if (basicCredentials != null) {
            logger.debug("Using basic key/secret credentials");
            return new AWSStaticCredentialsProvider((AWSCredentials)basicCredentials);
        }
        logger.debug("Using instance profile credentials");
        return new PrivilegedInstanceProfileCredentialsProvider();
    }

    private static S3ClientSettings.IrsaCredentials buildFromEnviroment(S3ClientSettings.IrsaCredentials defaults) {
        String roleSessionName;
        String roleArn;
        if (defaults == null) {
            return null;
        }
        String webIdentityTokenFile = defaults.getIdentityTokenFile();
        if (webIdentityTokenFile == null) {
            webIdentityTokenFile = System.getenv("AWS_WEB_IDENTITY_TOKEN_FILE");
        }
        if ((roleArn = defaults.getRoleArn()) == null) {
            roleArn = System.getenv("AWS_ROLE_ARN");
        }
        if ((roleSessionName = defaults.getRoleSessionName()) == null) {
            roleSessionName = System.getenv("AWS_ROLE_SESSION_NAME");
        }
        return new S3ClientSettings.IrsaCredentials(webIdentityTokenFile, roleArn, roleSessionName);
    }

    private synchronized void releaseCachedClients() {
        for (AmazonS3Reference clientReference : this.clientsCache.values()) {
            clientReference.decRef();
        }
        this.clientsCache = Collections.emptyMap();
        this.derivedClientSettings = Collections.emptyMap();
        IdleConnectionReaper.shutdown();
    }

    @Override
    public void close() {
        this.releaseCachedClients();
    }

    static class PrivilegedSTSAssumeRoleSessionCredentialsProvider<P extends AWSSessionCredentialsProvider & Closeable>
    implements AWSCredentialsProvider,
    Closeable {
        private final P credentials;
        private final AWSSecurityTokenService securityTokenService;

        private PrivilegedSTSAssumeRoleSessionCredentialsProvider(@Nullable AWSSecurityTokenService securityTokenService, P credentials) {
            this.securityTokenService = securityTokenService;
            this.credentials = credentials;
        }

        public AWSCredentials getCredentials() {
            return (AWSCredentials)SocketAccess.doPrivileged(() -> this.credentials.getCredentials());
        }

        public void refresh() {
            SocketAccess.doPrivilegedVoid(() -> this.credentials.refresh());
        }

        @Override
        public void close() throws IOException {
            SocketAccess.doPrivilegedIOException(() -> {
                ((Closeable)this.credentials).close();
                if (this.securityTokenService != null) {
                    this.securityTokenService.shutdown();
                }
                return null;
            });
        }
    }

    static class PrivilegedInstanceProfileCredentialsProvider
    implements AWSCredentialsProvider {
        private final AWSCredentialsProvider credentials = new EC2ContainerCredentialsProviderWrapper();

        private PrivilegedInstanceProfileCredentialsProvider() {
        }

        public AWSCredentials getCredentials() {
            return SocketAccess.doPrivileged(() -> ((AWSCredentialsProvider)this.credentials).getCredentials());
        }

        public void refresh() {
            SocketAccess.doPrivilegedVoid(() -> ((AWSCredentialsProvider)this.credentials).refresh());
        }
    }
}

