/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.config.overrides.ConfigOverrides;
import org.opensearch.performanceanalyzer.config.overrides.ConfigOverridesHelper;
import org.opensearch.performanceanalyzer.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;

public class NodeDetailsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(NodeDetailsCollector.class)).samplingInterval;
    private static final Logger LOG = LogManager.getLogger(NodeDetailsCollector.class);
    private static final int KEYS_PATH_LENGTH = 0;
    private final ConfigOverridesWrapper configOverridesWrapper;

    public NodeDetailsCollector(ConfigOverridesWrapper configOverridesWrapper) {
        super(SAMPLING_TIME_INTERVAL, "NodeDetails");
        this.configOverridesWrapper = configOverridesWrapper;
    }

    public void collectMetrics(long startTime) {
        if (OpenSearchResources.INSTANCE.getClusterService() == null || OpenSearchResources.INSTANCE.getClusterService().state() == null || OpenSearchResources.INSTANCE.getClusterService().state().nodes() == null) {
            return;
        }
        StringBuilder value = new StringBuilder();
        value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        try {
            if (this.configOverridesWrapper != null) {
                String rcaOverrides = ConfigOverridesHelper.serialize((ConfigOverrides)this.configOverridesWrapper.getCurrentClusterConfigOverrides());
                value.append(rcaOverrides);
            } else {
                LOG.warn("Overrides wrapper is null. Check NodeDetailsCollector instantiation.");
            }
        }
        catch (IOException ioe) {
            LOG.error("Unable to serialize rca config overrides.", (Throwable)ioe);
        }
        value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        if (this.configOverridesWrapper != null) {
            value.append(this.configOverridesWrapper.getLastUpdatedTimestamp());
        } else {
            value.append(0L);
        }
        value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        DiscoveryNodes discoveryNodes = OpenSearchResources.INSTANCE.getClusterService().state().nodes();
        DiscoveryNode masterNode = discoveryNodes.getMasterNode();
        Iterator discoveryNodeIterator = discoveryNodes.iterator();
        this.addMetricsToStringBuilder(discoveryNodes.getLocalNode(), value, "", masterNode);
        String localNodeID = discoveryNodes.getLocalNode().getId();
        while (discoveryNodeIterator.hasNext()) {
            this.addMetricsToStringBuilder((DiscoveryNode)discoveryNodeIterator.next(), value, localNodeID, masterNode);
        }
        this.saveMetricValues(value.toString(), startTime, new String[0]);
    }

    private void addMetricsToStringBuilder(DiscoveryNode discoveryNode, StringBuilder value, String localNodeID, DiscoveryNode masterNode) {
        if (!discoveryNode.getId().equals(localNodeID)) {
            boolean isMasterNode = discoveryNode.equals((Object)masterNode);
            value.append(new NodeDetailsStatus(discoveryNode.getId(), discoveryNode.getHostAddress(), this.getNodeRole(discoveryNode), isMasterNode).serialize()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        }
    }

    private String getNodeRole(DiscoveryNode node) {
        AllMetrics.NodeRole role = node.isDataNode() ? AllMetrics.NodeRole.DATA : (node.isMasterNode() ? AllMetrics.NodeRole.MASTER : AllMetrics.NodeRole.UNKNOWN);
        return role.toString();
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"node_metrics"});
    }

    public static class NodeDetailsStatus
    extends MetricStatus {
        private String id;
        private String hostAddress;
        private String role;
        private boolean isMasterNode;

        public NodeDetailsStatus(String id, String hostAddress, String role, boolean isMasterNode) {
            this.id = id;
            this.hostAddress = hostAddress;
            this.role = role;
            this.isMasterNode = isMasterNode;
        }

        @JsonProperty(value="ID")
        public String getID() {
            return this.id;
        }

        @JsonProperty(value="HOST_ADDRESS")
        public String getHostAddress() {
            return this.hostAddress;
        }

        @JsonProperty(value="ROLE")
        public String getRole() {
            return this.role;
        }

        @JsonProperty(value="IS_MASTER_NODE")
        public boolean getIsMasterNode() {
            return this.isMasterNode;
        }
    }
}

