/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.reader.EventProcessor;
import org.opensearch.performanceanalyzer.reader_writer_shared.Event;

public class EventDispatcher {
    private static final Logger LOG = LogManager.getLogger(EventDispatcher.class);
    private List<EventProcessor> eventProcessors = new ArrayList<EventProcessor>();

    void registerEventProcessor(EventProcessor processor) {
        this.eventProcessors.add(processor);
    }

    void initializeProcessing(long startTime, long endTime) {
        for (EventProcessor p : this.eventProcessors) {
            p.initializeProcessing(startTime, endTime);
        }
    }

    void finalizeProcessing() {
        for (EventProcessor p : this.eventProcessors) {
            p.finalizeProcessing();
        }
    }

    public void processEvent(Event event) {
        boolean eventProcessed = false;
        for (EventProcessor p : this.eventProcessors) {
            if (!p.shouldProcessEvent(event)) continue;
            p.processEvent(event);
            p.commitBatchIfRequired();
            eventProcessed = true;
            break;
        }
        if (!eventProcessed) {
            LOG.error("Event not processed - {}", (Object)event.key);
        }
    }
}

