/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.os;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.performanceanalyzer.metrics_generator.linux.LinuxCPUPagingActivityGenerator;
import org.opensearch.performanceanalyzer.os.OSGlobals;
import org.opensearch.performanceanalyzer.os.SchemaFileParser;

public final class ThreadCPU {
    private static final Logger LOGGER = LogManager.getLogger(ThreadCPU.class);
    public static final ThreadCPU INSTANCE = new ThreadCPU();
    private long scClkTck = 0L;
    private String pid = null;
    private List<String> tids = null;
    private Map<String, Map<String, Object>> tidKVMap = new HashMap<String, Map<String, Object>>();
    private Map<String, Map<String, Object>> oldtidKVMap = new HashMap<String, Map<String, Object>>();
    private long kvTimestamp = 0L;
    private long oldkvTimestamp = 0L;
    private LinuxCPUPagingActivityGenerator cpuPagingActivityMap = new LinuxCPUPagingActivityGenerator();
    private static String[] statKeys = new String[]{"pid", "comm", "state", "ppid", "pgrp", "session", "ttynr", "tpgid", "flags", "minflt", "cminflt", "majflt", "cmajflt", "utime", "stime", "cutime", "cstime", "prio", "nice", "nthreads", "itrealvalue", "starttime", "vsize", "rss", "rsslim", "startcode", "endcode", "startstack", "kstkesp", "kstkeip", "signal", "blocked", "sigignore", "sigcatch", "wchan", "nswap", "cnswap", "exitsig", "cpu", "rtprio", "schedpolicy", "bio_ticks", "vmtime", "cvmtime"};
    private static SchemaFileParser.FieldTypes[] statTypes = new SchemaFileParser.FieldTypes[]{SchemaFileParser.FieldTypes.INT, SchemaFileParser.FieldTypes.STRING, SchemaFileParser.FieldTypes.CHAR, SchemaFileParser.FieldTypes.INT, SchemaFileParser.FieldTypes.INT, SchemaFileParser.FieldTypes.INT, SchemaFileParser.FieldTypes.INT, SchemaFileParser.FieldTypes.INT, SchemaFileParser.FieldTypes.INT, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.INT, SchemaFileParser.FieldTypes.INT, SchemaFileParser.FieldTypes.INT, SchemaFileParser.FieldTypes.INT, SchemaFileParser.FieldTypes.INT, SchemaFileParser.FieldTypes.INT, SchemaFileParser.FieldTypes.INT};

    private ThreadCPU() {
        try {
            this.pid = OSGlobals.getPid();
            this.scClkTck = OSGlobals.getScClkTck();
            this.tids = OSGlobals.getTids();
        }
        catch (Exception e) {
            LOGGER.error(() -> new ParameterizedMessage("Error In Initializing ThreadCPU: {}", (Object)e.toString()), (Throwable)e);
        }
    }

    public synchronized void addSample() {
        this.tids = OSGlobals.getTids();
        this.oldtidKVMap.clear();
        this.oldtidKVMap.putAll(this.tidKVMap);
        this.tidKVMap.clear();
        this.oldkvTimestamp = this.kvTimestamp;
        this.kvTimestamp = System.currentTimeMillis();
        for (String tid : this.tids) {
            Map<String, Object> sample = new SchemaFileParser("/proc/" + this.pid + "/task/" + tid + "/stat", statKeys, statTypes, true).parse();
            this.tidKVMap.put(tid, sample);
        }
        this.calculateCPUDetails();
        this.calculatePagingActivity();
    }

    private void calculateCPUDetails() {
        if (this.oldkvTimestamp == this.kvTimestamp) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.tidKVMap.entrySet()) {
            Map<String, Object> v = entry.getValue();
            Map<String, Object> oldv = this.oldtidKVMap.get(entry.getKey());
            if (v == null || oldv == null || !v.containsKey("utime") || !oldv.containsKey("utime")) continue;
            long diff = (Long)v.getOrDefault("utime", 0L) - (Long)oldv.getOrDefault("utime", 0L) + ((Long)v.getOrDefault("stime", 0L) - (Long)oldv.getOrDefault("stime", 0L));
            double util = 1000.0 * (double)diff / (double)this.scClkTck / (double)(this.kvTimestamp - this.oldkvTimestamp);
            this.cpuPagingActivityMap.setCPUUtilization(entry.getKey(), util);
        }
    }

    private void calculatePagingActivity() {
        if (this.oldkvTimestamp == this.kvTimestamp) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.tidKVMap.entrySet()) {
            Map<String, Object> v = entry.getValue();
            Map<String, Object> oldv = this.oldtidKVMap.get(entry.getKey());
            if (v == null || oldv == null || !v.containsKey("majflt") || !oldv.containsKey("majflt")) continue;
            double majdiff = (Long)v.getOrDefault("majflt", 0L) - (Long)oldv.getOrDefault("majflt", 0L);
            double mindiff = (Long)v.getOrDefault("minflt", 0L) - (Long)oldv.getOrDefault("minflt", 0L);
            Double[] fltarr = new Double[]{majdiff /= 0.001 * (double)(this.kvTimestamp - this.oldkvTimestamp), mindiff /= 0.001 * (double)(this.kvTimestamp - this.oldkvTimestamp), (double)((Long)v.getOrDefault("rss", 0L))};
            this.cpuPagingActivityMap.setPagingActivities(entry.getKey(), fltarr);
        }
    }

    public LinuxCPUPagingActivityGenerator getCPUPagingActivity() {
        return this.cpuPagingActivityMap;
    }
}

