/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.resthandler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.observability.action.CreateObservabilityObjectAction;
import org.opensearch.observability.action.CreateObservabilityObjectRequest;
import org.opensearch.observability.action.CreateObservabilityObjectResponse;
import org.opensearch.observability.action.DeleteObservabilityObjectAction;
import org.opensearch.observability.action.DeleteObservabilityObjectRequest;
import org.opensearch.observability.action.DeleteObservabilityObjectResponse;
import org.opensearch.observability.action.GetObservabilityObjectAction;
import org.opensearch.observability.action.GetObservabilityObjectRequest;
import org.opensearch.observability.action.GetObservabilityObjectResponse;
import org.opensearch.observability.action.UpdateObservabilityObjectAction;
import org.opensearch.observability.action.UpdateObservabilityObjectRequest;
import org.opensearch.observability.action.UpdateObservabilityObjectResponse;
import org.opensearch.observability.index.ObservabilityQueryHelper;
import org.opensearch.observability.model.ObservabilityObjectType;
import org.opensearch.observability.resthandler.RestResponseToXContentListener;
import org.opensearch.observability.settings.PluginSettings;
import org.opensearch.observability.util.HelpersKt;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.sort.SortOrder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0014J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016\u00a8\u0006\u001c"}, d2={"Lorg/opensearch/observability/resthandler/ObservabilityRestHandler;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "executeDeleteRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "executeGetRequest", "executePostRequest", "executePutRequest", "getName", "", "getObjectIdSet", "", "objectId", "objectIdList", "getTypesSet", "Ljava/util/EnumSet;", "Lorg/opensearch/observability/model/ObservabilityObjectType;", "typesString", "prepareRequest", "responseParams", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "Companion", "opensearch-observability"})
public final class ObservabilityRestHandler
extends BaseRestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String OBSERVABILITY_ACTION = "observability_actions";
    @NotNull
    private static final String OBSERVABILITY_URL = "/_plugins/_observability/object";
    @NotNull
    private static final Lazy<Logger> log$delegate = org.opensearch.commons.utils.HelpersKt.logger(ObservabilityRestHandler.class);

    @NotNull
    public String getName() {
        return OBSERVABILITY_ACTION;
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.POST, OBSERVABILITY_URL), new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_observability/object/{objectId}"), new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_observability/object/{objectId}"), new RestHandler.Route(RestRequest.Method.GET, OBSERVABILITY_URL), new RestHandler.Route(RestRequest.Method.DELETE, "/_plugins/_observability/object/{objectId}"), new RestHandler.Route(RestRequest.Method.DELETE, OBSERVABILITY_URL)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected Set<String> responseParams() {
        Object[] objectArray = new String[]{"objectId", "objectIdList", "objectType", "sortField", "sortOrder", "fromIndex", "maxItems"};
        return SetsKt.setOf((Object[])objectArray);
    }

    private final BaseRestHandler.RestChannelConsumer executePostRequest(RestRequest request, NodeClient client) {
        return arg_0 -> ObservabilityRestHandler.executePostRequest$lambda-0(client, request, arg_0);
    }

    private final BaseRestHandler.RestChannelConsumer executePutRequest(RestRequest request, NodeClient client) {
        return arg_0 -> ObservabilityRestHandler.executePutRequest$lambda-1(client, request, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private final BaseRestHandler.RestChannelConsumer executeGetRequest(RestRequest request, NodeClient client) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        int n;
        String objectId = request.param("objectId");
        String objectIdListString = request.param("objectIdList");
        Set<String> objectIdList = this.getObjectIdSet(objectId, objectIdListString);
        EnumSet<ObservabilityObjectType> types = this.getTypesSet(request.param("objectType"));
        String sortField = request.param("sortField");
        String sortOrderString = request.param("sortOrder");
        SortOrder sortOrder = sortOrderString == null ? (SortOrder)null : SortOrder.fromString((String)sortOrderString);
        String string = request.param("fromIndex");
        if (string == null) {
            n = 0;
        } else {
            Integer n2 = StringsKt.toIntOrNull((String)string);
            n = n2 == null ? 0 : n2;
        }
        int fromIndex = n;
        String string2 = request.param("maxItems");
        Integer n3 = string2 == null ? null : StringsKt.toIntOrNull((String)string2);
        int maxItems = n3 == null ? PluginSettings.INSTANCE.getDefaultItemsQueryCount() : n3.intValue();
        Map map = request.params();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"request.params()");
        boolean $i$f$filter = false;
        void var15_14 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!ObservabilityQueryHelper.Companion.getFILTER_PARAMS().contains(it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(new Pair(it.getKey(), (Object)request.param((String)it.getKey())));
        }
        Map filterParams = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        ObservabilityRestHandler.Companion.getLog().info("observability:executeGetRequest idList:" + objectIdList + " types:" + types + ", from:" + fromIndex + ", maxItems:" + maxItems + ", sortField:" + sortField + ", sortOrder=" + sortOrder + ", filters=" + filterParams);
        return arg_0 -> ObservabilityRestHandler.executeGetRequest$lambda-4(client, objectIdList, types, fromIndex, maxItems, sortField, sortOrder, filterParams, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private final BaseRestHandler.RestChannelConsumer executeDeleteRequest(RestRequest request, NodeClient client) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String objectId = request.param("objectId");
        String[] stringArray = new String[]{objectId};
        Object[] objectArray = request.paramAsStringArray("objectIdList", stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"request.paramAsStringArr\u2026FIELD, arrayOf(objectId))");
        objectArray = objectArray;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var10_10 = $this$filterTo$iv$iv;
        int n = 0;
        int n2 = ((void)var10_10).length;
        while (n < n2) {
            void element$iv$iv = var10_10[n];
            ++n;
            String s = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = s;
            boolean bl2 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set objectIdSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return arg_0 -> ObservabilityRestHandler.executeDeleteRequest$lambda-6(objectIdSet, client, arg_0);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        BaseRestHandler.RestChannelConsumer restChannelConsumer;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestRequest.Method method = request.method();
        switch (method == null ? -1 : WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
            case 1: {
                restChannelConsumer = this.executePostRequest(request, client);
                break;
            }
            case 2: {
                restChannelConsumer = this.executePutRequest(request, client);
                break;
            }
            case 3: {
                restChannelConsumer = this.executeGetRequest(request, client);
                break;
            }
            case 4: {
                restChannelConsumer = this.executeDeleteRequest(request, client);
                break;
            }
            default: {
                restChannelConsumer = arg_0 -> ObservabilityRestHandler.prepareRequest$lambda-7(request, arg_0);
            }
        }
        return restChannelConsumer;
    }

    private final Set<String> getObjectIdSet(String objectId, String objectIdList) {
        Set retIds = SetsKt.emptySet();
        if (objectId != null) {
            retIds = SetsKt.setOf((Object)objectId);
        }
        if (objectIdList != null) {
            String[] stringArray = new String[]{","};
            retIds = CollectionsKt.union((Iterable)StringsKt.split$default((CharSequence)objectIdList, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Iterable)retIds);
        }
        return retIds;
    }

    private final EnumSet<ObservabilityObjectType> getTypesSet(String typesString) {
        EnumSet<ObservabilityObjectType> types = null;
        EnumSet<ObservabilityObjectType> enumSet = EnumSet.noneOf(ObservabilityObjectType.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(ObservabilityObjectType::class.java)");
        types = enumSet;
        String string = typesString;
        if (string != null) {
            String[] stringArray = new String[]{","};
            List list = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    types.add(ObservabilityObjectType.Companion.fromTagOrDefault(it));
                }
            }
        }
        return types;
    }

    private static final void executePostRequest$lambda-0(NodeClient $client, RestRequest $request, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        ActionType<CreateObservabilityObjectResponse> actionType = CreateObservabilityObjectAction.Companion.getACTION_TYPE$opensearch_observability();
        ActionRequest actionRequest = CreateObservabilityObjectRequest.Companion.parse$default(CreateObservabilityObjectRequest.Companion, HelpersKt.contentParserNextToken($request), null, 2, null);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $client.execute(actionType, actionRequest, (ActionListener)new RestResponseToXContentListener(it));
    }

    private static final void executePutRequest$lambda-1(NodeClient $client, RestRequest $request, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        ActionType<UpdateObservabilityObjectResponse> actionType = UpdateObservabilityObjectAction.Companion.getACTION_TYPE$opensearch_observability();
        ActionRequest actionRequest = UpdateObservabilityObjectRequest.Companion.parse(HelpersKt.contentParserNextToken($request), $request.param("objectId"));
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $client.execute(actionType, actionRequest, (ActionListener)new RestResponseToXContentListener(it));
    }

    private static final void executeGetRequest$lambda-4(NodeClient $client, Set $objectIdList, EnumSet $types, int $fromIndex, int $maxItems, String $sortField, SortOrder $sortOrder, Map $filterParams, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$objectIdList, (String)"$objectIdList");
        Intrinsics.checkNotNullParameter((Object)$types, (String)"$types");
        Intrinsics.checkNotNullParameter((Object)$filterParams, (String)"$filterParams");
        ActionType<GetObservabilityObjectResponse> actionType = GetObservabilityObjectAction.Companion.getACTION_TYPE$opensearch_observability();
        ActionRequest actionRequest = new GetObservabilityObjectRequest($objectIdList, $types, $fromIndex, $maxItems, $sortField, $sortOrder, $filterParams);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $client.execute(actionType, actionRequest, (ActionListener)new RestResponseToXContentListener(it));
    }

    private static final void executeDeleteRequest$lambda-6(Set $objectIdSet, NodeClient $client, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$objectIdSet, (String)"$objectIdSet");
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        if ($objectIdSet.isEmpty()) {
            it.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "either objectId or objectIdList is required"));
        } else {
            ActionType<DeleteObservabilityObjectResponse> actionType = DeleteObservabilityObjectAction.Companion.getACTION_TYPE$opensearch_observability();
            ActionRequest actionRequest = new DeleteObservabilityObjectRequest($objectIdSet);
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            $client.execute(actionType, actionRequest, (ActionListener)new RestResponseToXContentListener(it));
        }
    }

    private static final void prepareRequest$lambda-7(RestRequest $request, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        it.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, $request.method() + " is not allowed"));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/opensearch/observability/resthandler/ObservabilityRestHandler$Companion;", "", "()V", "OBSERVABILITY_ACTION", "", "OBSERVABILITY_URL", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "opensearch-observability"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RestRequest.Method.values().length];
            nArray[RestRequest.Method.POST.ordinal()] = 1;
            nArray[RestRequest.Method.PUT.ordinal()] = 2;
            nArray[RestRequest.Method.GET.ordinal()] = 3;
            nArray[RestRequest.Method.DELETE.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

