/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.index.query.xyshape;

import java.util.List;
import java.util.Locale;
import lombok.NonNull;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.XYShape;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.common.geo.ShapeRelation;
import org.opensearch.geometry.Geometry;
import org.opensearch.geometry.GeometryVisitor;
import org.opensearch.geospatial.index.mapper.xyshape.XYShapeFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;

public class XYShapeQueryProcessor {
    public Query shapeQuery(Geometry geometry, @NonNull String fieldName, @NonNull ShapeRelation relation, @NonNull GeometryVisitor<List<XYGeometry>, RuntimeException> visitor, @NonNull QueryShardContext context) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        if (visitor == null) {
            throw new NullPointerException("visitor is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (geometry == null || geometry.isEmpty()) {
            return new MatchNoDocsQuery();
        }
        this.validateIsXYShapeFieldType(fieldName, context);
        return this.getQueryFromGeometry(geometry, fieldName, relation.getLuceneRelation(), visitor);
    }

    private Query getQueryFromGeometry(Geometry geometry, String fieldName, ShapeField.QueryRelation queryRelation, GeometryVisitor<List<XYGeometry>, RuntimeException> visitor) {
        List collections = (List)geometry.visit(visitor);
        if (collections == null || collections.isEmpty()) {
            return new MatchNoDocsQuery();
        }
        return XYShape.newGeometryQuery((String)fieldName, (ShapeField.QueryRelation)queryRelation, (XYGeometry[])collections.toArray(new XYGeometry[0]));
    }

    private void validateIsXYShapeFieldType(String fieldName, QueryShardContext context) {
        MappedFieldType fieldType = context.fieldMapper(fieldName);
        if (fieldType instanceof XYShapeFieldMapper.XYShapeFieldType) {
            return;
        }
        throw new QueryShardException(context, String.format(Locale.getDefault(), "Expected %s field type for Field [ %s ] but found %s", "xy_shape", fieldName, fieldType.typeName()), new Object[0]);
    }
}

