"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceBlockedKeywords = exports.converter = exports.WINDOW = exports.TRIGGER_TYPE = exports.SELECTOR = exports.SECURITY_CONSTANTS = exports.SCHEDULE_TYPE = exports.REPORT_TYPE = exports.REPORT_STATE = exports.REPORT_DEFINITION_STATUS = exports.INTERVAL = exports.GLOBAL_BASIC_COUNTER = exports.FORMAT = exports.EXTRA_HEADERS = exports.DELIVERY_TYPE = exports.DELIVERY_CHANNEL = exports.DEFAULT_ROLLING_COUNTER = exports.DEFAULT_REPORT_HEADER = exports.DEFAULT_MAX_SIZE = exports.DATA_REPORT_CONFIG = exports.CHROMIUM_PATH = exports.CAPACITY = exports.ALLOWED_HOSTS = void 0;

var _showdown = _interopRequireDefault(require("showdown"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
let FORMAT;
exports.FORMAT = FORMAT;

(function (FORMAT) {
  FORMAT["pdf"] = "pdf";
  FORMAT["png"] = "png";
  FORMAT["csv"] = "csv";
})(FORMAT || (exports.FORMAT = FORMAT = {}));

let REPORT_STATE;
exports.REPORT_STATE = REPORT_STATE;

(function (REPORT_STATE) {
  REPORT_STATE["created"] = "Created";
  REPORT_STATE["error"] = "Error";
  REPORT_STATE["pending"] = "Pending";
  REPORT_STATE["shared"] = "Shared";
})(REPORT_STATE || (exports.REPORT_STATE = REPORT_STATE = {}));

let REPORT_DEFINITION_STATUS;
exports.REPORT_DEFINITION_STATUS = REPORT_DEFINITION_STATUS;

(function (REPORT_DEFINITION_STATUS) {
  REPORT_DEFINITION_STATUS["active"] = "Active";
  REPORT_DEFINITION_STATUS["disabled"] = "Disabled";
})(REPORT_DEFINITION_STATUS || (exports.REPORT_DEFINITION_STATUS = REPORT_DEFINITION_STATUS = {}));

let DELIVERY_CHANNEL;
exports.DELIVERY_CHANNEL = DELIVERY_CHANNEL;

(function (DELIVERY_CHANNEL) {
  DELIVERY_CHANNEL["email"] = "Email";
  DELIVERY_CHANNEL["slack"] = "Slack";
  DELIVERY_CHANNEL["chime"] = "Chime";
  DELIVERY_CHANNEL["opensearchDashboards"] = "OpenSearch Dashboards user";
})(DELIVERY_CHANNEL || (exports.DELIVERY_CHANNEL = DELIVERY_CHANNEL = {}));

let SCHEDULE_TYPE;
exports.SCHEDULE_TYPE = SCHEDULE_TYPE;

(function (SCHEDULE_TYPE) {
  SCHEDULE_TYPE["recurring"] = "Recurring";
  SCHEDULE_TYPE["cron"] = "Cron based";
})(SCHEDULE_TYPE || (exports.SCHEDULE_TYPE = SCHEDULE_TYPE = {}));

let REPORT_TYPE;
exports.REPORT_TYPE = REPORT_TYPE;

(function (REPORT_TYPE) {
  REPORT_TYPE["savedSearch"] = "Saved search";
  REPORT_TYPE["dashboard"] = "Dashboard";
  REPORT_TYPE["visualization"] = "Visualization";
  REPORT_TYPE["notebook"] = "Notebook";
})(REPORT_TYPE || (exports.REPORT_TYPE = REPORT_TYPE = {}));

let DATA_REPORT_CONFIG;
exports.DATA_REPORT_CONFIG = DATA_REPORT_CONFIG;

(function (DATA_REPORT_CONFIG) {
  DATA_REPORT_CONFIG["excelDateFormat"] = "MM/DD/YYYY h:mm:ss.SSS a";
})(DATA_REPORT_CONFIG || (exports.DATA_REPORT_CONFIG = DATA_REPORT_CONFIG = {}));

let TRIGGER_TYPE;
exports.TRIGGER_TYPE = TRIGGER_TYPE;

(function (TRIGGER_TYPE) {
  TRIGGER_TYPE["schedule"] = "Schedule";
  TRIGGER_TYPE["onDemand"] = "On demand";
})(TRIGGER_TYPE || (exports.TRIGGER_TYPE = TRIGGER_TYPE = {}));

let DELIVERY_TYPE;
exports.DELIVERY_TYPE = DELIVERY_TYPE;

(function (DELIVERY_TYPE) {
  DELIVERY_TYPE["opensearchDashboardsUser"] = "OpenSearch Dashboards user";
  DELIVERY_TYPE["channel"] = "Channel";
})(DELIVERY_TYPE || (exports.DELIVERY_TYPE = DELIVERY_TYPE = {}));

let SELECTOR; // https://www.elastic.co/guide/en/elasticsearch/reference/6.8/search-request-from-size.html

exports.SELECTOR = SELECTOR;

(function (SELECTOR) {
  SELECTOR["dashboard"] = "#dashboardViewport";
  SELECTOR["visualization"] = ".visEditor__content";
  SELECTOR["notebook"] = ".euiPageBody";
})(SELECTOR || (exports.SELECTOR = SELECTOR = {}));

const DEFAULT_MAX_SIZE = 10000;
exports.DEFAULT_MAX_SIZE = DEFAULT_MAX_SIZE;
const DEFAULT_REPORT_HEADER = '<h1>OpenSearch Dashboards Reports</h1>';
exports.DEFAULT_REPORT_HEADER = DEFAULT_REPORT_HEADER;
const SECURITY_CONSTANTS = {
  TENANT_LOCAL_STORAGE_KEY: 'opendistro::security::tenant::show_popup'
};
exports.SECURITY_CONSTANTS = SECURITY_CONSTANTS;
const EXTRA_HEADERS = ['cookie', 'x-proxy-user', 'x-proxy-roles', 'x-forwarded-for'];
exports.EXTRA_HEADERS = EXTRA_HEADERS;
const converter = new _showdown.default.Converter({
  tables: true,
  simplifiedAutoLink: true,
  strikethrough: true,
  tasklists: true,
  noHeaderId: true
});
exports.converter = converter;
const BLOCKED_KEYWORD = 'BLOCKED_KEYWORD';
const ipv4Regex = /(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?):([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])/g;
const ipv6Regex = /(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))/g;
const localhostRegex = /localhost:([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])/g;
const iframeRegex = /iframe/g;
const ALLOWED_HOSTS = /^(0|0.0.0.0|127.0.0.1|localhost|(.*\.)?(opensearch.org|aws.a2z.com))$/;
exports.ALLOWED_HOSTS = ALLOWED_HOSTS;

const replaceBlockedKeywords = htmlString => {
  // replace <ipv4>:<port>
  htmlString = htmlString.replace(ipv4Regex, BLOCKED_KEYWORD); // replace ipv6 addresses

  htmlString = htmlString.replace(ipv6Regex, BLOCKED_KEYWORD); // replace iframe keyword

  htmlString = htmlString.replace(iframeRegex, BLOCKED_KEYWORD); // replace localhost:<port>

  htmlString = htmlString.replace(localhostRegex, BLOCKED_KEYWORD);
  return htmlString;
};

exports.replaceBlockedKeywords = replaceBlockedKeywords;
const CHROMIUM_PATH = `${__dirname}/../../../.chromium/headless_shell`;
/**
 * Metric constants
 */

exports.CHROMIUM_PATH = CHROMIUM_PATH;
const WINDOW = 3600;
exports.WINDOW = WINDOW;
const INTERVAL = 60;
exports.INTERVAL = INTERVAL;
const CAPACITY = WINDOW / INTERVAL * 2;
exports.CAPACITY = CAPACITY;
const GLOBAL_BASIC_COUNTER = {
  report: {
    create: {
      total: 0
    },
    create_from_definition: {
      total: 0
    },
    download: {
      total: 0
    },
    list: {
      total: 0
    },
    info: {
      total: 0
    }
  },
  report_definition: {
    create: {
      total: 0
    },
    list: {
      total: 0
    },
    info: {
      total: 0
    },
    update: {
      total: 0
    },
    delete: {
      total: 0
    }
  },
  report_source: {
    list: {
      total: 0
    }
  },
  dashboard: {
    pdf: {
      download: {
        total: 0
      }
    },
    png: {
      download: {
        total: 0
      }
    }
  },
  visualization: {
    pdf: {
      download: {
        total: 0
      }
    },
    png: {
      download: {
        total: 0
      }
    }
  },
  notebook: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  saved_search: {
    csv: {
      download: {
        total: 0
      }
    }
  }
};
exports.GLOBAL_BASIC_COUNTER = GLOBAL_BASIC_COUNTER;
const DEFAULT_ROLLING_COUNTER = {
  report: {
    create: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    create_from_definition: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    download: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    list: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    info: {
      count: 0,
      system_error: 0,
      user_error: 0
    }
  },
  report_definition: {
    create: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    list: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    info: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    update: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    delete: {
      count: 0,
      system_error: 0,
      user_error: 0
    }
  },
  report_source: {
    list: {
      count: 0,
      system_error: 0,
      user_error: 0
    }
  },
  dashboard: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  visualization: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  notebook: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  saved_search: {
    csv: {
      download: {
        count: 0
      }
    }
  }
};
exports.DEFAULT_ROLLING_COUNTER = DEFAULT_ROLLING_COUNTER;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbnN0YW50cy50cyJdLCJuYW1lcyI6WyJGT1JNQVQiLCJSRVBPUlRfU1RBVEUiLCJSRVBPUlRfREVGSU5JVElPTl9TVEFUVVMiLCJERUxJVkVSWV9DSEFOTkVMIiwiU0NIRURVTEVfVFlQRSIsIlJFUE9SVF9UWVBFIiwiREFUQV9SRVBPUlRfQ09ORklHIiwiVFJJR0dFUl9UWVBFIiwiREVMSVZFUllfVFlQRSIsIlNFTEVDVE9SIiwiREVGQVVMVF9NQVhfU0laRSIsIkRFRkFVTFRfUkVQT1JUX0hFQURFUiIsIlNFQ1VSSVRZX0NPTlNUQU5UUyIsIlRFTkFOVF9MT0NBTF9TVE9SQUdFX0tFWSIsIkVYVFJBX0hFQURFUlMiLCJjb252ZXJ0ZXIiLCJTaG93ZG93biIsIkNvbnZlcnRlciIsInRhYmxlcyIsInNpbXBsaWZpZWRBdXRvTGluayIsInN0cmlrZXRocm91Z2giLCJ0YXNrbGlzdHMiLCJub0hlYWRlcklkIiwiQkxPQ0tFRF9LRVlXT1JEIiwiaXB2NFJlZ2V4IiwiaXB2NlJlZ2V4IiwibG9jYWxob3N0UmVnZXgiLCJpZnJhbWVSZWdleCIsIkFMTE9XRURfSE9TVFMiLCJyZXBsYWNlQmxvY2tlZEtleXdvcmRzIiwiaHRtbFN0cmluZyIsInJlcGxhY2UiLCJDSFJPTUlVTV9QQVRIIiwiX19kaXJuYW1lIiwiV0lORE9XIiwiSU5URVJWQUwiLCJDQVBBQ0lUWSIsIkdMT0JBTF9CQVNJQ19DT1VOVEVSIiwicmVwb3J0IiwiY3JlYXRlIiwidG90YWwiLCJjcmVhdGVfZnJvbV9kZWZpbml0aW9uIiwiZG93bmxvYWQiLCJsaXN0IiwiaW5mbyIsInJlcG9ydF9kZWZpbml0aW9uIiwidXBkYXRlIiwiZGVsZXRlIiwicmVwb3J0X3NvdXJjZSIsImRhc2hib2FyZCIsInBkZiIsInBuZyIsInZpc3VhbGl6YXRpb24iLCJub3RlYm9vayIsImNvdW50Iiwic2F2ZWRfc2VhcmNoIiwiY3N2IiwiREVGQVVMVF9ST0xMSU5HX0NPVU5URVIiLCJzeXN0ZW1fZXJyb3IiLCJ1c2VyX2Vycm9yIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBTUE7Ozs7QUFOQTtBQUNBO0FBQ0E7QUFDQTtJQUtZQSxNOzs7V0FBQUEsTTtBQUFBQSxFQUFBQSxNO0FBQUFBLEVBQUFBLE07QUFBQUEsRUFBQUEsTTtHQUFBQSxNLHNCQUFBQSxNOztJQU1BQyxZOzs7V0FBQUEsWTtBQUFBQSxFQUFBQSxZO0FBQUFBLEVBQUFBLFk7QUFBQUEsRUFBQUEsWTtBQUFBQSxFQUFBQSxZO0dBQUFBLFksNEJBQUFBLFk7O0lBT0FDLHdCOzs7V0FBQUEsd0I7QUFBQUEsRUFBQUEsd0I7QUFBQUEsRUFBQUEsd0I7R0FBQUEsd0Isd0NBQUFBLHdCOztJQUtBQyxnQjs7O1dBQUFBLGdCO0FBQUFBLEVBQUFBLGdCO0FBQUFBLEVBQUFBLGdCO0FBQUFBLEVBQUFBLGdCO0FBQUFBLEVBQUFBLGdCO0dBQUFBLGdCLGdDQUFBQSxnQjs7SUFPQUMsYTs7O1dBQUFBLGE7QUFBQUEsRUFBQUEsYTtBQUFBQSxFQUFBQSxhO0dBQUFBLGEsNkJBQUFBLGE7O0lBS0FDLFc7OztXQUFBQSxXO0FBQUFBLEVBQUFBLFc7QUFBQUEsRUFBQUEsVztBQUFBQSxFQUFBQSxXO0FBQUFBLEVBQUFBLFc7R0FBQUEsVywyQkFBQUEsVzs7SUFPQUMsa0I7OztXQUFBQSxrQjtBQUFBQSxFQUFBQSxrQjtHQUFBQSxrQixrQ0FBQUEsa0I7O0lBSUFDLFk7OztXQUFBQSxZO0FBQUFBLEVBQUFBLFk7QUFBQUEsRUFBQUEsWTtHQUFBQSxZLDRCQUFBQSxZOztJQUtBQyxhOzs7V0FBQUEsYTtBQUFBQSxFQUFBQSxhO0FBQUFBLEVBQUFBLGE7R0FBQUEsYSw2QkFBQUEsYTs7SUFLQUMsUSxFQU1aOzs7O1dBTllBLFE7QUFBQUEsRUFBQUEsUTtBQUFBQSxFQUFBQSxRO0FBQUFBLEVBQUFBLFE7R0FBQUEsUSx3QkFBQUEsUTs7QUFPTCxNQUFNQyxnQkFBZ0IsR0FBRyxLQUF6Qjs7QUFFQSxNQUFNQyxxQkFBcUIsR0FBRyx3Q0FBOUI7O0FBRUEsTUFBTUMsa0JBQWtCLEdBQUc7QUFDaENDLEVBQUFBLHdCQUF3QixFQUFFO0FBRE0sQ0FBM0I7O0FBSUEsTUFBTUMsYUFBYSxHQUFHLENBQzNCLFFBRDJCLEVBRTNCLGNBRjJCLEVBRzNCLGVBSDJCLEVBSTNCLGlCQUoyQixDQUF0Qjs7QUFPQSxNQUFNQyxTQUFTLEdBQUcsSUFBSUMsa0JBQVNDLFNBQWIsQ0FBdUI7QUFDOUNDLEVBQUFBLE1BQU0sRUFBRSxJQURzQztBQUU5Q0MsRUFBQUEsa0JBQWtCLEVBQUUsSUFGMEI7QUFHOUNDLEVBQUFBLGFBQWEsRUFBRSxJQUgrQjtBQUk5Q0MsRUFBQUEsU0FBUyxFQUFFLElBSm1DO0FBSzlDQyxFQUFBQSxVQUFVLEVBQUU7QUFMa0MsQ0FBdkIsQ0FBbEI7O0FBUVAsTUFBTUMsZUFBZSxHQUFHLGlCQUF4QjtBQUNBLE1BQU1DLFNBQVMsR0FBRyx3UEFBbEI7QUFDQSxNQUFNQyxTQUFTLEdBQUcsc3BCQUFsQjtBQUNBLE1BQU1DLGNBQWMsR0FBRyxtR0FBdkI7QUFDQSxNQUFNQyxXQUFXLEdBQUcsU0FBcEI7QUFFTyxNQUFNQyxhQUFhLEdBQUcsdUVBQXRCOzs7QUFFQSxNQUFNQyxzQkFBc0IsR0FBSUMsVUFBRCxJQUF3QjtBQUM1RDtBQUNBQSxFQUFBQSxVQUFVLEdBQUdBLFVBQVUsQ0FBQ0MsT0FBWCxDQUFtQlAsU0FBbkIsRUFBOEJELGVBQTlCLENBQWIsQ0FGNEQsQ0FHNUQ7O0FBQ0FPLEVBQUFBLFVBQVUsR0FBR0EsVUFBVSxDQUFDQyxPQUFYLENBQW1CTixTQUFuQixFQUE4QkYsZUFBOUIsQ0FBYixDQUo0RCxDQUs1RDs7QUFDQU8sRUFBQUEsVUFBVSxHQUFHQSxVQUFVLENBQUNDLE9BQVgsQ0FBbUJKLFdBQW5CLEVBQWdDSixlQUFoQyxDQUFiLENBTjRELENBTzVEOztBQUNBTyxFQUFBQSxVQUFVLEdBQUdBLFVBQVUsQ0FBQ0MsT0FBWCxDQUFtQkwsY0FBbkIsRUFBbUNILGVBQW5DLENBQWI7QUFDQSxTQUFPTyxVQUFQO0FBQ0QsQ0FWTTs7O0FBWUEsTUFBTUUsYUFBYSxHQUFJLEdBQUVDLFNBQVUsb0NBQW5DO0FBR1A7QUFDQTtBQUNBOzs7QUFDTyxNQUFNQyxNQUFNLEdBQUcsSUFBZjs7QUFDQSxNQUFNQyxRQUFRLEdBQUcsRUFBakI7O0FBQ0EsTUFBTUMsUUFBUSxHQUFJRixNQUFNLEdBQUdDLFFBQVYsR0FBc0IsQ0FBdkM7O0FBRUEsTUFBTUUsb0JBQWtDLEdBQUc7QUFDaERDLEVBQUFBLE1BQU0sRUFBRTtBQUNOQyxJQUFBQSxNQUFNLEVBQUU7QUFDTkMsTUFBQUEsS0FBSyxFQUFFO0FBREQsS0FERjtBQUlOQyxJQUFBQSxzQkFBc0IsRUFBRTtBQUN0QkQsTUFBQUEsS0FBSyxFQUFFO0FBRGUsS0FKbEI7QUFPTkUsSUFBQUEsUUFBUSxFQUFFO0FBQ1JGLE1BQUFBLEtBQUssRUFBRTtBQURDLEtBUEo7QUFVTkcsSUFBQUEsSUFBSSxFQUFFO0FBQ0pILE1BQUFBLEtBQUssRUFBRTtBQURILEtBVkE7QUFhTkksSUFBQUEsSUFBSSxFQUFFO0FBQ0pKLE1BQUFBLEtBQUssRUFBRTtBQURIO0FBYkEsR0FEd0M7QUFrQmhESyxFQUFBQSxpQkFBaUIsRUFBRTtBQUNqQk4sSUFBQUEsTUFBTSxFQUFFO0FBQ05DLE1BQUFBLEtBQUssRUFBRTtBQURELEtBRFM7QUFJakJHLElBQUFBLElBQUksRUFBRTtBQUNKSCxNQUFBQSxLQUFLLEVBQUU7QUFESCxLQUpXO0FBT2pCSSxJQUFBQSxJQUFJLEVBQUU7QUFDSkosTUFBQUEsS0FBSyxFQUFFO0FBREgsS0FQVztBQVVqQk0sSUFBQUEsTUFBTSxFQUFFO0FBQ05OLE1BQUFBLEtBQUssRUFBRTtBQURELEtBVlM7QUFhakJPLElBQUFBLE1BQU0sRUFBRTtBQUNOUCxNQUFBQSxLQUFLLEVBQUU7QUFERDtBQWJTLEdBbEI2QjtBQW1DaERRLEVBQUFBLGFBQWEsRUFBRTtBQUNiTCxJQUFBQSxJQUFJLEVBQUU7QUFDSkgsTUFBQUEsS0FBSyxFQUFFO0FBREg7QUFETyxHQW5DaUM7QUF3Q2hEUyxFQUFBQSxTQUFTLEVBQUU7QUFDVEMsSUFBQUEsR0FBRyxFQUFFO0FBQ0hSLE1BQUFBLFFBQVEsRUFBRTtBQUNSRixRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQLEtBREk7QUFNVFcsSUFBQUEsR0FBRyxFQUFFO0FBQ0hULE1BQUFBLFFBQVEsRUFBRTtBQUNSRixRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQO0FBTkksR0F4Q3FDO0FBb0RoRFksRUFBQUEsYUFBYSxFQUFFO0FBQ2JGLElBQUFBLEdBQUcsRUFBRTtBQUNIUixNQUFBQSxRQUFRLEVBQUU7QUFDUkYsUUFBQUEsS0FBSyxFQUFFO0FBREM7QUFEUCxLQURRO0FBTWJXLElBQUFBLEdBQUcsRUFBRTtBQUNIVCxNQUFBQSxRQUFRLEVBQUU7QUFDUkYsUUFBQUEsS0FBSyxFQUFFO0FBREM7QUFEUDtBQU5RLEdBcERpQztBQWdFaERhLEVBQUFBLFFBQVEsRUFBRTtBQUNSSCxJQUFBQSxHQUFHLEVBQUU7QUFDSFIsTUFBQUEsUUFBUSxFQUFFO0FBQ1JZLFFBQUFBLEtBQUssRUFBRTtBQURDO0FBRFAsS0FERztBQU1SSCxJQUFBQSxHQUFHLEVBQUU7QUFDSFQsTUFBQUEsUUFBUSxFQUFFO0FBQ1JZLFFBQUFBLEtBQUssRUFBRTtBQURDO0FBRFA7QUFORyxHQWhFc0M7QUE0RWhEQyxFQUFBQSxZQUFZLEVBQUU7QUFDWkMsSUFBQUEsR0FBRyxFQUFFO0FBQ0hkLE1BQUFBLFFBQVEsRUFBRTtBQUNSRixRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQO0FBRE87QUE1RWtDLENBQTNDOztBQXFGQSxNQUFNaUIsdUJBQXFDLEdBQUc7QUFDbkRuQixFQUFBQSxNQUFNLEVBQUU7QUFDTkMsSUFBQUEsTUFBTSxFQUFFO0FBQ05lLE1BQUFBLEtBQUssRUFBRSxDQUREO0FBRU5JLE1BQUFBLFlBQVksRUFBRSxDQUZSO0FBR05DLE1BQUFBLFVBQVUsRUFBRTtBQUhOLEtBREY7QUFNTmxCLElBQUFBLHNCQUFzQixFQUFFO0FBQ3RCYSxNQUFBQSxLQUFLLEVBQUUsQ0FEZTtBQUV0QkksTUFBQUEsWUFBWSxFQUFFLENBRlE7QUFHdEJDLE1BQUFBLFVBQVUsRUFBRTtBQUhVLEtBTmxCO0FBV05qQixJQUFBQSxRQUFRLEVBQUU7QUFDUlksTUFBQUEsS0FBSyxFQUFFLENBREM7QUFFUkksTUFBQUEsWUFBWSxFQUFFLENBRk47QUFHUkMsTUFBQUEsVUFBVSxFQUFFO0FBSEosS0FYSjtBQWdCTmhCLElBQUFBLElBQUksRUFBRTtBQUNKVyxNQUFBQSxLQUFLLEVBQUUsQ0FESDtBQUVKSSxNQUFBQSxZQUFZLEVBQUUsQ0FGVjtBQUdKQyxNQUFBQSxVQUFVLEVBQUU7QUFIUixLQWhCQTtBQXFCTmYsSUFBQUEsSUFBSSxFQUFFO0FBQ0pVLE1BQUFBLEtBQUssRUFBRSxDQURIO0FBRUpJLE1BQUFBLFlBQVksRUFBRSxDQUZWO0FBR0pDLE1BQUFBLFVBQVUsRUFBRTtBQUhSO0FBckJBLEdBRDJDO0FBNEJuRGQsRUFBQUEsaUJBQWlCLEVBQUU7QUFDakJOLElBQUFBLE1BQU0sRUFBRTtBQUNOZSxNQUFBQSxLQUFLLEVBQUUsQ0FERDtBQUVOSSxNQUFBQSxZQUFZLEVBQUUsQ0FGUjtBQUdOQyxNQUFBQSxVQUFVLEVBQUU7QUFITixLQURTO0FBTWpCaEIsSUFBQUEsSUFBSSxFQUFFO0FBQ0pXLE1BQUFBLEtBQUssRUFBRSxDQURIO0FBRUpJLE1BQUFBLFlBQVksRUFBRSxDQUZWO0FBR0pDLE1BQUFBLFVBQVUsRUFBRTtBQUhSLEtBTlc7QUFXakJmLElBQUFBLElBQUksRUFBRTtBQUNKVSxNQUFBQSxLQUFLLEVBQUUsQ0FESDtBQUVKSSxNQUFBQSxZQUFZLEVBQUUsQ0FGVjtBQUdKQyxNQUFBQSxVQUFVLEVBQUU7QUFIUixLQVhXO0FBZ0JqQmIsSUFBQUEsTUFBTSxFQUFFO0FBQ05RLE1BQUFBLEtBQUssRUFBRSxDQUREO0FBRU5JLE1BQUFBLFlBQVksRUFBRSxDQUZSO0FBR05DLE1BQUFBLFVBQVUsRUFBRTtBQUhOLEtBaEJTO0FBcUJqQlosSUFBQUEsTUFBTSxFQUFFO0FBQ05PLE1BQUFBLEtBQUssRUFBRSxDQUREO0FBRU5JLE1BQUFBLFlBQVksRUFBRSxDQUZSO0FBR05DLE1BQUFBLFVBQVUsRUFBRTtBQUhOO0FBckJTLEdBNUJnQztBQXVEbkRYLEVBQUFBLGFBQWEsRUFBRTtBQUNiTCxJQUFBQSxJQUFJLEVBQUU7QUFDSlcsTUFBQUEsS0FBSyxFQUFFLENBREg7QUFFSkksTUFBQUEsWUFBWSxFQUFFLENBRlY7QUFHSkMsTUFBQUEsVUFBVSxFQUFFO0FBSFI7QUFETyxHQXZEb0M7QUE4RG5EVixFQUFBQSxTQUFTLEVBQUU7QUFDVEMsSUFBQUEsR0FBRyxFQUFFO0FBQ0hSLE1BQUFBLFFBQVEsRUFBRTtBQUNSWSxRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQLEtBREk7QUFNVEgsSUFBQUEsR0FBRyxFQUFFO0FBQ0hULE1BQUFBLFFBQVEsRUFBRTtBQUNSWSxRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQO0FBTkksR0E5RHdDO0FBMEVuREYsRUFBQUEsYUFBYSxFQUFFO0FBQ2JGLElBQUFBLEdBQUcsRUFBRTtBQUNIUixNQUFBQSxRQUFRLEVBQUU7QUFDUlksUUFBQUEsS0FBSyxFQUFFO0FBREM7QUFEUCxLQURRO0FBTWJILElBQUFBLEdBQUcsRUFBRTtBQUNIVCxNQUFBQSxRQUFRLEVBQUU7QUFDUlksUUFBQUEsS0FBSyxFQUFFO0FBREM7QUFEUDtBQU5RLEdBMUVvQztBQXNGbkRELEVBQUFBLFFBQVEsRUFBRTtBQUNSSCxJQUFBQSxHQUFHLEVBQUU7QUFDSFIsTUFBQUEsUUFBUSxFQUFFO0FBQ1JZLFFBQUFBLEtBQUssRUFBRTtBQURDO0FBRFAsS0FERztBQU1SSCxJQUFBQSxHQUFHLEVBQUU7QUFDSFQsTUFBQUEsUUFBUSxFQUFFO0FBQ1JZLFFBQUFBLEtBQUssRUFBRTtBQURDO0FBRFA7QUFORyxHQXRGeUM7QUFrR25EQyxFQUFBQSxZQUFZLEVBQUU7QUFDWkMsSUFBQUEsR0FBRyxFQUFFO0FBQ0hkLE1BQUFBLFFBQVEsRUFBRTtBQUNSWSxRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQO0FBRE87QUFsR3FDLENBQTlDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBDb3VudGVyc1R5cGUgfSBmcm9tICcuL3R5cGVzJztcbmltcG9ydCBTaG93ZG93biBmcm9tICdzaG93ZG93bic7XG5cbmV4cG9ydCBlbnVtIEZPUk1BVCB7XG4gIHBkZiA9ICdwZGYnLFxuICBwbmcgPSAncG5nJyxcbiAgY3N2ID0gJ2NzdicsXG59XG5cbmV4cG9ydCBlbnVtIFJFUE9SVF9TVEFURSB7XG4gIGNyZWF0ZWQgPSAnQ3JlYXRlZCcsXG4gIGVycm9yID0gJ0Vycm9yJyxcbiAgcGVuZGluZyA9ICdQZW5kaW5nJyxcbiAgc2hhcmVkID0gJ1NoYXJlZCcsXG59XG5cbmV4cG9ydCBlbnVtIFJFUE9SVF9ERUZJTklUSU9OX1NUQVRVUyB7XG4gIGFjdGl2ZSA9ICdBY3RpdmUnLFxuICBkaXNhYmxlZCA9ICdEaXNhYmxlZCcsXG59XG5cbmV4cG9ydCBlbnVtIERFTElWRVJZX0NIQU5ORUwge1xuICBlbWFpbCA9ICdFbWFpbCcsXG4gIHNsYWNrID0gJ1NsYWNrJyxcbiAgY2hpbWUgPSAnQ2hpbWUnLFxuICBvcGVuc2VhcmNoRGFzaGJvYXJkcyA9ICdPcGVuU2VhcmNoIERhc2hib2FyZHMgdXNlcicsXG59XG5cbmV4cG9ydCBlbnVtIFNDSEVEVUxFX1RZUEUge1xuICByZWN1cnJpbmcgPSAnUmVjdXJyaW5nJyxcbiAgY3JvbiA9ICdDcm9uIGJhc2VkJyxcbn1cblxuZXhwb3J0IGVudW0gUkVQT1JUX1RZUEUge1xuICBzYXZlZFNlYXJjaCA9ICdTYXZlZCBzZWFyY2gnLFxuICBkYXNoYm9hcmQgPSAnRGFzaGJvYXJkJyxcbiAgdmlzdWFsaXphdGlvbiA9ICdWaXN1YWxpemF0aW9uJyxcbiAgbm90ZWJvb2sgPSAnTm90ZWJvb2snLFxufVxuXG5leHBvcnQgZW51bSBEQVRBX1JFUE9SVF9DT05GSUcge1xuICBleGNlbERhdGVGb3JtYXQgPSAnTU0vREQvWVlZWSBoOm1tOnNzLlNTUyBhJyxcbn1cblxuZXhwb3J0IGVudW0gVFJJR0dFUl9UWVBFIHtcbiAgc2NoZWR1bGUgPSAnU2NoZWR1bGUnLFxuICBvbkRlbWFuZCA9ICdPbiBkZW1hbmQnLFxufVxuXG5leHBvcnQgZW51bSBERUxJVkVSWV9UWVBFIHtcbiAgb3BlbnNlYXJjaERhc2hib2FyZHNVc2VyID0gJ09wZW5TZWFyY2ggRGFzaGJvYXJkcyB1c2VyJyxcbiAgY2hhbm5lbCA9ICdDaGFubmVsJyxcbn1cblxuZXhwb3J0IGVudW0gU0VMRUNUT1Ige1xuICBkYXNoYm9hcmQgPSAnI2Rhc2hib2FyZFZpZXdwb3J0JyxcbiAgdmlzdWFsaXphdGlvbiA9ICcudmlzRWRpdG9yX19jb250ZW50JyxcbiAgbm90ZWJvb2sgPSAnLmV1aVBhZ2VCb2R5Jyxcbn1cblxuLy8gaHR0cHM6Ly93d3cuZWxhc3RpYy5jby9ndWlkZS9lbi9lbGFzdGljc2VhcmNoL3JlZmVyZW5jZS82Ljgvc2VhcmNoLXJlcXVlc3QtZnJvbS1zaXplLmh0bWxcbmV4cG9ydCBjb25zdCBERUZBVUxUX01BWF9TSVpFID0gMTAwMDA7XG5cbmV4cG9ydCBjb25zdCBERUZBVUxUX1JFUE9SVF9IRUFERVIgPSAnPGgxPk9wZW5TZWFyY2ggRGFzaGJvYXJkcyBSZXBvcnRzPC9oMT4nO1xuXG5leHBvcnQgY29uc3QgU0VDVVJJVFlfQ09OU1RBTlRTID0ge1xuICBURU5BTlRfTE9DQUxfU1RPUkFHRV9LRVk6ICdvcGVuZGlzdHJvOjpzZWN1cml0eTo6dGVuYW50OjpzaG93X3BvcHVwJyxcbn07XG5cbmV4cG9ydCBjb25zdCBFWFRSQV9IRUFERVJTID0gW1xuICAnY29va2llJyxcbiAgJ3gtcHJveHktdXNlcicsXG4gICd4LXByb3h5LXJvbGVzJyxcbiAgJ3gtZm9yd2FyZGVkLWZvcicsXG5dO1xuXG5leHBvcnQgY29uc3QgY29udmVydGVyID0gbmV3IFNob3dkb3duLkNvbnZlcnRlcih7XG4gIHRhYmxlczogdHJ1ZSxcbiAgc2ltcGxpZmllZEF1dG9MaW5rOiB0cnVlLFxuICBzdHJpa2V0aHJvdWdoOiB0cnVlLFxuICB0YXNrbGlzdHM6IHRydWUsXG4gIG5vSGVhZGVySWQ6IHRydWUsXG59KTtcblxuY29uc3QgQkxPQ0tFRF9LRVlXT1JEID0gJ0JMT0NLRURfS0VZV09SRCc7XG5jb25zdCBpcHY0UmVnZXggPSAvKDI1WzAtNV18MlswLTRdWzAtOV18WzAxXT9bMC05XVswLTldPylcXC4oMjVbMC01XXwyWzAtNF1bMC05XXxbMDFdP1swLTldWzAtOV0/KVxcLigyNVswLTVdfDJbMC00XVswLTldfFswMV0/WzAtOV1bMC05XT8pXFwuKDI1WzAtNV18MlswLTRdWzAtOV18WzAxXT9bMC05XVswLTldPyk6KFsxLTldWzAtOV17MCwzfXxbMS01XVswLTldezR9fDZbMC00XVswLTldezN9fDY1WzAtNF1bMC05XXsyfXw2NTVbMC0yXVswLTldfDY1NTNbMC01XSkvZ1xuY29uc3QgaXB2NlJlZ2V4ID0gLygoWzAtOWEtZkEtRl17MSw0fTopezcsN31bMC05YS1mQS1GXXsxLDR9fChbMC05YS1mQS1GXXsxLDR9Oil7MSw3fTp8KFswLTlhLWZBLUZdezEsNH06KXsxLDZ9OlswLTlhLWZBLUZdezEsNH18KFswLTlhLWZBLUZdezEsNH06KXsxLDV9KDpbMC05YS1mQS1GXXsxLDR9KXsxLDJ9fChbMC05YS1mQS1GXXsxLDR9Oil7MSw0fSg6WzAtOWEtZkEtRl17MSw0fSl7MSwzfXwoWzAtOWEtZkEtRl17MSw0fTopezEsM30oOlswLTlhLWZBLUZdezEsNH0pezEsNH18KFswLTlhLWZBLUZdezEsNH06KXsxLDJ9KDpbMC05YS1mQS1GXXsxLDR9KXsxLDV9fFswLTlhLWZBLUZdezEsNH06KCg6WzAtOWEtZkEtRl17MSw0fSl7MSw2fSl8OigoOlswLTlhLWZBLUZdezEsNH0pezEsN318Oil8ZmU4MDooOlswLTlhLWZBLUZdezAsNH0pezAsNH0lWzAtOWEtekEtWl17MSx9fDo6KGZmZmYoOjB7MSw0fSl7MCwxfTopezAsMX0oKDI1WzAtNV18KDJbMC00XXwxezAsMX1bMC05XSl7MCwxfVswLTldKVxcLil7MywzfSgyNVswLTVdfCgyWzAtNF18MXswLDF9WzAtOV0pezAsMX1bMC05XSl8KFswLTlhLWZBLUZdezEsNH06KXsxLDR9OigoMjVbMC01XXwoMlswLTRdfDF7MCwxfVswLTldKXswLDF9WzAtOV0pXFwuKXszLDN9KDI1WzAtNV18KDJbMC00XXwxezAsMX1bMC05XSl7MCwxfVswLTldKSkvZztcbmNvbnN0IGxvY2FsaG9zdFJlZ2V4ID0gL2xvY2FsaG9zdDooWzEtOV1bMC05XXswLDN9fFsxLTVdWzAtOV17NH18NlswLTRdWzAtOV17M318NjVbMC00XVswLTldezJ9fDY1NVswLTJdWzAtOV18NjU1M1swLTVdKS9nO1xuY29uc3QgaWZyYW1lUmVnZXggPSAvaWZyYW1lL2c7XG5cbmV4cG9ydCBjb25zdCBBTExPV0VEX0hPU1RTID0gL14oMHwwLjAuMC4wfDEyNy4wLjAuMXxsb2NhbGhvc3R8KC4qXFwuKT8ob3BlbnNlYXJjaC5vcmd8YXdzLmEyei5jb20pKSQvO1xuXG5leHBvcnQgY29uc3QgcmVwbGFjZUJsb2NrZWRLZXl3b3JkcyA9IChodG1sU3RyaW5nOiBzdHJpbmcpID0+IHtcbiAgLy8gcmVwbGFjZSA8aXB2ND46PHBvcnQ+XG4gIGh0bWxTdHJpbmcgPSBodG1sU3RyaW5nLnJlcGxhY2UoaXB2NFJlZ2V4LCBCTE9DS0VEX0tFWVdPUkQpO1xuICAvLyByZXBsYWNlIGlwdjYgYWRkcmVzc2VzXG4gIGh0bWxTdHJpbmcgPSBodG1sU3RyaW5nLnJlcGxhY2UoaXB2NlJlZ2V4LCBCTE9DS0VEX0tFWVdPUkQpO1xuICAvLyByZXBsYWNlIGlmcmFtZSBrZXl3b3JkXG4gIGh0bWxTdHJpbmcgPSBodG1sU3RyaW5nLnJlcGxhY2UoaWZyYW1lUmVnZXgsIEJMT0NLRURfS0VZV09SRCk7XG4gIC8vIHJlcGxhY2UgbG9jYWxob3N0Ojxwb3J0PlxuICBodG1sU3RyaW5nID0gaHRtbFN0cmluZy5yZXBsYWNlKGxvY2FsaG9zdFJlZ2V4LCBCTE9DS0VEX0tFWVdPUkQpO1xuICByZXR1cm4gaHRtbFN0cmluZztcbn1cblxuZXhwb3J0IGNvbnN0IENIUk9NSVVNX1BBVEggPSBgJHtfX2Rpcm5hbWV9Ly4uLy4uLy4uLy5jaHJvbWl1bS9oZWFkbGVzc19zaGVsbGA7XG4gIFxuXG4vKipcbiAqIE1ldHJpYyBjb25zdGFudHNcbiAqL1xuZXhwb3J0IGNvbnN0IFdJTkRPVyA9IDM2MDA7XG5leHBvcnQgY29uc3QgSU5URVJWQUwgPSA2MDtcbmV4cG9ydCBjb25zdCBDQVBBQ0lUWSA9IChXSU5ET1cgLyBJTlRFUlZBTCkgKiAyO1xuXG5leHBvcnQgY29uc3QgR0xPQkFMX0JBU0lDX0NPVU5URVI6IENvdW50ZXJzVHlwZSA9IHtcbiAgcmVwb3J0OiB7XG4gICAgY3JlYXRlOiB7XG4gICAgICB0b3RhbDogMCxcbiAgICB9LFxuICAgIGNyZWF0ZV9mcm9tX2RlZmluaXRpb246IHtcbiAgICAgIHRvdGFsOiAwLFxuICAgIH0sXG4gICAgZG93bmxvYWQ6IHtcbiAgICAgIHRvdGFsOiAwLFxuICAgIH0sXG4gICAgbGlzdDoge1xuICAgICAgdG90YWw6IDAsXG4gICAgfSxcbiAgICBpbmZvOiB7XG4gICAgICB0b3RhbDogMCxcbiAgICB9LFxuICB9LFxuICByZXBvcnRfZGVmaW5pdGlvbjoge1xuICAgIGNyZWF0ZToge1xuICAgICAgdG90YWw6IDAsXG4gICAgfSxcbiAgICBsaXN0OiB7XG4gICAgICB0b3RhbDogMCxcbiAgICB9LFxuICAgIGluZm86IHtcbiAgICAgIHRvdGFsOiAwLFxuICAgIH0sXG4gICAgdXBkYXRlOiB7XG4gICAgICB0b3RhbDogMCxcbiAgICB9LFxuICAgIGRlbGV0ZToge1xuICAgICAgdG90YWw6IDAsXG4gICAgfSxcbiAgfSxcbiAgcmVwb3J0X3NvdXJjZToge1xuICAgIGxpc3Q6IHtcbiAgICAgIHRvdGFsOiAwLFxuICAgIH0sXG4gIH0sXG4gIGRhc2hib2FyZDoge1xuICAgIHBkZjoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgdG90YWw6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gICAgcG5nOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICB0b3RhbDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAgdmlzdWFsaXphdGlvbjoge1xuICAgIHBkZjoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgdG90YWw6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gICAgcG5nOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICB0b3RhbDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAgbm90ZWJvb2s6IHtcbiAgICBwZGY6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIGNvdW50OiAwLFxuICAgICAgfSxcbiAgICB9LFxuICAgIHBuZzoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgY291bnQ6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG4gIHNhdmVkX3NlYXJjaDoge1xuICAgIGNzdjoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgdG90YWw6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG59O1xuXG5leHBvcnQgY29uc3QgREVGQVVMVF9ST0xMSU5HX0NPVU5URVI6IENvdW50ZXJzVHlwZSA9IHtcbiAgcmVwb3J0OiB7XG4gICAgY3JlYXRlOiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgICBjcmVhdGVfZnJvbV9kZWZpbml0aW9uOiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgICBkb3dubG9hZDoge1xuICAgICAgY291bnQ6IDAsXG4gICAgICBzeXN0ZW1fZXJyb3I6IDAsXG4gICAgICB1c2VyX2Vycm9yOiAwLFxuICAgIH0sXG4gICAgbGlzdDoge1xuICAgICAgY291bnQ6IDAsXG4gICAgICBzeXN0ZW1fZXJyb3I6IDAsXG4gICAgICB1c2VyX2Vycm9yOiAwLFxuICAgIH0sXG4gICAgaW5mbzoge1xuICAgICAgY291bnQ6IDAsXG4gICAgICBzeXN0ZW1fZXJyb3I6IDAsXG4gICAgICB1c2VyX2Vycm9yOiAwLFxuICAgIH0sXG4gIH0sXG4gIHJlcG9ydF9kZWZpbml0aW9uOiB7XG4gICAgY3JlYXRlOiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgICBsaXN0OiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgICBpbmZvOiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgICB1cGRhdGU6IHtcbiAgICAgIGNvdW50OiAwLFxuICAgICAgc3lzdGVtX2Vycm9yOiAwLFxuICAgICAgdXNlcl9lcnJvcjogMCxcbiAgICB9LFxuICAgIGRlbGV0ZToge1xuICAgICAgY291bnQ6IDAsXG4gICAgICBzeXN0ZW1fZXJyb3I6IDAsXG4gICAgICB1c2VyX2Vycm9yOiAwLFxuICAgIH0sXG4gIH0sXG4gIHJlcG9ydF9zb3VyY2U6IHtcbiAgICBsaXN0OiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgfSxcbiAgZGFzaGJvYXJkOiB7XG4gICAgcGRmOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICBjb3VudDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBwbmc6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIGNvdW50OiAwLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxuICB2aXN1YWxpemF0aW9uOiB7XG4gICAgcGRmOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICBjb3VudDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBwbmc6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIGNvdW50OiAwLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxuICBub3RlYm9vazoge1xuICAgIHBkZjoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgY291bnQ6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gICAgcG5nOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICBjb3VudDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAgc2F2ZWRfc2VhcmNoOiB7XG4gICAgY3N2OiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICBjb3VudDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbn07XG4iXX0=