"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.preprocessQuery = exports.getIndexPatternFromRawQuery = exports.buildQuery = void 0;

var _datemath = _interopRequireDefault(require("@elastic/datemath"));

var _lodash = require("lodash");

var _explorer = require("../../common/constants/explorer");

var _shared = require("../../common/constants/shared");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const getIndexPatternFromRawQuery = query => {
  const matches = query.match(_shared.PPL_INDEX_REGEX);

  if (matches) {
    return matches[2];
  }

  return '';
}; // insert time filter command and additional commands based on raw query


exports.getIndexPatternFromRawQuery = getIndexPatternFromRawQuery;

const preprocessQuery = ({
  rawQuery,
  startTime,
  endTime,
  timeField,
  isLiveQuery
}) => {
  var _datemath$parse, _datemath$parse2;

  let finalQuery = '';
  if ((0, _lodash.isEmpty)(rawQuery)) return finalQuery; // convert to moment

  const start = (_datemath$parse = _datemath.default.parse(startTime)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.utc().format(_explorer.DATE_PICKER_FORMAT);
  const end = (_datemath$parse2 = _datemath.default.parse(endTime, {
    roundUp: true
  })) === null || _datemath$parse2 === void 0 ? void 0 : _datemath$parse2.utc().format(_explorer.DATE_PICKER_FORMAT);
  const tokens = rawQuery.replaceAll(_shared.PPL_NEWLINE_REGEX, '').match(_shared.PPL_INDEX_INSERT_POINT_REGEX);
  if ((0, _lodash.isEmpty)(tokens)) return finalQuery;
  finalQuery = `${tokens[1]}=${tokens[2]} | where ${timeField} >= '${start}' and ${timeField} <= '${end}'${tokens[3]}`;

  if (isLiveQuery) {
    finalQuery = finalQuery + ` | sort - ${timeField}`;
  }

  return finalQuery;
};

exports.preprocessQuery = preprocessQuery;

const buildQuery = (baseQuery, currQuery) => {
  let fullQuery;

  if (baseQuery) {
    fullQuery = baseQuery;

    if (currQuery) {
      fullQuery += '| ' + currQuery;
    }
  } else {
    fullQuery = currQuery;
  }

  return fullQuery;
};

exports.buildQuery = buildQuery;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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