"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelinePlugin = void 0;

var _i18n = require("@osd/i18n");

var _configSchema = require("@osd/config-schema");

var _saved_objects = require("./saved_objects");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Deprecated since 7.0, the Timeline app will be removed in 8.0.
 * To continue using your Timeline worksheets, migrate them to a dashboard.
 **/
const showWarningMessageIfTimelineSheetWasFound = (core, logger) => {
  const {
    savedObjects
  } = core;
  const savedObjectsClient = savedObjects.createInternalRepository();
  savedObjectsClient.find({
    type: 'timelion-sheet',
    perPage: 1
  }).then(({
    total
  }) => total && logger.warn('Deprecated since 7.0, the Timeline app will be removed in 8.0. To continue using your Timeline worksheets, migrate them to a dashboard.'));
};

class TimelinePlugin {
  constructor(context) {
    _defineProperty(this, "logger", void 0);

    this.logger = context.logger.get();
  }

  setup(core) {
    core.capabilities.registerProvider(() => ({
      timelion: {
        save: true
      }
    }));
    core.savedObjects.registerType(_saved_objects.timelineSheetSavedObjectType);
    core.uiSettings.register({
      'timeline:showTutorial': {
        name: _i18n.i18n.translate('timeline.uiSettings.showTutorialLabel', {
          defaultMessage: 'Show tutorial'
        }),
        value: false,
        description: _i18n.i18n.translate('timeline.uiSettings.showTutorialDescription', {
          defaultMessage: 'Should I show the tutorial by default when entering the timeline app?'
        }),
        category: ['timeline'],
        schema: _configSchema.schema.boolean()
      },
      'timeline:default_columns': {
        name: _i18n.i18n.translate('timeline.uiSettings.defaultColumnsLabel', {
          defaultMessage: 'Default columns'
        }),
        value: 2,
        description: _i18n.i18n.translate('timeline.uiSettings.defaultColumnsDescription', {
          defaultMessage: 'Number of columns on a timeline sheet by default'
        }),
        category: ['timeline'],
        schema: _configSchema.schema.number()
      },
      'timeline:default_rows': {
        name: _i18n.i18n.translate('timeline.uiSettings.defaultRowsLabel', {
          defaultMessage: 'Default rows'
        }),
        value: 2,
        description: _i18n.i18n.translate('timeline.uiSettings.defaultRowsDescription', {
          defaultMessage: 'Number of rows on a timeline sheet by default'
        }),
        category: ['timeline'],
        schema: _configSchema.schema.number()
      }
    });
  }

  start(core) {
    showWarningMessageIfTimelineSheetWasFound(core, this.logger);
  }

  stop() {}

}

exports.TimelinePlugin = TimelinePlugin;