/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.alerting.alerts.AlertIndices;
import org.opensearch.alerting.core.ScheduledJobIndices;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/opensearch/alerting/util/IndexUtils;", "", "()V", "Companion", "opensearch-alerting"})
public final class IndexUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String _META = "_meta";
    @NotNull
    public static final String SCHEMA_VERSION = "schema_version";
    public static final int NO_SCHEMA_VERSION = 0;
    private static int scheduledJobIndexSchemaVersion = Companion.getSchemaVersion(ScheduledJobIndices.Companion.scheduledJobMappings());
    private static int alertIndexSchemaVersion = Companion.getSchemaVersion(AlertIndices.Companion.alertMapping());
    private static int findingIndexSchemaVersion = Companion.getSchemaVersion(AlertIndices.Companion.findingMapping());
    private static boolean scheduledJobIndexUpdated;
    private static boolean alertIndexUpdated;
    private static boolean findingIndexUpdated;
    @Nullable
    private static String lastUpdatedAlertHistoryIndex;
    @Nullable
    private static String lastUpdatedFindingHistoryIndex;

    @JvmStatic
    public static final void scheduledJobIndexUpdated() {
        Companion.scheduledJobIndexUpdated();
    }

    @JvmStatic
    public static final void alertIndexUpdated() {
        Companion.alertIndexUpdated();
    }

    @JvmStatic
    public static final void findingIndexUpdated() {
        Companion.findingIndexUpdated();
    }

    @JvmStatic
    public static final int getSchemaVersion(@NotNull String mapping) {
        return Companion.getSchemaVersion(mapping);
    }

    @JvmStatic
    @NotNull
    public static final String getIndexNameWithAlias(@NotNull ClusterState clusterState, @NotNull String alias) {
        return Companion.getIndexNameWithAlias(clusterState, alias);
    }

    @JvmStatic
    public static final boolean shouldUpdateIndex(@NotNull IndexMetadata index, @NotNull String mapping) {
        return Companion.shouldUpdateIndex(index, mapping);
    }

    @JvmStatic
    public static final void updateIndexMapping(@NotNull String index, @NotNull String mapping, @NotNull ClusterState clusterState, @NotNull IndicesAdminClient client, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
        Companion.updateIndexMapping(index, mapping, clusterState, client, actionListener);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020 H\u0007J\b\u0010\u0012\u001a\u00020 H\u0007J\u0018\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0006H\u0007J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0006H\u0007J\b\u0010\u001e\u001a\u00020 H\u0007J\u0018\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020\u0006H\u0007J6\u0010*\u001a\u00020 2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000bR\u001e\u0010\u001e\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000f\u00a8\u00060"}, d2={"Lorg/opensearch/alerting/util/IndexUtils$Companion;", "", "()V", "NO_SCHEMA_VERSION", "", "SCHEMA_VERSION", "", "_META", "<set-?>", "alertIndexSchemaVersion", "getAlertIndexSchemaVersion", "()I", "", "alertIndexUpdated", "getAlertIndexUpdated", "()Z", "findingIndexSchemaVersion", "getFindingIndexSchemaVersion", "findingIndexUpdated", "getFindingIndexUpdated", "lastUpdatedAlertHistoryIndex", "getLastUpdatedAlertHistoryIndex", "()Ljava/lang/String;", "setLastUpdatedAlertHistoryIndex", "(Ljava/lang/String;)V", "lastUpdatedFindingHistoryIndex", "getLastUpdatedFindingHistoryIndex", "setLastUpdatedFindingHistoryIndex", "scheduledJobIndexSchemaVersion", "getScheduledJobIndexSchemaVersion", "scheduledJobIndexUpdated", "getScheduledJobIndexUpdated", "", "getIndexNameWithAlias", "clusterState", "Lorg/opensearch/cluster/ClusterState;", "alias", "getSchemaVersion", "mapping", "shouldUpdateIndex", "index", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "updateIndexMapping", "client", "Lorg/opensearch/client/IndicesAdminClient;", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        public final int getScheduledJobIndexSchemaVersion() {
            return scheduledJobIndexSchemaVersion;
        }

        public final int getAlertIndexSchemaVersion() {
            return alertIndexSchemaVersion;
        }

        public final int getFindingIndexSchemaVersion() {
            return findingIndexSchemaVersion;
        }

        public final boolean getScheduledJobIndexUpdated() {
            return scheduledJobIndexUpdated;
        }

        public final boolean getAlertIndexUpdated() {
            return alertIndexUpdated;
        }

        public final boolean getFindingIndexUpdated() {
            return findingIndexUpdated;
        }

        @Nullable
        public final String getLastUpdatedAlertHistoryIndex() {
            return lastUpdatedAlertHistoryIndex;
        }

        public final void setLastUpdatedAlertHistoryIndex(@Nullable String string) {
            lastUpdatedAlertHistoryIndex = string;
        }

        @Nullable
        public final String getLastUpdatedFindingHistoryIndex() {
            return lastUpdatedFindingHistoryIndex;
        }

        public final void setLastUpdatedFindingHistoryIndex(@Nullable String string) {
            lastUpdatedFindingHistoryIndex = string;
        }

        @JvmStatic
        public final void scheduledJobIndexUpdated() {
            scheduledJobIndexUpdated = true;
        }

        @JvmStatic
        public final void alertIndexUpdated() {
            alertIndexUpdated = true;
        }

        @JvmStatic
        public final void findingIndexUpdated() {
            findingIndexUpdated = true;
        }

        @JvmStatic
        public final int getSchemaVersion(@NotNull String mapping) {
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            XContentParser xcp = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mapping);
            while (!xcp.isClosed()) {
                XContentParser.Token token = xcp.currentToken();
                if (token != null && token != XContentParser.Token.END_OBJECT && token != XContentParser.Token.START_OBJECT) {
                    if (!Intrinsics.areEqual((Object)xcp.currentName(), (Object)IndexUtils._META)) {
                        xcp.nextToken();
                        xcp.skipChildren();
                    } else {
                        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                            if (Intrinsics.areEqual((Object)xcp.currentName(), (Object)IndexUtils.SCHEMA_VERSION)) {
                                int version = xcp.intValue();
                                if (!(version > -1)) {
                                    String string = "Failed requirement.";
                                    throw new IllegalArgumentException(string.toString());
                                }
                                return version;
                            }
                            xcp.nextToken();
                        }
                    }
                }
                xcp.nextToken();
            }
            return 0;
        }

        @JvmStatic
        @NotNull
        public final String getIndexNameWithAlias(@NotNull ClusterState clusterState, @NotNull String alias) {
            Object element$iv2;
            block1: {
                Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
                Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
                ImmutableOpenMap immutableOpenMap = clusterState.getMetadata().getIndices();
                Intrinsics.checkNotNullExpressionValue((Object)immutableOpenMap, (String)"clusterState.metadata.indices");
                Iterable $this$first$iv = (Iterable)immutableOpenMap;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    ObjectObjectCursor it = (ObjectObjectCursor)element$iv2;
                    boolean bl = false;
                    if (!((IndexMetadata)it.value).getAliases().containsKey((Object)alias)) continue;
                    break block1;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object object = ((ObjectObjectCursor)element$iv2).key;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clusterState.metadata.in\u2026.containsKey(alias) }.key");
            return (String)object;
        }

        @JvmStatic
        public final boolean shouldUpdateIndex(@NotNull IndexMetadata index, @NotNull String mapping) {
            Map indexMapping;
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            int oldVersion = 0;
            int newVersion = this.getSchemaVersion(mapping);
            MappingMetadata mappingMetadata = index.mapping();
            Map map = indexMapping = mappingMetadata == null ? null : mappingMetadata.sourceAsMap();
            if (indexMapping != null && indexMapping.containsKey(IndexUtils._META) && indexMapping.get(IndexUtils._META) instanceof HashMap) {
                Object v = indexMapping.get(IndexUtils._META);
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.util.HashMap<*, *>{ kotlin.collections.TypeAliasesKt.HashMap<*, *> }");
                }
                HashMap metaData = (HashMap)v;
                if (((Map)metaData).containsKey(IndexUtils.SCHEMA_VERSION)) {
                    Object v2 = ((Map)metaData).get(IndexUtils.SCHEMA_VERSION);
                    if (v2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    oldVersion = (Integer)v2;
                }
            }
            return newVersion > oldVersion;
        }

        @JvmStatic
        public final void updateIndexMapping(@NotNull String index, @NotNull String mapping, @NotNull ClusterState clusterState, @NotNull IndicesAdminClient client, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            if (clusterState.getMetadata().getIndices().containsKey((Object)index)) {
                Object object = clusterState.getMetadata().getIndices().get((Object)index);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clusterState.metadata.indices[index]");
                if (this.shouldUpdateIndex((IndexMetadata)object, mapping)) {
                    String[] stringArray = new String[]{index};
                    PutMappingRequest putMappingRequest = new PutMappingRequest(stringArray).source(mapping, XContentType.JSON);
                    Intrinsics.checkNotNullExpressionValue((Object)putMappingRequest, (String)"PutMappingRequest(index)\u2026pping, XContentType.JSON)");
                    PutMappingRequest putMappingRequest2 = putMappingRequest;
                    client.putMapping(putMappingRequest2, actionListener);
                } else {
                    actionListener.onResponse((Object)new AcknowledgedResponse(true));
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

