/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionType;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.alerting.action.DeleteMonitorRequest;
import org.opensearch.alerting.core.model.ScheduledJob;
import org.opensearch.alerting.model.Monitor;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequestBuilder;
import org.opensearch.rest.RestStatus;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001'B7\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J&\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00022\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&H\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Lorg/opensearch/alerting/transport/TransportDeleteMonitorAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/action/DeleteMonitorRequest;", "Lorg/opensearch/action/delete/DeleteResponse;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/common/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "getFilterByEnabled", "()Ljava/lang/Boolean;", "setFilterByEnabled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getXContentRegistry", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/action/ActionListener;", "DeleteMonitorHandler", "opensearch-alerting"})
public final class TransportDeleteMonitorAction
extends HandledTransportAction<DeleteMonitorRequest, DeleteResponse>
implements SecureTransportAction {
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportDeleteMonitorAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/alerting/monitor/delete", transportService, actionFilters, DeleteMonitorRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(settings);
        this.listenFilterBySettingChange(this.clusterService);
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    public Boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    public void setFilterByEnabled(Boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull DeleteMonitorRequest request, @NotNull ActionListener<DeleteResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        User user = this.readUserFromThreadContext(this.client);
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".opendistro-alerting-config", request.getMonitorId()).setRefreshPolicy(request.getRefreshPolicy());
        if (!this.validateUserBackendRoles(user, actionListener)) {
            return;
        }
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            Client client = this.getClient();
            Intrinsics.checkNotNullExpressionValue((Object)deleteRequest, (String)"deleteRequest");
            new DeleteMonitorHandler(client, actionListener, deleteRequest, user, request.getMonitorId()).resolveUserAndStart();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.DefaultImpls.listenFilterBySettingChange(this, clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.DefaultImpls.readUserFromThreadContext(this, client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.doFilterForUser(this, user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.DefaultImpls.validateUserBackendRoles(this, user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.DefaultImpls.checkUserPermissionsWithResource(this, requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u000fJ\u0006\u0010\u0016\u001a\u00020\u000fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/opensearch/alerting/transport/TransportDeleteMonitorAction$DeleteMonitorHandler;", "", "client", "Lorg/opensearch/client/Client;", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/action/delete/DeleteResponse;", "deleteRequest", "Lorg/opensearch/action/delete/DeleteRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "monitorId", "", "(Lorg/opensearch/alerting/transport/TransportDeleteMonitorAction;Lorg/opensearch/client/Client;Lorg/opensearch/action/ActionListener;Lorg/opensearch/action/delete/DeleteRequest;Lorg/opensearch/commons/authuser/User;Ljava/lang/String;)V", "deleteDocLevelMonitorQueries", "", "deleteMetadata", "deleteMonitor", "onGetResponse", "monitor", "Lorg/opensearch/alerting/model/Monitor;", "resolveUserAndStart", "start", "opensearch-alerting"})
    public final class DeleteMonitorHandler {
        @NotNull
        private final Client client;
        @NotNull
        private final ActionListener<DeleteResponse> actionListener;
        @NotNull
        private final DeleteRequest deleteRequest;
        @Nullable
        private final User user;
        @NotNull
        private final String monitorId;

        public DeleteMonitorHandler(@NotNull Client client, @NotNull ActionListener<DeleteResponse> actionListener, @Nullable DeleteRequest deleteRequest, @NotNull User user, String monitorId) {
            Intrinsics.checkNotNullParameter((Object)TransportDeleteMonitorAction.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)deleteRequest, (String)"deleteRequest");
            Intrinsics.checkNotNullParameter((Object)monitorId, (String)"monitorId");
            this.client = client;
            this.actionListener = actionListener;
            this.deleteRequest = deleteRequest;
            this.user = user;
            this.monitorId = monitorId;
        }

        public final void resolveUserAndStart() {
            if (this.user == null) {
                this.deleteMonitor();
            } else if (!TransportDeleteMonitorAction.this.doFilterForUser(this.user)) {
                this.deleteMonitor();
            } else {
                try {
                    this.start();
                }
                catch (IOException ex) {
                    this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(ex));
                }
            }
        }

        public final void start() {
            GetRequest getRequest = new GetRequest(".opendistro-alerting-config", this.monitorId);
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(this, TransportDeleteMonitorAction.this){
                final /* synthetic */ DeleteMonitorHandler this$0;
                final /* synthetic */ TransportDeleteMonitorAction this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void onResponse(@NotNull GetResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        DeleteMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Monitor with " + DeleteMonitorHandler.access$getMonitorId$p(this.this$0) + " is not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.this$1.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (XContentType)XContentType.JSON);
                    Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                    String string = response2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                    Monitor monitor = (Monitor)ScheduledJob.Companion.parse(xcp, string, response2.getVersion());
                    DeleteMonitorHandler.access$onGetResponse(this.this$0, monitor);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    DeleteMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
            });
        }

        private final void onGetResponse(Monitor monitor) {
            if (!TransportDeleteMonitorAction.this.checkUserPermissionsWithResource(this.user, monitor.getUser(), this.actionListener, "monitor", this.monitorId)) {
                return;
            }
            this.deleteMonitor();
        }

        private final void deleteMonitor() {
            this.client.delete(this.deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(TransportDeleteMonitorAction.this, this){
                final /* synthetic */ TransportDeleteMonitorAction this$0;
                final /* synthetic */ DeleteMonitorHandler this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void onResponse(@NotNull DeleteResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    ClusterState clusterState = this.this$0.getClusterService().state();
                    if (clusterState.getRoutingTable().hasIndex(".opensearch-alerting-queries")) {
                        DeleteMonitorHandler.access$deleteDocLevelMonitorQueries(this.this$1);
                    }
                    DeleteMonitorHandler.access$deleteMetadata(this.this$1);
                    DeleteMonitorHandler.access$getActionListener$p(this.this$1).onResponse((Object)response2);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    DeleteMonitorHandler.access$getActionListener$p(this.this$1).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
            });
        }

        private final void deleteMetadata() {
            GetRequest getRequest = new GetRequest(".opendistro-alerting-config", this.monitorId);
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(this){
                final /* synthetic */ DeleteMonitorHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull GetResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (response2.isExists()) {
                        DeleteRequest deleteMetadataRequest = (DeleteRequest)new DeleteRequest(".opendistro-alerting-config", String.valueOf(DeleteMonitorHandler.access$getMonitorId$p(this.this$0))).setRefreshPolicy(DeleteMonitorHandler.access$getDeleteRequest$p(this.this$0).getRefreshPolicy());
                        DeleteMonitorHandler.access$getClient$p(this.this$0).delete(deleteMetadataRequest, (ActionListener)new ActionListener<DeleteResponse>(){

                            public void onResponse(@NotNull DeleteResponse response2) {
                                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                            }

                            public void onFailure(@NotNull Exception t) {
                                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                            }
                        });
                    }
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                }
            });
        }

        private final void deleteDocLevelMonitorQueries() {
            String[] stringArray = new String[]{".opensearch-alerting-queries"};
            ((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)new DeleteByQueryRequestBuilder((OpenSearchClient)this.client, (ActionType)DeleteByQueryAction.INSTANCE).source(stringArray)).filter((QueryBuilder)QueryBuilders.matchQuery((String)"monitor_id", (Object)this.monitorId))).execute((ActionListener)new ActionListener<BulkByScrollResponse>(){

                public void onResponse(@NotNull BulkByScrollResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                }
            });
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(DeleteMonitorHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ String access$getMonitorId$p(DeleteMonitorHandler $this) {
            return $this.monitorId;
        }

        public static final /* synthetic */ void access$onGetResponse(DeleteMonitorHandler $this, Monitor monitor) {
            $this.onGetResponse(monitor);
        }

        public static final /* synthetic */ void access$deleteDocLevelMonitorQueries(DeleteMonitorHandler $this) {
            $this.deleteDocLevelMonitorQueries();
        }

        public static final /* synthetic */ void access$deleteMetadata(DeleteMonitorHandler $this) {
            $this.deleteMetadata();
        }

        public static final /* synthetic */ DeleteRequest access$getDeleteRequest$p(DeleteMonitorHandler $this) {
            return $this.deleteRequest;
        }

        public static final /* synthetic */ Client access$getClient$p(DeleteMonitorHandler $this) {
            return $this.client;
        }
    }
}

