/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.model;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.alerts.AlertError;
import org.opensearch.alerting.model.InputRunResults;
import org.opensearch.alerting.model.MonitorRunResultKt;
import org.opensearch.alerting.model.Trigger;
import org.opensearch.alerting.model.TriggerRunResult;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 <*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\u0001<B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007BO\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0010\b\u0002\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010 \u001a\u0004\u0018\u00010!J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\u000bH\u00c6\u0003J\t\u0010$\u001a\u00020\u000bH\u00c6\u0003J\u0011\u0010%\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000fH\u00c6\u0003J\t\u0010&\u001a\u00020\u0011H\u00c6\u0003J\u0015\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\u0013H\u00c6\u0003J_\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\u0010\b\u0002\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\u0013H\u00c6\u0001J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\u0016\u0010/\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f2\u0006\u00100\u001a\u000201J\t\u00102\u001a\u00020\tH\u00d6\u0001J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016R\u0019\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006="}, d2={"Lorg/opensearch/alerting/model/MonitorRunResult;", "TriggerResult", "Lorg/opensearch/alerting/model/TriggerRunResult;", "Lorg/opensearch/common/io/stream/Writeable;", "Lorg/opensearch/common/xcontent/ToXContent;", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "monitorName", "", "periodStart", "Ljava/time/Instant;", "periodEnd", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "inputResults", "Lorg/opensearch/alerting/model/InputRunResults;", "triggerResults", "", "(Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/Exception;Lorg/opensearch/alerting/model/InputRunResults;Ljava/util/Map;)V", "getError", "()Ljava/lang/Exception;", "getInputResults", "()Lorg/opensearch/alerting/model/InputRunResults;", "getMonitorName", "()Ljava/lang/String;", "getPeriodEnd", "()Ljava/time/Instant;", "getPeriodStart", "getTriggerResults", "()Ljava/util/Map;", "alertError", "Lorg/opensearch/alerting/alerts/AlertError;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "scriptContextError", "trigger", "Lorg/opensearch/alerting/model/Trigger;", "toString", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "opensearch-alerting"})
public final class MonitorRunResult<TriggerResult extends TriggerRunResult>
implements Writeable,
ToXContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String monitorName;
    @NotNull
    private final Instant periodStart;
    @NotNull
    private final Instant periodEnd;
    @Nullable
    private final Exception error;
    @NotNull
    private final InputRunResults inputResults;
    @NotNull
    private final Map<String, TriggerResult> triggerResults;

    public MonitorRunResult(@NotNull String monitorName, @NotNull Instant periodStart, @NotNull Instant periodEnd, @Nullable Exception error, @NotNull InputRunResults inputResults, @NotNull Map<String, ? extends TriggerResult> triggerResults) {
        Intrinsics.checkNotNullParameter((Object)monitorName, (String)"monitorName");
        Intrinsics.checkNotNullParameter((Object)periodStart, (String)"periodStart");
        Intrinsics.checkNotNullParameter((Object)periodEnd, (String)"periodEnd");
        Intrinsics.checkNotNullParameter((Object)inputResults, (String)"inputResults");
        Intrinsics.checkNotNullParameter(triggerResults, (String)"triggerResults");
        this.monitorName = monitorName;
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.error = error;
        this.inputResults = inputResults;
        this.triggerResults = triggerResults;
    }

    public /* synthetic */ MonitorRunResult(String string, Instant instant, Instant instant2, Exception exception, InputRunResults inputRunResults, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            exception = null;
        }
        if ((n & 0x10) != 0) {
            inputRunResults = new InputRunResults(null, null, null, 7, null);
        }
        if ((n & 0x20) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string, instant, instant2, exception, inputRunResults, map);
    }

    @NotNull
    public final String getMonitorName() {
        return this.monitorName;
    }

    @NotNull
    public final Instant getPeriodStart() {
        return this.periodStart;
    }

    @NotNull
    public final Instant getPeriodEnd() {
        return this.periodEnd;
    }

    @Nullable
    public final Exception getError() {
        return this.error;
    }

    @NotNull
    public final InputRunResults getInputResults() {
        return this.inputResults;
    }

    @NotNull
    public final Map<String, TriggerResult> getTriggerResults() {
        return this.triggerResults;
    }

    public MonitorRunResult(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        Object object = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readString()");
        String string = object;
        object = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readInstant()");
        Object object2 = object;
        object = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readInstant()");
        this(string, (Instant)object2, (Instant)object, sin.readException(), InputRunResults.Companion.readFrom(sin), Companion.suppressWarning(sin.readMap()));
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        XContentBuilder xContentBuilder = builder.startObject().field("monitor_name", this.monitorName);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026nitor_name\", monitorName)");
        Exception exception = this.error;
        XContentBuilder xContentBuilder2 = OpenSearchExtensionsKt.optionalTimeField((XContentBuilder)OpenSearchExtensionsKt.optionalTimeField((XContentBuilder)xContentBuilder, (String)"period_start", (Instant)this.periodStart), (String)"period_end", (Instant)this.periodEnd).field("error", (String)(exception == null ? null : exception.getMessage())).field("input_results", (ToXContent)this.inputResults).field("trigger_results", this.triggerResults).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder2;
    }

    @Nullable
    public final AlertError alertError() {
        if (this.error != null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            return new AlertError(instant, "Failed running monitor:\n" + MonitorRunResultKt.userErrorMessage(this.error));
        }
        if (this.inputResults.getError() != null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            return new AlertError(instant, "Failed fetching inputs:\n" + MonitorRunResultKt.userErrorMessage(this.inputResults.getError()));
        }
        return null;
    }

    @Nullable
    public final Exception scriptContextError(@NotNull Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Exception exception = this.error;
        if (exception == null && (exception = this.inputResults.getError()) == null) {
            TriggerRunResult triggerRunResult = (TriggerRunResult)this.triggerResults.get(trigger.getId());
            exception = triggerRunResult == null ? null : triggerRunResult.getError();
        }
        return exception;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.monitorName);
        out.writeInstant(this.periodStart);
        out.writeInstant(this.periodEnd);
        out.writeException((Throwable)this.error);
        this.inputResults.writeTo(out);
        out.writeMap(this.triggerResults);
    }

    @NotNull
    public final String component1() {
        return this.monitorName;
    }

    @NotNull
    public final Instant component2() {
        return this.periodStart;
    }

    @NotNull
    public final Instant component3() {
        return this.periodEnd;
    }

    @Nullable
    public final Exception component4() {
        return this.error;
    }

    @NotNull
    public final InputRunResults component5() {
        return this.inputResults;
    }

    @NotNull
    public final Map<String, TriggerResult> component6() {
        return this.triggerResults;
    }

    @NotNull
    public final MonitorRunResult<TriggerResult> copy(@NotNull String monitorName, @NotNull Instant periodStart, @NotNull Instant periodEnd, @Nullable Exception error, @NotNull InputRunResults inputResults, @NotNull Map<String, ? extends TriggerResult> triggerResults) {
        Intrinsics.checkNotNullParameter((Object)monitorName, (String)"monitorName");
        Intrinsics.checkNotNullParameter((Object)periodStart, (String)"periodStart");
        Intrinsics.checkNotNullParameter((Object)periodEnd, (String)"periodEnd");
        Intrinsics.checkNotNullParameter((Object)inputResults, (String)"inputResults");
        Intrinsics.checkNotNullParameter(triggerResults, (String)"triggerResults");
        return new MonitorRunResult<TriggerResult>(monitorName, periodStart, periodEnd, error, inputResults, triggerResults);
    }

    public static /* synthetic */ MonitorRunResult copy$default(MonitorRunResult monitorRunResult, String string, Instant instant, Instant instant2, Exception exception, InputRunResults inputRunResults, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = monitorRunResult.monitorName;
        }
        if ((n & 2) != 0) {
            instant = monitorRunResult.periodStart;
        }
        if ((n & 4) != 0) {
            instant2 = monitorRunResult.periodEnd;
        }
        if ((n & 8) != 0) {
            exception = monitorRunResult.error;
        }
        if ((n & 0x10) != 0) {
            inputRunResults = monitorRunResult.inputResults;
        }
        if ((n & 0x20) != 0) {
            map = monitorRunResult.triggerResults;
        }
        return monitorRunResult.copy(string, instant, instant2, exception, inputRunResults, map);
    }

    @NotNull
    public String toString() {
        return "MonitorRunResult(monitorName=" + this.monitorName + ", periodStart=" + this.periodStart + ", periodEnd=" + this.periodEnd + ", error=" + this.error + ", inputResults=" + this.inputResults + ", triggerResults=" + this.triggerResults + ")";
    }

    public int hashCode() {
        int result = this.monitorName.hashCode();
        result = result * 31 + this.periodStart.hashCode();
        result = result * 31 + this.periodEnd.hashCode();
        result = result * 31 + (this.error == null ? 0 : this.error.hashCode());
        result = result * 31 + this.inputResults.hashCode();
        result = result * 31 + ((Object)this.triggerResults).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MonitorRunResult)) {
            return false;
        }
        MonitorRunResult monitorRunResult = (MonitorRunResult)other;
        if (!Intrinsics.areEqual((Object)this.monitorName, (Object)monitorRunResult.monitorName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.periodStart, (Object)monitorRunResult.periodStart)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.periodEnd, (Object)monitorRunResult.periodEnd)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.error, (Object)monitorRunResult.error)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.inputResults, (Object)monitorRunResult.inputResults)) {
            return false;
        }
        return Intrinsics.areEqual(this.triggerResults, monitorRunResult.triggerResults);
    }

    @JvmStatic
    @NotNull
    public static final MonitorRunResult<TriggerRunResult> readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J,\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t2\u0018\u0010\u000b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\f\u00a8\u0006\r"}, d2={"Lorg/opensearch/alerting/model/MonitorRunResult$Companion;", "", "()V", "readFrom", "Lorg/opensearch/alerting/model/MonitorRunResult;", "Lorg/opensearch/alerting/model/TriggerRunResult;", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "suppressWarning", "", "", "map", "", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MonitorRunResult<TriggerRunResult> readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new MonitorRunResult<TriggerRunResult>(sin);
        }

        @NotNull
        public final Map<String, TriggerRunResult> suppressWarning(@Nullable Map<String, Object> map) {
            Map<String, Object> map2 = map;
            if (map2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.opensearch.alerting.model.TriggerRunResult>");
            }
            return map2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

